/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.retry;

public interface RetryStrategy {

    /**
     * Returns a retry policy object of the same type that has not been retried yet.
     *
     * @return a retry policy object of the same type that has not been retried yet.
     */
    public RetryStrategy clone();

    /**
     * Returns the current number of retries
     *
     * @return the current number of retries
     */
    public int getRetries();

    /**
     * Decides in current situation whether or not the RPC should retry and if it should retry how
     * long the backoff should be.
     *
     * @param requestCode request code
     * @param ex          last access failed exception (error message)
     * @return retryPlan if it should retry how long the backoff should be
     */
    public RetryPlan makeRetryDecision(int requestCode, Throwable ex);

    /**
     * Decides in current situation whether or not the RPC should retry and if it should retry how
     * long the backoff should be.
     *
     * @param ex          last access failed exception (error message)
     * @return retryPlan if it should retry how long the backoff should be
     */
    public RetryPlan makeRetryDecision(Throwable ex);

}
