/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common.utils;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;

import java.util.concurrent.atomic.AtomicLong;

public class EclipseCounter {
    private AtomicLong counter = new AtomicLong(0);
    private AtomicLong eclipse = new AtomicLong(0);
    private long lastPrintTime = 0;
    private int printInterval = 10000;
    private final String prefix;
    InternalLogger log;

    public EclipseCounter(int printInterval, String prefix, InternalLogger log) {
        this.printInterval = printInterval;
        this.prefix = prefix;
        this.log = log;
    }

    public void mark(int add, long eclipse) {
        mark(add, eclipse, System.currentTimeMillis());
    }

    public void mark(int add, long eclipse, long now) {
        long count = this.counter.addAndGet(add);
        long time = this.eclipse.addAndGet(eclipse);

        if (lastPrintTime == 0 && count > 1 || count > 0 && now - lastPrintTime > printInterval) {
            float avg = time / (float) count;
            avg = avg > 0.001f ? avg : 0.001f;
            log.info("[{}]{}Count:{}, {}Time:{}, {}AVG:{}",
                prefix, prefix, count, prefix, time, prefix, avg);
            this.counter.set(0);
            this.eclipse.set(0);
            lastPrintTime = now;
        }
    }
}
