package com.aliyun.openservices.shade.io.prometheus.client.exemplars.tracer.otel;

import com.aliyun.openservices.shade.io.opentelemetry.api.trace.Span;
import com.aliyun.openservices.shade.io.opentelemetry.api.trace.SpanId;
import com.aliyun.openservices.shade.io.opentelemetry.api.trace.TraceId;
import com.aliyun.openservices.shade.io.prometheus.client.exemplars.tracer.common.SpanContextSupplier;

public class OpenTelemetrySpanContextSupplier implements SpanContextSupplier {

  public static boolean isAvailable() {
    try {
      if ("inactive".equalsIgnoreCase(System.getProperties().getProperty("com.aliyun.openservices.shade.io.prometheus.otelExemplars"))) {
        return false;
      }
      OpenTelemetrySpanContextSupplier test = new OpenTelemetrySpanContextSupplier();
      test.getSpanId();
      test.getTraceId();
      return true;
    } catch (LinkageError ignored) {
      // NoClassDefFoundError:
      //   Either OpenTelemetry is not present, or it is version 0.9.1 or older when com.aliyun.openservices.shade.io.opentelemetry.api.trace.Span did not exist.
      // IncompatibleClassChangeError:
      //   The application uses an OpenTelemetry version between 0.10.0 and 0.15.0 when SpanContext was a class, and not an interface.
      return false;
    }
  }

  @Override
  public String getTraceId() {
    String traceId = Span.current().getSpanContext().getTraceId();
    return TraceId.isValid(traceId) ? traceId : null;
  }

  @Override
  public String getSpanId() {
    String spanId = Span.current().getSpanContext().getSpanId();
    return SpanId.isValid(spanId) ? spanId : null;
  }
}
