/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api;

import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.ONSFactoryAPI;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.PullConsumer;
import com.aliyun.openservices.ons.api.batch.BatchConsumer;
import com.aliyun.openservices.ons.api.order.OrderConsumer;
import com.aliyun.openservices.ons.api.order.OrderProducer;
import com.aliyun.openservices.ons.api.transaction.LocalTransactionChecker;
import com.aliyun.openservices.ons.api.transaction.TransactionProducer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.retry.DefaultConsumerRetryStrategy;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.retry.DefaultProducerRetryStrategy;
import java.util.Properties;

public class ONSFactory {
    private static ONSFactoryAPI onsFactory = null;

    public static Producer createProducer(Properties properties) {
        return ONSFactory.createProducer(properties, new DefaultProducerRetryStrategy());
    }

    public static Producer createProducer(Properties properties, DefaultProducerRetryStrategy retryStrategy) {
        return onsFactory.createProducer(properties, retryStrategy);
    }

    public static OrderProducer createOrderProducer(Properties properties) {
        return ONSFactory.createOrderProducer(properties, new DefaultProducerRetryStrategy());
    }

    public static OrderProducer createOrderProducer(Properties properties, DefaultProducerRetryStrategy retryStrategy) {
        return onsFactory.createOrderProducer(properties, retryStrategy);
    }

    public static TransactionProducer createTransactionProducer(Properties properties, LocalTransactionChecker checker) {
        return ONSFactory.createTransactionProducer(properties, checker, new DefaultProducerRetryStrategy());
    }

    public static TransactionProducer createTransactionProducer(Properties properties, LocalTransactionChecker checker, DefaultProducerRetryStrategy retryStrategy) {
        return onsFactory.createTransactionProducer(properties, checker, retryStrategy);
    }

    public static Consumer createConsumer(Properties properties) {
        return ONSFactory.createConsumer(properties, new DefaultConsumerRetryStrategy());
    }

    public static Consumer createConsumer(Properties properties, DefaultConsumerRetryStrategy retryStrategy) {
        return onsFactory.createConsumer(properties, retryStrategy);
    }

    public static BatchConsumer createBatchConsumer(Properties properties) {
        return onsFactory.createBatchConsumer(properties);
    }

    public static OrderConsumer createOrderedConsumer(Properties properties) {
        return onsFactory.createOrderedConsumer(properties);
    }

    public static OrderConsumer createOrderedConsumer(Properties properties, DefaultConsumerRetryStrategy retryStrategy) {
        return onsFactory.createOrderedConsumer(properties, retryStrategy);
    }

    public static PullConsumer createPullConsumer(Properties properties) {
        return onsFactory.createPullConsumer(properties);
    }

    static {
        try {
            Class<?> factoryClass = ONSFactory.class.getClassLoader().loadClass("com.aliyun.openservices.ons.api.impl.ONSFactoryNotifyAndMetaQImpl");
            onsFactory = (ONSFactoryAPI)factoryClass.newInstance();
        }
        catch (Throwable e) {
            try {
                Class<?> factoryClass = ONSFactory.class.getClassLoader().loadClass("com.aliyun.openservices.ons.api.impl.ONSFactoryImpl");
                onsFactory = (ONSFactoryAPI)factoryClass.newInstance();
            }
            catch (Throwable e1) {
                e.printStackTrace();
                e1.printStackTrace();
            }
        }
    }
}

