/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.impl.rocketmq;

import com.aliyun.openservices.ons.api.impl.auth.StsCredentials;
import com.aliyun.openservices.ons.api.impl.authority.SessionCredentials;
import com.aliyun.openservices.ons.api.impl.authority.SessionCredentialsProvider;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSClientAbstract;
import com.aliyun.openservices.ons.api.impl.util.ClientLoggerUtil;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONException;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.ThreadFactoryImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.utils.HttpTinyClient;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class StsSessionCredentialsProvider
implements SessionCredentialsProvider {
    private static final String URL_ECS_RAM_ROLE = "http://100.100.100.200/latest/meta-data/Ram/security-credentials/";
    private static final InternalLogger LOGGER = ClientLoggerUtil.getClientLogger();
    private static final long DEFAULT_REFRESH_INTERVAL_MILLIS = 108000000L;
    private static final long MIN_REFRESH_INTERVAL_MILLIS = 5000L;
    private static final long HTTP_TIMEOUT_MILLIS = 3000L;
    private final ONSClientAbstract client;
    private final String ramRoleName;
    private final SessionCredentials sessionCredentials;
    private final ScheduledExecutorService scheduledExecutorService = new ScheduledThreadPoolExecutor(1, new ThreadFactoryImpl("ONSRamRoleStsTokenUpdater"));

    public StsSessionCredentialsProvider(ONSClientAbstract client, String ramRoleName) {
        this.client = client;
        this.ramRoleName = ramRoleName;
        this.sessionCredentials = new SessionCredentials(client.sessionCredentials);
        this.refreshToken(ramRoleName);
    }

    private void refreshToken(String ramRoleName) {
        StsCredentials stsCredentials = this.fetchStsCredentialsByRamRole(ramRoleName);
        if (stsCredentials != null) {
            this.sessionCredentials.setAccessKey(stsCredentials.getAccessKeyId());
            this.sessionCredentials.setSecretKey(stsCredentials.getAccessKeySecret());
            this.sessionCredentials.setSecurityToken(stsCredentials.getSecurityToken());
            this.client.sessionCredentials = this.sessionCredentials;
            LOGGER.info("update sts credentials success, ramRoleName={}", (Object)ramRoleName);
            this.dispatchTokenRefreshTask(stsCredentials);
        } else {
            this.dispatchTokenRefreshTask(ramRoleName, 5000L);
        }
    }

    private void dispatchTokenRefreshTask(StsCredentials stsCredentials) {
        long now = System.currentTimeMillis();
        long interval = stsCredentials.getExpiration() - now;
        long delay = interval > 108000000L ? stsCredentials.getExpiration() - now - 108000000L : Math.max(5000L, (stsCredentials.getExpiration() - now) / 2L);
        this.dispatchTokenRefreshTask(stsCredentials.getRamRoleName(), delay);
    }

    private void dispatchTokenRefreshTask(final String ramRoleName, long delay) {
        this.scheduledExecutorService.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    StsSessionCredentialsProvider.this.refreshToken(ramRoleName);
                }
                catch (Throwable t) {
                    LOGGER.error("Unexpected exception raised while refreshing sts token, ramRoleName={}", (Object)ramRoleName, (Object)t);
                }
            }
        }, delay, TimeUnit.MILLISECONDS);
    }

    private StsCredentials fetchStsCredentialsByRamRole(String ramRoleName) {
        try {
            HttpTinyClient.HttpResult result = HttpTinyClient.httpGet(URL_ECS_RAM_ROLE + ramRoleName, null, null, "UTF-8", 3000L);
            if (200 != result.code || null == result.content || "".equals(result.content)) {
                LOGGER.error("fetch sts credentials by ram role[ " + ramRoleName + " ] error. please set right ram role");
            }
            JSONObject jsonObject = JSONObject.parseObject(result.content);
            StsCredentials stsCredentials = new StsCredentials();
            stsCredentials.setRamRoleName(ramRoleName);
            stsCredentials.setAccessKeyId(jsonObject.getString("AccessKeyId"));
            stsCredentials.setAccessKeySecret(jsonObject.getString("AccessKeySecret"));
            stsCredentials.setSecurityToken(jsonObject.getString("SecurityToken"));
            SimpleDateFormat utcFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            utcFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            stsCredentials.setExpiration(utcFormatter.parse(jsonObject.getString("Expiration")).getTime());
            return stsCredentials;
        }
        catch (JSONException e) {
            LOGGER.error("fetch sts credentials by ram role[ " + ramRoleName + " ] error", e);
        }
        catch (Exception e) {
            LOGGER.error("fetch sts credentials by ram role[ " + ramRoleName + " ] error", e);
        }
        return null;
    }

    @Override
    public SessionCredentials getSessionCredentials() {
        return this.client.sessionCredentials;
    }
}

