/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.AllocateMessageQueueStrategy;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.DefaultLitePullConsumer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.MessageQueueListener;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.store.OffsetStore;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.store.ReadOffsetType;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQClientException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.DefaultLitePullConsumerImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.ProcessQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.PullRequest;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.RebalanceImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.factory.MQClientInstance;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.consumer.ConsumeFromWhere;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.heartbeat.ConsumeType;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.heartbeat.MessageModel;
import com.aliyun.openservices.shade.com.google.common.base.Optional;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class RebalanceLitePullImpl
extends RebalanceImpl {
    private final DefaultLitePullConsumerImpl litePullConsumerImpl;

    public RebalanceLitePullImpl(DefaultLitePullConsumerImpl litePullConsumerImpl) {
        this(null, null, null, null, litePullConsumerImpl);
    }

    public RebalanceLitePullImpl(String consumerGroup, MessageModel messageModel, AllocateMessageQueueStrategy allocateMessageQueueStrategy, MQClientInstance mQClientFactory, DefaultLitePullConsumerImpl litePullConsumerImpl) {
        super(consumerGroup, messageModel, allocateMessageQueueStrategy, mQClientFactory);
        this.litePullConsumerImpl = litePullConsumerImpl;
    }

    @Override
    public void updateQueueGroupMap(String topic, Set<MessageQueue> mqDivided) {
    }

    @Override
    public void messageQueueChanged(String topic, Set<MessageQueue> mqAll, Set<MessageQueue> mqDivided) {
        MessageQueueListener messageQueueListener = this.litePullConsumerImpl.getDefaultLitePullConsumer().getMessageQueueListener();
        if (messageQueueListener != null) {
            try {
                messageQueueListener.messageQueueChanged(topic, mqAll, mqDivided);
            }
            catch (Throwable e) {
                log.error("messageQueueChanged exception", e);
            }
        }
    }

    @Override
    public boolean removeUnnecessaryMessageQueue(MessageQueue mq, ProcessQueue pq) {
        this.litePullConsumerImpl.getOffsetStore().persist(mq);
        this.litePullConsumerImpl.getOffsetStore().removeOffset(mq);
        return true;
    }

    @Override
    public ConsumeType consumeType() {
        return ConsumeType.CONSUME_ACTIVELY;
    }

    @Override
    public void removeDirtyOffset(MessageQueue mq) {
        this.litePullConsumerImpl.getOffsetStore().removeOffset(mq);
    }

    @Override
    public long computePullFromWhereWithException(MessageQueue mq) throws MQClientException {
        DefaultLitePullConsumer consumer = this.litePullConsumerImpl.getDefaultLitePullConsumer();
        ConsumeFromWhere consumeFromWhere = consumer.getConsumeFromWhere();
        OffsetStore offsetStore = this.litePullConsumerImpl.getOffsetStore();
        String topic = mq.getTopic();
        switch (consumeFromWhere) {
            case CONSUME_FROM_LAST_OFFSET: {
                Optional<Long> optionalOffset;
                try {
                    optionalOffset = offsetStore.readOffset(mq, ReadOffsetType.MEMORY_FIRST_THEN_STORE);
                }
                catch (Throwable t) {
                    throw new MQClientException(22, "Failed to query consume offset from offset store");
                }
                if (optionalOffset.isPresent()) {
                    return optionalOffset.get();
                }
                if (topic.startsWith("%RETRY%")) {
                    log.warn("Failed to fetch offset from store for retry topic unexpectedly, mq={}, consumerGroup={}", (Object)mq, (Object)this.consumerGroup);
                    return 0L;
                }
                try {
                    return this.mQClientFactory.getMQAdminImpl().maxOffset(mq);
                }
                catch (MQClientException e) {
                    log.warn("Failed to compute max offset when consume from last offset, mq={}, consumerGroup={}", mq, this.consumerGroup, e);
                    throw e;
                }
            }
            case CONSUME_FROM_FIRST_OFFSET: {
                Optional<Long> optionalOffset;
                try {
                    optionalOffset = offsetStore.readOffset(mq, ReadOffsetType.READ_FROM_STORE);
                }
                catch (Throwable t) {
                    throw new MQClientException(22, "Failed to query consume offset from offset store");
                }
                return optionalOffset.isPresent() ? optionalOffset.get() : 0L;
            }
            case CONSUME_FROM_TIMESTAMP: {
                Optional<Long> optionalOffset;
                try {
                    optionalOffset = offsetStore.readOffset(mq, ReadOffsetType.READ_FROM_STORE);
                }
                catch (Throwable t) {
                    throw new MQClientException(22, "Failed to query consume offset from offset store");
                }
                if (optionalOffset.isPresent()) {
                    return optionalOffset.get();
                }
                String consumeTimestampStr = consumer.getConsumeTimestamp();
                Date date = UtilAll.parseDate(consumeTimestampStr, "yyyyMMddHHmmss");
                if (null == date) {
                    throw new MQClientException(1, "Consume timestamp is illegal, please check.");
                }
                long consumeTimestamp = date.getTime();
                try {
                    return this.mQClientFactory.getMQAdminImpl().searchOffset(mq, consumeTimestamp);
                }
                catch (MQClientException e) {
                    log.warn("Failed to compute consume offset by timestamp, mq={}, consumerGroup={}, timestamp={}", mq, this.consumerGroup, consumeTimestamp);
                    throw e;
                }
            }
        }
        throw new MQClientException(604, "type of 'ConsumeFromWhere' is not supported.");
    }

    @Override
    public void dispatchPullRequest(List<PullRequest> pullRequestList, long delay) {
    }

    @Override
    public ProcessQueue createProcessQueue() {
        return new ProcessQueue();
    }

    @Override
    public ProcessQueue createProcessQueue(String topicName) {
        return this.createProcessQueue();
    }
}

