/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.retry;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.retry.RetryPlan;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.retry.RetryStrategy;
import com.aliyun.openservices.shade.com.google.common.base.Preconditions;
import java.util.concurrent.ThreadLocalRandom;

public class DefaultProducerRetryStrategy
implements RetryStrategy {
    private static final int MAX_ATTEMPTS_NUM = 5;
    private long timeoutMillis;
    private int maxAttempts;
    private long initialBackoffMillis;
    private long maxBackoffMillis;
    private double backoffMultiplier;
    private long nextBackoffIntervalMillis;
    private volatile int attempts = 0;
    private volatile long deadline = 0L;

    public DefaultProducerRetryStrategy() {
        this(3000L, 3, 200L, 1000L, 2.0);
    }

    public DefaultProducerRetryStrategy(long timeoutMillis, int maxAttempts) {
        this(timeoutMillis, maxAttempts, 200L, 1000L, 2.0);
    }

    public DefaultProducerRetryStrategy(long timeoutMillis, int maxAttempts, long initialBackoffMillis, long maxBackoffMillis, double backoffMultiplier) {
        Preconditions.checkArgument(timeoutMillis > 0L);
        Preconditions.checkArgument(maxAttempts > 1);
        Preconditions.checkArgument(initialBackoffMillis > 0L);
        Preconditions.checkArgument(maxBackoffMillis > 0L);
        Preconditions.checkArgument(backoffMultiplier > 0.0);
        this.timeoutMillis = timeoutMillis;
        this.maxAttempts = Math.min(maxAttempts, 5);
        this.initialBackoffMillis = initialBackoffMillis;
        this.maxBackoffMillis = maxBackoffMillis;
        this.backoffMultiplier = backoffMultiplier;
        this.nextBackoffIntervalMillis = initialBackoffMillis;
        this.deadline = System.currentTimeMillis() + this.timeoutMillis;
    }

    @Override
    public RetryStrategy clone() {
        return new DefaultProducerRetryStrategy(this.timeoutMillis, this.maxAttempts, this.initialBackoffMillis, this.maxBackoffMillis, this.backoffMultiplier);
    }

    @Override
    public int getRetries() {
        return this.attempts;
    }

    @Override
    public RetryPlan makeRetryDecision(int requestCode, Throwable ex) {
        boolean shouldRetry = false;
        long backoffMillis = 0L;
        long now = System.currentTimeMillis();
        int expire = (int)(this.deadline - now);
        if (expire < 0) {
            return new RetryPlan(false, 0L);
        }
        if (this.maxAttempts > this.attempts + 1) {
            shouldRetry = true;
            backoffMillis = Math.min((long)((double)this.nextBackoffIntervalMillis * ThreadLocalRandom.current().nextDouble()), (long)expire);
            this.nextBackoffIntervalMillis = Math.min((long)((double)this.nextBackoffIntervalMillis * this.backoffMultiplier), this.maxBackoffMillis);
        }
        ++this.attempts;
        return new RetryPlan(shouldRetry, backoffMillis);
    }

    @Override
    public RetryPlan makeRetryDecision(Throwable ex) {
        return this.makeRetryDecision(1, ex);
    }
}

