/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol;

import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;

public enum RequestSource {
    SDK(-1),
    PROXY_FOR_ORDER(0),
    PROXY_FOR_BROADCAST(1),
    PROXY_FOR_STREAM(2),
    TIERED_STORAGE(3),
    TIERED_STORAGE_TEST(4);

    public static final String SYSTEM_PROPERTY_KEY = "rocketmq.requestSource";
    private final int value;

    private RequestSource(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static boolean valid(Integer value) {
        return null != value && value >= -1 && value < RequestSource.values().length - 1;
    }

    public static RequestSource getDefaultRequestSource() {
        int index;
        RequestSource requestSource = SDK;
        String requestSourceStr = System.getProperty(SYSTEM_PROPERTY_KEY);
        if (StringUtils.isNumeric(requestSourceStr) && RequestSource.valid(index = Integer.parseInt(requestSourceStr))) {
            requestSource = RequestSource.values()[index + 1];
        }
        return requestSource;
    }
}

