/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.redshift.RedshiftNotification;
import com.amazon.redshift.RedshiftProperty;
import com.amazon.redshift.core.BaseQueryKey;
import com.amazon.redshift.core.CachedQuery;
import com.amazon.redshift.core.CachedQueryCreateAction;
import com.amazon.redshift.core.CallableQueryKey;
import com.amazon.redshift.core.Encoding;
import com.amazon.redshift.core.QueryExecutor;
import com.amazon.redshift.core.QueryWithReturningColumnsKey;
import com.amazon.redshift.core.RedshiftStream;
import com.amazon.redshift.core.TransactionState;
import com.amazon.redshift.core.Tuple;
import com.amazon.redshift.core.Utils;
import com.amazon.redshift.core.v3.RedshiftRowsBlockingQueue;
import com.amazon.redshift.jdbc.AutoSave;
import com.amazon.redshift.jdbc.EscapeSyntaxCallMode;
import com.amazon.redshift.jdbc.PreferQueryMode;
import com.amazon.redshift.logger.LogLevel;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.util.HostSpec;
import com.amazon.redshift.util.LruCache;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftState;
import com.amazon.redshift.util.ServerErrorMessage;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public abstract class QueryExecutorBase
implements QueryExecutor {
    protected RedshiftLogger logger;
    protected final RedshiftStream pgStream;
    private final String user;
    private final String database;
    private final int cancelSignalTimeout;
    private int cancelPid;
    private int cancelKey;
    private boolean closed = false;
    private String serverVersion;
    private int serverVersionNum = 0;
    private TransactionState transactionState;
    private final boolean reWriteBatchedInserts;
    private final boolean columnSanitiserDisabled;
    private final EscapeSyntaxCallMode escapeSyntaxCallMode;
    private final PreferQueryMode preferQueryMode;
    private AutoSave autoSave;
    private boolean flushCacheOnDeallocate = true;
    protected final boolean logServerErrorDetail;
    private boolean raiseExceptionOnSilentRollback;
    private boolean standardConformingStrings = false;
    private SQLWarning warnings;
    private final ArrayList<RedshiftNotification> notifications = new ArrayList();
    private final LruCache<Object, CachedQuery> statementCache;
    private final CachedQueryCreateAction cachedQueryCreateAction;
    private final TreeMap<String, String> parameterStatuses = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    protected boolean enableStatementCache;
    protected int serverProtocolVersion;
    protected boolean datashareEnabled;
    protected boolean enableMultiSqlSupport;

    protected QueryExecutorBase(RedshiftStream pgStream, String user, String database, int cancelSignalTimeout, Properties info, RedshiftLogger logger) throws SQLException {
        this.logger = logger;
        this.pgStream = pgStream;
        this.user = user;
        this.database = database;
        this.cancelSignalTimeout = cancelSignalTimeout;
        this.reWriteBatchedInserts = RedshiftProperty.REWRITE_BATCHED_INSERTS.getBoolean(info);
        this.columnSanitiserDisabled = RedshiftProperty.DISABLE_COLUMN_SANITISER.getBoolean(info);
        String callMode = RedshiftProperty.ESCAPE_SYNTAX_CALL_MODE.get(info);
        this.escapeSyntaxCallMode = EscapeSyntaxCallMode.of(callMode);
        String preferMode = RedshiftProperty.PREFER_QUERY_MODE.get(info);
        this.preferQueryMode = PreferQueryMode.of(preferMode);
        this.autoSave = AutoSave.of(RedshiftProperty.AUTOSAVE.get(info));
        this.logServerErrorDetail = RedshiftProperty.LOG_SERVER_ERROR_DETAIL.getBoolean(info);
        this.cachedQueryCreateAction = new CachedQueryCreateAction(this);
        this.statementCache = new LruCache<Object, CachedQuery>(Math.max(0, RedshiftProperty.PREPARED_STATEMENT_CACHE_QUERIES.getInt(info)), Math.max(0, RedshiftProperty.PREPARED_STATEMENT_CACHE_SIZE_MIB.getInt(info) * 1024 * 1024), false, this.cachedQueryCreateAction, new LruCache.EvictAction<CachedQuery>(){

            @Override
            public void evict(CachedQuery cachedQuery) throws SQLException {
                cachedQuery.query.close();
            }
        });
        this.datashareEnabled = false;
        this.enableMultiSqlSupport = RedshiftProperty.ENABLE_MULTI_SQL_SUPPORT.getBoolean(info);
    }

    protected abstract void sendCloseMessage() throws IOException;

    @Override
    public void setNetworkTimeout(int milliseconds) throws IOException {
        this.pgStream.setNetworkTimeout(milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws IOException {
        return this.pgStream.getNetworkTimeout();
    }

    @Override
    public HostSpec getHostSpec() {
        return this.pgStream.getHostSpec();
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    public void setBackendKeyData(int cancelPid, int cancelKey) {
        this.cancelPid = cancelPid;
        this.cancelKey = cancelKey;
    }

    @Override
    public int getBackendPID() {
        return this.cancelPid;
    }

    @Override
    public void abort() {
        try {
            this.pgStream.getSocket().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.closed = true;
    }

    @Override
    public void close() {
        block4: {
            if (this.closed) {
                return;
            }
            try {
                if (RedshiftLogger.isEnable()) {
                    this.logger.log(LogLevel.DEBUG, " FE=> Terminate", new Object[0]);
                }
                this.sendCloseMessage();
                this.pgStream.flush();
                this.pgStream.close();
            }
            catch (IOException ioe) {
                if (!RedshiftLogger.isEnable()) break block4;
                this.logger.log(LogLevel.DEBUG, "Discarding IOException on close:", ioe);
            }
        }
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void sendQueryCancel() throws SQLException {
        if (this.cancelPid <= 0) {
            if (RedshiftLogger.isEnable()) {
                this.logger.logError("sendQueryCancel: cancelPid <= 0 (pid={0})", this.cancelPid);
            }
            return;
        }
        RedshiftStream cancelStream = null;
        try {
            if (RedshiftLogger.isEnable()) {
                this.logger.logDebug(" FE=> CancelRequest(pid={0},ckey={1})", this.cancelPid, this.cancelKey);
            }
            cancelStream = new RedshiftStream(this.pgStream.getSocketFactory(), this.pgStream.getHostSpec(), this.cancelSignalTimeout, this.logger);
            if (this.cancelSignalTimeout > 0) {
                cancelStream.getSocket().setSoTimeout(this.cancelSignalTimeout);
            }
            cancelStream.sendInteger4(16);
            cancelStream.sendInteger2(1234);
            cancelStream.sendInteger2(5678);
            cancelStream.sendInteger4(this.cancelPid);
            cancelStream.sendInteger4(this.cancelKey);
            cancelStream.flush();
            cancelStream.receiveEOF();
        }
        catch (IOException e) {
            if (RedshiftLogger.isEnable()) {
                this.logger.log(LogLevel.DEBUG, "Ignoring exception on cancel request:", e);
                this.logger.logError(e);
            }
        }
        finally {
            if (cancelStream != null) {
                try {
                    cancelStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public synchronized void addWarning(SQLWarning newWarning) {
        if (this.warnings == null) {
            this.warnings = newWarning;
        } else {
            this.warnings.setNextWarning(newWarning);
        }
    }

    public synchronized void addNotification(RedshiftNotification notification) {
        this.notifications.add(notification);
    }

    @Override
    public synchronized RedshiftNotification[] getNotifications() throws SQLException {
        RedshiftNotification[] array = this.notifications.toArray(new RedshiftNotification[0]);
        this.notifications.clear();
        return array;
    }

    @Override
    public synchronized SQLWarning getWarnings() {
        SQLWarning chain = this.warnings;
        this.warnings = null;
        return chain;
    }

    @Override
    public String getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public int getServerProtocolVersion() {
        return this.serverProtocolVersion;
    }

    @Override
    public boolean isDatashareEnabled() {
        return this.datashareEnabled;
    }

    @Override
    public int getServerVersionNum() {
        if (this.serverVersionNum != 0) {
            return this.serverVersionNum;
        }
        this.serverVersionNum = Utils.parseServerVersionStr(this.serverVersion);
        return this.serverVersionNum;
    }

    public void setServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
    }

    protected void setServerProtocolVersion(String serverProtocolVersion) {
        this.serverProtocolVersion = serverProtocolVersion != null && serverProtocolVersion.length() != 0 ? Integer.parseInt(serverProtocolVersion) : 0;
    }

    protected void setDatashareEnabled(boolean datashareEnabled) {
        this.datashareEnabled = datashareEnabled;
    }

    public void setServerVersionNum(int serverVersionNum) {
        this.serverVersionNum = serverVersionNum;
    }

    public synchronized void setTransactionState(TransactionState state) {
        this.transactionState = state;
    }

    public synchronized void setStandardConformingStrings(boolean value) {
        this.standardConformingStrings = value;
    }

    @Override
    public synchronized boolean getStandardConformingStrings() {
        return this.standardConformingStrings;
    }

    @Override
    public synchronized TransactionState getTransactionState() {
        return this.transactionState;
    }

    public void setEncoding(Encoding encoding) throws IOException {
        this.pgStream.setEncoding(encoding);
    }

    @Override
    public Encoding getEncoding() {
        return this.pgStream.getEncoding();
    }

    @Override
    public boolean isReWriteBatchedInsertsEnabled() {
        return this.reWriteBatchedInserts;
    }

    @Override
    public boolean isMultiSqlSupport() {
        return this.enableMultiSqlSupport;
    }

    @Override
    public final CachedQuery borrowQuery(String sql) throws SQLException {
        return this.statementCache.borrow(sql);
    }

    @Override
    public final CachedQuery borrowCallableQuery(String sql) throws SQLException {
        return this.statementCache.borrow(new CallableQueryKey(sql));
    }

    @Override
    public final CachedQuery borrowReturningQuery(String sql, String[] columnNames) throws SQLException {
        return this.statementCache.borrow(new QueryWithReturningColumnsKey(sql, true, true, columnNames));
    }

    @Override
    public CachedQuery borrowQueryByKey(Object key) throws SQLException {
        return this.statementCache.borrow(key);
    }

    @Override
    public void releaseQuery(CachedQuery cachedQuery) {
        if (this.enableStatementCache) {
            this.statementCache.put(cachedQuery.key, cachedQuery);
        } else if (cachedQuery != null && cachedQuery.query != null) {
            cachedQuery.query.close();
        }
    }

    @Override
    public final Object createQueryKey(String sql, boolean escapeProcessing, boolean isParameterized, String ... columnNames) {
        Object key = columnNames == null || columnNames.length != 0 ? new QueryWithReturningColumnsKey(sql, isParameterized, escapeProcessing, columnNames) : (isParameterized ? sql : new BaseQueryKey(sql, false, escapeProcessing));
        return key;
    }

    @Override
    public CachedQuery createQueryByKey(Object key) throws SQLException {
        return this.cachedQueryCreateAction.create(key);
    }

    @Override
    public final CachedQuery createQuery(String sql, boolean escapeProcessing, boolean isParameterized, String ... columnNames) throws SQLException {
        Object key = this.createQueryKey(sql, escapeProcessing, isParameterized, columnNames);
        return this.createQueryByKey(key);
    }

    @Override
    public boolean isColumnSanitiserDisabled() {
        return this.columnSanitiserDisabled;
    }

    @Override
    public EscapeSyntaxCallMode getEscapeSyntaxCallMode() {
        return this.escapeSyntaxCallMode;
    }

    @Override
    public PreferQueryMode getPreferQueryMode() {
        return this.preferQueryMode;
    }

    @Override
    public AutoSave getAutoSave() {
        return this.autoSave;
    }

    @Override
    public void setAutoSave(AutoSave autoSave) {
        this.autoSave = autoSave;
    }

    protected boolean willHealViaReparse(SQLException e) {
        if (e == null || e.getSQLState() == null) {
            return false;
        }
        if (RedshiftState.INVALID_SQL_STATEMENT_NAME.getState().equals(e.getSQLState())) {
            return true;
        }
        if (!RedshiftState.NOT_IMPLEMENTED.getState().equals(e.getSQLState())) {
            return false;
        }
        if (!(e instanceof RedshiftException)) {
            return false;
        }
        RedshiftException pe = (RedshiftException)e;
        ServerErrorMessage serverErrorMessage = pe.getServerErrorMessage();
        if (serverErrorMessage == null) {
            return false;
        }
        String routine = pe.getServerErrorMessage().getRoutine();
        return "RevalidateCachedQuery".equals(routine) || "RevalidateCachedPlan".equals(routine);
    }

    @Override
    public boolean willHealOnRetry(SQLException e) {
        if (this.autoSave == AutoSave.NEVER && this.getTransactionState() == TransactionState.FAILED) {
            return false;
        }
        return this.willHealViaReparse(e);
    }

    public boolean isFlushCacheOnDeallocate() {
        return this.flushCacheOnDeallocate;
    }

    @Override
    public void setFlushCacheOnDeallocate(boolean flushCacheOnDeallocate) {
        this.flushCacheOnDeallocate = flushCacheOnDeallocate;
    }

    @Override
    public boolean isRaiseExceptionOnSilentRollback() {
        return this.raiseExceptionOnSilentRollback;
    }

    @Override
    public void setRaiseExceptionOnSilentRollback(boolean raiseExceptionOnSilentRollback) {
        this.raiseExceptionOnSilentRollback = raiseExceptionOnSilentRollback;
    }

    protected boolean hasNotifications() {
        return this.notifications.size() > 0;
    }

    @Override
    public final Map<String, String> getParameterStatuses() {
        return Collections.unmodifiableMap(this.parameterStatuses);
    }

    @Override
    public final String getParameterStatus(String parameterName) {
        return this.parameterStatuses.get(parameterName);
    }

    protected void onParameterStatus(String parameterName, String parameterStatus) {
        if (parameterName == null || parameterName.equals("")) {
            throw new IllegalStateException("attempt to set GUC_REPORT parameter with null or empty-string name");
        }
        this.parameterStatuses.put(parameterName, parameterStatus);
    }

    @Override
    public void closeRingBufferThread(RedshiftRowsBlockingQueue<Tuple> queueRows, Thread ringBufferThread) {
    }

    @Override
    public boolean isRingBufferThreadRunning() {
        return false;
    }

    @Override
    public void closeStatementAndPortal() {
    }
}

