/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.glue.model.Action;
import com.amazonaws.services.glue.model.Predicate;
import com.amazonaws.services.glue.model.TriggerType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateTriggerRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String workflowName;
    private String type;
    private String schedule;
    private Predicate predicate;
    private List<Action> actions;
    private String description;
    private Boolean startOnCreation;
    private Map<String, String> tags;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateTriggerRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    public CreateTriggerRequest withWorkflowName(String workflowName) {
        this.setWorkflowName(workflowName);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public CreateTriggerRequest withType(String type) {
        this.setType(type);
        return this;
    }

    public CreateTriggerRequest withType(TriggerType type) {
        this.type = type.toString();
        return this;
    }

    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public CreateTriggerRequest withSchedule(String schedule) {
        this.setSchedule(schedule);
        return this;
    }

    public void setPredicate(Predicate predicate) {
        this.predicate = predicate;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public CreateTriggerRequest withPredicate(Predicate predicate) {
        this.setPredicate(predicate);
        return this;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(Collection<Action> actions) {
        if (actions == null) {
            this.actions = null;
            return;
        }
        this.actions = new ArrayList<Action>(actions);
    }

    public CreateTriggerRequest withActions(Action ... actions) {
        if (this.actions == null) {
            this.setActions(new ArrayList<Action>(actions.length));
        }
        for (Action ele : actions) {
            this.actions.add(ele);
        }
        return this;
    }

    public CreateTriggerRequest withActions(Collection<Action> actions) {
        this.setActions(actions);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateTriggerRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setStartOnCreation(Boolean startOnCreation) {
        this.startOnCreation = startOnCreation;
    }

    public Boolean getStartOnCreation() {
        return this.startOnCreation;
    }

    public CreateTriggerRequest withStartOnCreation(Boolean startOnCreation) {
        this.setStartOnCreation(startOnCreation);
        return this;
    }

    public Boolean isStartOnCreation() {
        return this.startOnCreation;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateTriggerRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateTriggerRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateTriggerRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getWorkflowName() != null) {
            sb.append("WorkflowName: ").append(this.getWorkflowName()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getSchedule() != null) {
            sb.append("Schedule: ").append(this.getSchedule()).append(",");
        }
        if (this.getPredicate() != null) {
            sb.append("Predicate: ").append(this.getPredicate()).append(",");
        }
        if (this.getActions() != null) {
            sb.append("Actions: ").append(this.getActions()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getStartOnCreation() != null) {
            sb.append("StartOnCreation: ").append(this.getStartOnCreation()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTriggerRequest)) {
            return false;
        }
        CreateTriggerRequest other = (CreateTriggerRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getWorkflowName() == null ^ this.getWorkflowName() == null) {
            return false;
        }
        if (other.getWorkflowName() != null && !other.getWorkflowName().equals(this.getWorkflowName())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getSchedule() == null ^ this.getSchedule() == null) {
            return false;
        }
        if (other.getSchedule() != null && !other.getSchedule().equals(this.getSchedule())) {
            return false;
        }
        if (other.getPredicate() == null ^ this.getPredicate() == null) {
            return false;
        }
        if (other.getPredicate() != null && !other.getPredicate().equals(this.getPredicate())) {
            return false;
        }
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        if (other.getActions() != null && !other.getActions().equals(this.getActions())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getStartOnCreation() == null ^ this.getStartOnCreation() == null) {
            return false;
        }
        if (other.getStartOnCreation() != null && !other.getStartOnCreation().equals(this.getStartOnCreation())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getWorkflowName() == null ? 0 : this.getWorkflowName().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getSchedule() == null ? 0 : this.getSchedule().hashCode());
        hashCode = 31 * hashCode + (this.getPredicate() == null ? 0 : this.getPredicate().hashCode());
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getStartOnCreation() == null ? 0 : this.getStartOnCreation().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateTriggerRequest clone() {
        return (CreateTriggerRequest)super.clone();
    }
}

