/*
 * Decompiled with CFR 0.152.
 */
package com.att.inno.env.log4j;

import com.att.inno.env.log4j.PIDAccess;
import java.io.File;
import java.net.URL;
import org.apache.log4j.PropertyConfigurator;

public class LogFileNamer {
    public static final int pid = PIDAccess.INSTANCE.getpid();
    public final String root;
    private boolean printPID;

    public LogFileNamer(String root) {
        this.root = root == null || "".equals(root) || root.endsWith("/") ? root : root + "-";
        this.printPID = true;
    }

    public LogFileNamer noPID() {
        this.printPID = false;
        return this;
    }

    public String setAppender(String appender) {
        int pipe = appender.indexOf(124);
        if (pipe >= 0) {
            String rv = appender.substring(0, pipe);
            System.setProperty("LOG4J_FILENAME_" + rv, this.root + appender.substring(pipe + 1) + (this.printPID ? Integer.valueOf(45 + pid) : "") + ".log");
            return rv;
        }
        System.setProperty("LOG4J_FILENAME_" + appender, this.root + appender + (this.printPID ? Integer.valueOf(45 + pid) : "") + ".log");
        return appender;
    }

    public void configure(String props) {
        String fname = "etc/" + props;
        if (new File(fname).exists()) {
            PropertyConfigurator.configureAndWatch((String)fname, (long)60000L);
        } else {
            URL rsrc = ClassLoader.getSystemResource(props);
            if (rsrc == null) {
                System.err.println("Neither File: " + fname + " or resource on Classpath " + props + " exist");
            }
            PropertyConfigurator.configure((URL)rsrc);
        }
    }
}

