/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.lock.passwordless;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import com.auth0.api.ParameterizableRequest;
import com.auth0.api.authentication.AuthenticationAPIClient;
import com.auth0.api.authentication.AuthenticationRequest;
import com.auth0.api.callback.AuthenticationCallback;
import com.auth0.api.callback.BaseCallback;
import com.auth0.core.Token;
import com.auth0.core.UserProfile;
import com.auth0.lock.Lock;
import com.auth0.lock.LockContext;
import com.auth0.lock.error.ErrorDialogBuilder;
import com.auth0.lock.error.LoginAuthenticationErrorBuilder;
import com.auth0.lock.event.AlertDialogEvent;
import com.auth0.lock.event.AuthenticationError;
import com.auth0.lock.event.AuthenticationEvent;
import com.auth0.lock.event.NavigationEvent;
import com.auth0.lock.fragment.BaseTitledFragment;
import com.auth0.lock.passwordless.CountryCodeActivity;
import com.auth0.lock.passwordless.R;
import com.auth0.lock.passwordless.event.CodeManualEntryRequestedEvent;
import com.auth0.lock.passwordless.event.CountryCodeSelectedEvent;
import com.auth0.lock.passwordless.event.LoginRequestEvent;
import com.auth0.lock.passwordless.event.PasscodeRequestedEvent;
import com.auth0.lock.passwordless.event.PasscodeSentEvent;
import com.auth0.lock.passwordless.event.SelectCountryCodeEvent;
import com.auth0.lock.passwordless.fragment.InProgressFragment;
import com.auth0.lock.passwordless.fragment.InvalidLinkFragment;
import com.auth0.lock.passwordless.fragment.MagicLinkLoginFragment;
import com.auth0.lock.passwordless.fragment.PasscodeLoginFragment;
import com.auth0.lock.passwordless.fragment.RequestCodeEmailFragment;
import com.auth0.lock.passwordless.fragment.RequestCodeSmsFragment;
import com.auth0.lock.passwordless.util.AppLinkIntentParser;
import com.auth0.lock.util.ActivityUIHelper;
import com.squareup.otto.Bus;
import com.squareup.otto.Subscribe;

public class LockPasswordlessActivity
extends FragmentActivity {
    private static final String TAG = LockPasswordlessActivity.class.getName();
    public static final int MODE_UNKNOWN = 256;
    public static final int MODE_SMS_CODE = 0;
    public static final int MODE_EMAIL_CODE = 1;
    public static final int MODE_SMS_MAGIC_LINK = 16;
    public static final int MODE_EMAIL_MAGIC_LINK = 17;
    private static final int USE_MAGIC_LINK_MASK = 16;
    private static final int IS_EMAIL_MASK = 1;
    private static final int REQUEST_CODE = 1234;
    public static final String PASSWORDLESS_TYPE_PARAMETER = "PASSWORDLESS_TYPE_PARAMETER";
    private static final String USERNAME_PARAMETER = "USERNAME_PARAMETER";
    private static final String IS_IN_PROGRESS_PARAMETER = "IS_IN_PROGRESS_PARAMETER";
    protected AuthenticationAPIClient client;
    protected Bus bus;
    Lock lock;
    private int passwordlessType;
    private boolean isInProgress;
    private String username;
    private LoginAuthenticationErrorBuilder errorBuilder;

    public static void showFrom(Activity activity, int passwordlessType) {
        Intent intent = new Intent((Context)activity, LockPasswordlessActivity.class);
        if (passwordlessType != 1 && passwordlessType != 17 && passwordlessType != 0 && passwordlessType != 16) {
            Log.e((String)TAG, (String)"Invalid passwordless type, it must be one of {MODE_EMAIL_CODE, MODE_EMAIL_MAGIC_LINK, MODE_SMS_CODE, MODE_SMS_MAGIC_LINK}");
            return;
        }
        intent.putExtra(PASSWORDLESS_TYPE_PARAMETER, passwordlessType);
        activity.startActivity(intent);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.com_auth0_passwordless_activity_lock_passwordless);
        this.passwordlessType = 256;
        this.lock = this.getLock();
        this.client = this.lock.getAuthenticationAPIClient();
        this.bus = this.lock.getBus();
        if (savedInstanceState == null) {
            this.isInProgress = false;
            Intent intent = this.getIntent();
            boolean invalidMagicLink = false;
            int mode = intent.getIntExtra(PASSWORDLESS_TYPE_PARAMETER, 256);
            if (mode != 256) {
                this.setPasswordlessType(mode);
            } else {
                AppLinkIntentParser linkParser = new AppLinkIntentParser(intent);
                invalidMagicLink = linkParser.isAppLinkIntent();
                if (invalidMagicLink) {
                    this.setPasswordlessType(linkParser.getModeFromAppLink());
                }
            }
            if (this.passwordlessType == 256) {
                Log.e((String)TAG, (String)("Passwordless type is unknown, the intent that started the activity is " + intent));
                this.finish();
            }
            BaseTitledFragment initialFragment = this.isEmailType() ? RequestCodeEmailFragment.newInstance(this.useMagicLink()) : RequestCodeSmsFragment.newInstance(this.useMagicLink());
            this.getSupportFragmentManager().beginTransaction().add(R.id.com_auth0_container, (Fragment)initialFragment).commit();
            if (invalidMagicLink) {
                InvalidLinkFragment fragment = new InvalidLinkFragment();
                this.getSupportFragmentManager().beginTransaction().replace(R.id.com_auth0_container, (Fragment)fragment).addToBackStack(((Object)((Object)fragment)).getClass().getName()).commit();
            }
        } else {
            this.setPasswordlessType(savedInstanceState.getInt(PASSWORDLESS_TYPE_PARAMETER));
            this.isInProgress = savedInstanceState.getBoolean(IS_IN_PROGRESS_PARAMETER);
            this.username = savedInstanceState.getString(USERNAME_PARAMETER);
        }
        this.errorBuilder = new LoginAuthenticationErrorBuilder(R.string.com_auth0_passwordless_login_error_title, R.string.com_auth0_passwordless_login_error_message, this.isEmailType() ? R.string.com_auth0_passwordless_login_invalid_credentials_message_email : R.string.com_auth0_passwordless_login_invalid_credentials_message_sms, R.string.com_auth0_db_login_unauthorized_error_message);
        ActivityUIHelper.configureScreenModeForActivity((Activity)this, (Lock)this.lock);
    }

    public void onSaveInstanceState(Bundle savedInstanceState) {
        savedInstanceState.putInt(PASSWORDLESS_TYPE_PARAMETER, this.passwordlessType);
        savedInstanceState.putBoolean(IS_IN_PROGRESS_PARAMETER, this.isInProgress);
        savedInstanceState.putString(USERNAME_PARAMETER, this.username);
        super.onSaveInstanceState(savedInstanceState);
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        ActivityUIHelper.configureScreenModeForActivity((Activity)this, (Lock)this.lock);
    }

    protected void onStart() {
        super.onStart();
        this.bus.register((Object)this);
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        Log.d((String)TAG, (String)("onNewIntent username: " + this.username + " intent: " + intent));
        AppLinkIntentParser linkParser = new AppLinkIntentParser(intent);
        if (this.username != null && linkParser.isValidAppLinkIntent()) {
            String passcode = linkParser.getCodeFromAppLinkIntent();
            this.performLogin(new LoginRequestEvent(this.username, passcode));
        } else {
            InvalidLinkFragment fragment = new InvalidLinkFragment();
            this.getSupportFragmentManager().beginTransaction().replace(R.id.com_auth0_container, (Fragment)fragment).addToBackStack(((Object)((Object)fragment)).getClass().getName()).commit();
        }
    }

    protected void onStop() {
        super.onStop();
        this.bus.unregister((Object)this);
    }

    public void onBackPressed() {
        if (!this.isInProgress) {
            double count = this.getSupportFragmentManager().getBackStackEntryCount();
            if (!this.lock.isClosable() && count >= 1.0 || this.lock.isClosable()) {
                if (count == 0.0) {
                    LocalBroadcastManager.getInstance((Context)this).sendBroadcast(new Intent("Lock.Cancel"));
                }
                super.onBackPressed();
            }
        }
    }

    private Lock getLock() {
        if (this.lock != null) {
            return this.lock;
        }
        return LockContext.getLock((Activity)this);
    }

    protected void setPasswordlessType(int passwordlessType) {
        if (passwordlessType != 256 && passwordlessType != 1 && passwordlessType != 17 && passwordlessType != 0 && passwordlessType != 16) {
            Log.e((String)TAG, (String)"Invalid passwordless type, it must be one of {MODE_EMAIL_CODE, MODE_EMAIL_MAGIC_LINK, MODE_SMS_CODE, MODE_SMS_MAGIC_LINK}");
            return;
        }
        this.passwordlessType = passwordlessType;
    }

    protected boolean useMagicLink() {
        return 0 != (this.passwordlessType & 0x10);
    }

    protected boolean isEmailType() {
        return 0 != (this.passwordlessType & 1);
    }

    protected Class getCountryCodeActivityClass() {
        return CountryCodeActivity.class;
    }

    @Subscribe
    public void onSelectCountryCodeEvent(SelectCountryCodeEvent event) {
        Intent intent = new Intent((Context)this, this.getCountryCodeActivityClass());
        this.startActivityForResult(intent, 1234);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1234 && resultCode == -1) {
            String country = data.getStringExtra("COUNTRY_CODE");
            String dialCode = data.getStringExtra("COUNTRY_DIAL_CODE");
            Log.d((String)TAG, (String)("Picked country " + country));
            this.bus.post((Object)new CountryCodeSelectedEvent(country, dialCode));
        }
    }

    @Subscribe
    public void onPasscodeRequestedEvent(PasscodeRequestedEvent event) {
        this.sendRequestCode(event);
    }

    @Subscribe
    public void onPasscodeSentEvent(PasscodeSentEvent event) {
        BaseTitledFragment fragment;
        this.username = event.getUsername();
        switch (this.passwordlessType) {
            case 1: {
                fragment = PasscodeLoginFragment.newInstance(R.string.com_auth0_passwordless_login_message_email, this.username);
                break;
            }
            case 17: {
                fragment = MagicLinkLoginFragment.newInstance(R.string.com_auth0_passwordless_login_message_magic_link_email, this.username);
                break;
            }
            case 0: {
                fragment = PasscodeLoginFragment.newInstance(R.string.com_auth0_passwordless_login_message_sms, this.username);
                break;
            }
            case 16: {
                fragment = MagicLinkLoginFragment.newInstance(R.string.com_auth0_passwordless_login_message_magic_link_sms, this.username);
                break;
            }
            default: {
                Log.e((String)TAG, (String)("Can't continue. Unknown passwordless type: " + this.passwordlessType));
                return;
            }
        }
        this.getSupportFragmentManager().beginTransaction().replace(R.id.com_auth0_container, (Fragment)fragment).addToBackStack(fragment.getClass().getName()).commit();
    }

    @Subscribe
    public void onCodeManualEntryRequested(CodeManualEntryRequestedEvent event) {
        PasscodeLoginFragment fragment = PasscodeLoginFragment.newInstance(this.isEmailType() ? R.string.com_auth0_passwordless_login_message_email : R.string.com_auth0_passwordless_login_message_sms, this.username);
        this.getSupportFragmentManager().popBackStack();
        this.getSupportFragmentManager().beginTransaction().replace(R.id.com_auth0_container, (Fragment)fragment).addToBackStack(((Object)((Object)fragment)).getClass().getName()).commit();
    }

    @Subscribe
    public void onNavigationEvent(NavigationEvent event) {
        switch (event) {
            case BACK: {
                this.onBackPressed();
                break;
            }
            default: {
                Log.v((String)TAG, (String)("Invalid navigation event " + event));
            }
        }
    }

    @Subscribe
    public void onAuthenticationError(AuthenticationError error) {
        Log.e((String)TAG, (String)"Failed to authenticate user", (Throwable)error.getThrowable());
        ErrorDialogBuilder.showAlertDialog((Context)this, (AlertDialogEvent)error);
        if (this.isInProgress) {
            this.isInProgress = false;
            this.getSupportFragmentManager().popBackStack();
        }
    }

    @Subscribe
    public void onAuthentication(AuthenticationEvent event) {
        UserProfile profile = event.getProfile();
        Token token = event.getToken();
        Log.i((String)TAG, (String)("Authenticated user " + profile.getName()));
        Intent result = new Intent("Lock.Authentication").putExtra("profile", (Parcelable)profile).putExtra("token", (Parcelable)token);
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(result);
        this.finish();
    }

    @Subscribe
    public void onLoginRequest(LoginRequestEvent event) {
        this.performLogin(event);
    }

    private void performLogin(LoginRequestEvent event) {
        InProgressFragment fragment = InProgressFragment.newInstance(this.useMagicLink() ? R.string.com_auth0_passwordless_title_in_progress_magic_link : R.string.com_auth0_passwordless_title_in_progress_code, this.isEmailType() ? R.string.com_auth0_passwordless_login_message_in_progress_email : R.string.com_auth0_passwordless_login_message_in_progress_sms, event.getUsername());
        this.getSupportFragmentManager().beginTransaction().replace(R.id.com_auth0_container, (Fragment)fragment).addToBackStack(((Object)((Object)fragment)).getClass().getName()).commit();
        this.isInProgress = true;
        AuthenticationCallback authCallback = new AuthenticationCallback(){

            public void onSuccess(UserProfile userProfile, Token token) {
                LockPasswordlessActivity.this.bus.post((Object)new AuthenticationEvent(userProfile, token));
            }

            public void onFailure(Throwable throwable) {
                LockPasswordlessActivity.this.bus.post((Object)LockPasswordlessActivity.this.errorBuilder.buildFrom(throwable));
            }
        };
        AuthenticationRequest request = this.isEmailType() ? this.client.loginWithEmail(event.getUsername(), event.getPasscode()) : this.client.loginWithPhoneNumber(event.getUsername(), event.getPasscode());
        request.addParameters(this.lock.getAuthenticationParameters()).start(authCallback);
    }

    private void sendRequestCode(final PasscodeRequestedEvent event) {
        int message;
        int title;
        ParameterizableRequest request;
        this.username = event.getUsername();
        if (this.isEmailType()) {
            request = this.client.passwordlessWithEmail(this.username, this.useMagicLink());
            title = R.string.com_auth0_passwordless_send_code_error_tile_email;
            message = R.string.com_auth0_passwordless_send_code_error_message_email;
        } else {
            request = this.client.passwordlessWithSMS(this.username, this.useMagicLink());
            title = R.string.com_auth0_passwordless_send_code_error_tile_sms;
            message = R.string.com_auth0_passwordless_send_code_error_message_sms;
        }
        BaseCallback<Void> callback = new BaseCallback<Void>(){

            public void onSuccess(Void payload) {
                Log.d((String)TAG, (String)("Passcode sent to " + LockPasswordlessActivity.this.username));
                if (!event.isRetry()) {
                    LockPasswordlessActivity.this.bus.post((Object)new PasscodeSentEvent(LockPasswordlessActivity.this.username));
                }
            }

            public void onFailure(Throwable error) {
                LockPasswordlessActivity.this.bus.post((Object)new AuthenticationError(title, message, error));
            }
        };
        request.start((BaseCallback)callback);
    }
}

