/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.lock.passwordless.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Filter;
import android.widget.TextView;
import com.auth0.lock.passwordless.R;
import com.auth0.lock.passwordless.adapter.Country;
import java.util.ArrayList;
import java.util.List;

public class CountryAdapter
extends BaseAdapter {
    private final Filter filter;
    private final Context context;
    private List<Country> data;

    public CountryAdapter(Context context, List<Country> countries) {
        this.context = context;
        this.data = new ArrayList<Country>(countries);
        this.filter = new CountryFilter(countries);
    }

    public int getCount() {
        return this.data.size();
    }

    public Country getItem(int position) {
        return this.data.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        Country country = this.getItem(position);
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)this.context).inflate(R.layout.com_auth0_passwordless_item_country_code, parent, false);
        }
        TextView countryNameTextView = (TextView)convertView.findViewById(R.id.com_auth0_passwordless_sms_country_name_text_view);
        countryNameTextView.setText((CharSequence)country.getDisplayName());
        TextView countryCodeTextView = (TextView)convertView.findViewById(R.id.com_auth0_passwordless_sms_country_code_text_view);
        countryCodeTextView.setText((CharSequence)country.getDialCode());
        return convertView;
    }

    public Filter getFilter() {
        return this.filter;
    }

    private class CountryFilter
    extends Filter {
        private final List<Country> countries;

        private CountryFilter(List<Country> countries) {
            this.countries = countries;
        }

        protected Filter.FilterResults performFiltering(CharSequence constraint) {
            String filter = constraint.toString().toLowerCase();
            Filter.FilterResults results = new Filter.FilterResults();
            ArrayList<Country> filtered = new ArrayList<Country>(this.countries.size());
            for (Country country : this.countries) {
                if (!country.getDisplayName().toLowerCase().contains(filter) && !country.getIsoCode().toLowerCase().contains(filter)) continue;
                filtered.add(country);
            }
            results.values = filtered;
            results.count = filtered.size();
            return results;
        }

        protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
            CountryAdapter.this.data = (List)results.values;
            if (results.count > 0) {
                CountryAdapter.this.notifyDataSetChanged();
            } else {
                CountryAdapter.this.notifyDataSetInvalidated();
            }
        }
    }
}

