/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.lock.passwordless.fragment;

import android.os.Bundle;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.auth0.lock.fragment.BaseTitledFragment;
import com.auth0.lock.passwordless.R;

public class InProgressFragment
extends BaseTitledFragment {
    private static final String TITLE_ARGUMENT = "TITLE_ARGUMENT";
    private static final String MESSAGE_FORMAT_ARGUMENT = "MESSAGE_FORMAT_ARGUMENT";
    private static final String USERNAME_ARGUMENT = "USERNAME_ARGUMENT";
    private int titleResourceId;
    private int messageFormatResId;
    private String username;

    public static InProgressFragment newInstance(int titleResourceId, int messageFormatResId, String username) {
        InProgressFragment fragment = new InProgressFragment();
        Bundle args = new Bundle();
        args.putInt(TITLE_ARGUMENT, titleResourceId);
        args.putInt(MESSAGE_FORMAT_ARGUMENT, messageFormatResId);
        args.putString(USERNAME_ARGUMENT, username);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.titleResourceId = this.getArguments().getInt(TITLE_ARGUMENT);
            this.messageFormatResId = this.getArguments().getInt(MESSAGE_FORMAT_ARGUMENT);
            this.username = this.getArguments().getString(USERNAME_ARGUMENT);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.com_auth0_passwordless_fragment_in_progress, container, false);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        String messageFormat = this.getString(this.messageFormatResId);
        TextView progressTextView = (TextView)view.findViewById(R.id.com_auth0_passwordless_progress_message);
        progressTextView.setText((CharSequence)Html.fromHtml((String)String.format(messageFormat, this.username)));
    }

    protected int getTitleResource() {
        return this.titleResourceId;
    }
}

