/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.lock.passwordless.fragment;

import android.os.AsyncTask;
import android.os.Bundle;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import com.auth0.lock.fragment.BaseTitledFragment;
import com.auth0.lock.passwordless.R;
import com.auth0.lock.passwordless.event.CodeManualEntryRequestedEvent;
import com.auth0.lock.passwordless.event.PasscodeRequestedEvent;

public class MagicLinkLoginFragment
extends BaseTitledFragment {
    private static final String USERNAME_ARGUMENT = "USERNAME_ARGUMENT";
    private static final String MESSAGE_FORMAT_ARGUMENT = "MESSAGE_FORMAT_ARGUMENT";
    int messageFormatResId;
    private String username;

    public static MagicLinkLoginFragment newInstance(int messageFormatResId, String username) {
        MagicLinkLoginFragment fragment = new MagicLinkLoginFragment();
        Bundle args = new Bundle();
        args.putInt(MESSAGE_FORMAT_ARGUMENT, messageFormatResId);
        args.putString(USERNAME_ARGUMENT, username);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle arguments = this.getArguments();
        if (arguments != null) {
            this.messageFormatResId = arguments.getInt(MESSAGE_FORMAT_ARGUMENT);
            this.username = arguments.getString(USERNAME_ARGUMENT);
        }
    }

    public void onDestroy() {
        super.onDestroy();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.com_auth0_passwordless_fragment_magic_link_login, container, false);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        Button enterCodeButton = (Button)view.findViewById(R.id.com_auth0_email_enter_code_button);
        enterCodeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MagicLinkLoginFragment.this.bus.post((Object)new CodeManualEntryRequestedEvent());
            }
        });
        final Button resendCodeButton = (Button)view.findViewById(R.id.com_auth0_email_resend_code_button);
        resendCodeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                resendCodeButton.setVisibility(4);
                MagicLinkLoginFragment.this.bus.post((Object)new PasscodeRequestedEvent(MagicLinkLoginFragment.this.username, true));
                new ShowLaterTask().execute(new View[]{resendCodeButton});
            }
        });
        TextView messageTextView = (TextView)view.findViewById(R.id.com_auth0_email_magic_link_message);
        String messageFormat = this.getString(this.messageFormatResId);
        messageTextView.setText((CharSequence)Html.fromHtml((String)String.format(messageFormat, this.username)));
        new ShowLaterTask().execute(new View[]{resendCodeButton});
    }

    protected int getTitleResource() {
        return R.string.com_auth0_passwordless_title_magic_link;
    }

    private class ShowLaterTask
    extends AsyncTask<View, Void, Boolean> {
        View view;

        private ShowLaterTask() {
        }

        protected Boolean doInBackground(View ... params) {
            try {
                this.view = params[0];
                Thread.sleep(10000L);
                return true;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
        }

        protected void onPostExecute(Boolean success) {
            if (success.booleanValue()) {
                this.view.setVisibility(0);
            }
        }
    }
}

