/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.lock.passwordless.fragment;

import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.auth0.lock.event.AuthenticationError;
import com.auth0.lock.event.AuthenticationEvent;
import com.auth0.lock.event.NavigationEvent;
import com.auth0.lock.fragment.BaseTitledFragment;
import com.auth0.lock.passwordless.R;
import com.auth0.lock.passwordless.event.LoginRequestEvent;
import com.auth0.lock.passwordless.validation.PasscodeValidator;
import com.auth0.lock.validation.Validator;
import com.auth0.lock.widget.CredentialField;
import com.squareup.otto.Subscribe;

public class PasscodeLoginFragment
extends BaseTitledFragment {
    private static final String MESSAGE_FORMAT_ARGUMENT = "MESSAGE_FORMAT_ARGUMENT";
    private static final String USERNAME_ARGUMENT = "USERNAME_ARGUMENT";
    private int messageFormatResId;
    private String username;
    private Validator validator;
    Button accessButton;
    ProgressBar progressBar;
    CredentialField passcodeField;

    public static PasscodeLoginFragment newInstance(int messageFormatResId, String username) {
        PasscodeLoginFragment fragment = new PasscodeLoginFragment();
        Bundle args = new Bundle();
        args.putInt(MESSAGE_FORMAT_ARGUMENT, messageFormatResId);
        args.putString(USERNAME_ARGUMENT, username);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle arguments = this.getArguments();
        if (arguments != null) {
            this.messageFormatResId = this.getArguments().getInt(MESSAGE_FORMAT_ARGUMENT);
            this.username = arguments.getString(USERNAME_ARGUMENT);
        }
        this.validator = new PasscodeValidator(R.id.com_auth0_passwordless_passcode_login_code_field, R.string.com_auth0_passwordless_login_error_title, R.string.com_auth0_passwordless_login_invalid_passcode_message);
        this.bus.register((Object)this);
    }

    public void onDestroy() {
        super.onDestroy();
        this.bus.unregister((Object)this);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.com_auth0_passwordless_fragment_passcode_login, container, false);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        Button noCodeButton = (Button)view.findViewById(R.id.com_auth0_passwordless_passcode_no_code_button);
        noCodeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PasscodeLoginFragment.this.bus.post((Object)NavigationEvent.BACK);
            }
        });
        TextView messageTextView = (TextView)view.findViewById(R.id.com_auth0_passwordless_passcode_enter_code_message);
        String messageFormat = this.getString(this.messageFormatResId);
        messageTextView.setText((CharSequence)Html.fromHtml((String)String.format(messageFormat, this.username)));
        this.passcodeField = (CredentialField)view.findViewById(R.id.com_auth0_passwordless_passcode_login_code_field);
        this.accessButton = (Button)view.findViewById(R.id.com_auth0_passwordless_passcode_access_button);
        this.progressBar = (ProgressBar)view.findViewById(R.id.com_auth0_passwordless_passcode_login_progress_indicator);
        this.accessButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PasscodeLoginFragment.this.login();
            }
        });
    }

    private void login() {
        boolean valid;
        AuthenticationError error = this.validator.validateFrom((Fragment)this);
        boolean bl = valid = error == null;
        if (valid) {
            this.performLogin();
        } else {
            this.bus.post((Object)error);
        }
    }

    private void performLogin() {
        this.accessButton.setEnabled(false);
        this.accessButton.setText((CharSequence)"");
        this.progressBar.setVisibility(0);
        String passcode = this.passcodeField.getText().toString();
        this.bus.post((Object)new LoginRequestEvent(this.username, passcode));
    }

    @Subscribe
    public void onAuthenticationError(AuthenticationError error) {
        this.accessButton.setEnabled(true);
        this.accessButton.setText(R.string.com_auth0_passwordless_login_access_btn_text);
        this.progressBar.setVisibility(8);
    }

    @Subscribe
    public void onAuthentication(AuthenticationEvent event) {
        this.accessButton.setEnabled(true);
        this.accessButton.setText(R.string.com_auth0_passwordless_login_access_btn_text);
        this.progressBar.setVisibility(8);
    }

    protected int getTitleResource() {
        return R.string.com_auth0_passwordless_title_enter_passcode;
    }
}

