/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.lock.passwordless.fragment;

import android.content.SharedPreferences;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ProgressBar;
import com.auth0.lock.event.AuthenticationError;
import com.auth0.lock.fragment.BaseTitledFragment;
import com.auth0.lock.passwordless.R;
import com.auth0.lock.passwordless.event.PasscodeRequestedEvent;
import com.auth0.lock.passwordless.event.PasscodeSentEvent;
import com.auth0.lock.validation.EmailValidator;
import com.auth0.lock.validation.Validator;
import com.auth0.lock.widget.CredentialField;
import com.squareup.otto.Subscribe;

public class RequestCodeEmailFragment
extends BaseTitledFragment {
    private static final String TAG = RequestCodeEmailFragment.class.getName();
    private static final String LAST_EMAIL_KEY = "LAST_EMAIL_KEY";
    private static final String USE_MAGIC_LINK_ARGUMENT = "USE_MAGIC_LINK_ARGUMENT";
    private boolean useMagicLink;
    Validator validator;
    CredentialField emailField;
    Button sendButton;
    ProgressBar progressBar;

    public static RequestCodeEmailFragment newInstance(boolean useMagicLink) {
        RequestCodeEmailFragment fragment = new RequestCodeEmailFragment();
        Bundle args = new Bundle();
        args.putBoolean(USE_MAGIC_LINK_ARGUMENT, useMagicLink);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.useMagicLink = this.getArguments().getBoolean(USE_MAGIC_LINK_ARGUMENT);
        }
        this.bus.register((Object)this);
    }

    public void onDestroy() {
        super.onDestroy();
        this.bus.unregister((Object)this);
    }

    protected int getTitleResource() {
        return R.string.com_auth0_passwordless_title_send_passcode;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.com_auth0_passwordless_fragment_request_code_email, container, false);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.validator = new EmailValidator(R.id.com_auth0_passwordless_email_field, R.string.com_auth0_passwordless_send_code_error_tile_email, R.string.com_auth0_passwordless_send_code_no_phone_message_email);
        this.emailField = (CredentialField)view.findViewById(R.id.com_auth0_passwordless_email_field);
        SharedPreferences preferences = this.getActivity().getPreferences(0);
        String storedEmail = preferences.getString(LAST_EMAIL_KEY, null);
        this.emailField.setText((CharSequence)storedEmail);
        this.sendButton = (Button)view.findViewById(R.id.com_auth0_passwordless_access_button_email);
        this.sendButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RequestCodeEmailFragment.this.requestPasscode();
            }
        });
        this.progressBar = (ProgressBar)view.findViewById(R.id.com_auth0_passwordless_send_code_progress_indicator_email);
        Button hasCodeButton = (Button)view.findViewById(R.id.com_auth0_passwordless_already_has_code_button_email);
        hasCodeButton.setVisibility(!this.useMagicLink && storedEmail != null ? 0 : 8);
        hasCodeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SharedPreferences preferences = RequestCodeEmailFragment.this.getActivity().getPreferences(0);
                String email = preferences.getString(RequestCodeEmailFragment.LAST_EMAIL_KEY, null);
                if (email != null) {
                    RequestCodeEmailFragment.this.bus.post((Object)new PasscodeSentEvent(email));
                }
            }
        });
    }

    private void requestPasscode() {
        AuthenticationError error = this.validator.validateFrom((Fragment)this);
        if (error == null) {
            this.sendRequestCode();
        } else {
            this.bus.post((Object)error);
        }
    }

    private void sendRequestCode() {
        this.sendButton.setEnabled(false);
        this.sendButton.setText((CharSequence)"");
        this.progressBar.setVisibility(0);
        String email = this.emailField.getText().toString();
        this.bus.post((Object)new PasscodeRequestedEvent(email));
    }

    @Subscribe
    public void onPasscodeSentEvent(PasscodeSentEvent event) {
        SharedPreferences.Editor editor = this.getActivity().getPreferences(0).edit();
        editor.putString(LAST_EMAIL_KEY, event.getUsername());
        editor.apply();
        this.sendButton.setEnabled(true);
        this.sendButton.setText(R.string.com_auth0_passwordless_send_passcode_btn_text);
        this.progressBar.setVisibility(8);
    }

    @Subscribe
    public void onAuthenticationError(AuthenticationError error) {
        this.sendButton.setEnabled(true);
        this.sendButton.setText(R.string.com_auth0_passwordless_send_passcode_btn_text);
        this.progressBar.setVisibility(8);
    }
}

