/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.lock.passwordless.fragment;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ProgressBar;
import com.auth0.lock.event.AuthenticationError;
import com.auth0.lock.fragment.BaseTitledFragment;
import com.auth0.lock.passwordless.R;
import com.auth0.lock.passwordless.event.CountryCodeSelectedEvent;
import com.auth0.lock.passwordless.event.PasscodeRequestedEvent;
import com.auth0.lock.passwordless.event.PasscodeSentEvent;
import com.auth0.lock.passwordless.event.SelectCountryCodeEvent;
import com.auth0.lock.passwordless.task.LoadCountriesTask;
import com.auth0.lock.passwordless.validation.PhoneNumberValidator;
import com.auth0.lock.passwordless.widget.PhoneField;
import com.auth0.lock.validation.Validator;
import com.squareup.otto.Subscribe;
import java.util.Locale;
import java.util.Map;

public class RequestCodeSmsFragment
extends BaseTitledFragment {
    private static final String TAG = RequestCodeSmsFragment.class.getName();
    private static final String LAST_PHONE_NUMBER_KEY = "LAST_PHONE_NUMBER";
    private static final String LAST_PHONE_DIAL_CODE_KEY = "LAST_PHONE_DIAL_CODE_KEY";
    private static final String USE_MAGIC_LINK_ARGUMENT = "USE_MAGIC_LINK_ARGUMENT";
    private boolean useMagicLink;
    AsyncTask<String, Void, Map<String, String>> task;
    Validator validator;
    PhoneField phoneField;
    Button sendButton;
    ProgressBar progressBar;

    public static RequestCodeSmsFragment newInstance(boolean useMagicLink) {
        RequestCodeSmsFragment fragment = new RequestCodeSmsFragment();
        Bundle args = new Bundle();
        args.putBoolean(USE_MAGIC_LINK_ARGUMENT, useMagicLink);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Log.v((String)TAG, (String)"Loading countries...");
        if (this.getArguments() != null) {
            this.useMagicLink = this.getArguments().getBoolean(USE_MAGIC_LINK_ARGUMENT);
        }
        this.bus.register((Object)this);
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.task != null) {
            this.task.cancel(true);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.bus.unregister((Object)this);
    }

    protected int getTitleResource() {
        return R.string.com_auth0_passwordless_title_send_passcode;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.com_auth0_passwordless_fragment_request_code_sms, container, false);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.validator = new PhoneNumberValidator(R.id.com_auth0_passwordless_phone_field_sms, R.string.com_auth0_passwordless_send_code_error_tile_sms, R.string.com_auth0_passwordless_send_code_no_phone_message_sms);
        this.phoneField = (PhoneField)view.findViewById(R.id.com_auth0_passwordless_phone_field_sms);
        this.phoneField.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RequestCodeSmsFragment.this.bus.post((Object)new SelectCountryCodeEvent());
            }
        });
        SharedPreferences preferences = this.getActivity().getPreferences(0);
        String phoneNumber = preferences.getString(LAST_PHONE_NUMBER_KEY, null);
        final String dialCode = preferences.getString(LAST_PHONE_DIAL_CODE_KEY, null);
        this.phoneField.setPhoneNumber(phoneNumber);
        this.task = new LoadCountriesTask((Context)this.getActivity()){

            protected void onPostExecute(Map<String, String> codes) {
                RequestCodeSmsFragment.this.task = null;
                if (codes != null) {
                    String code;
                    Locale locale = Locale.getDefault();
                    String string2 = code = dialCode != null ? dialCode : codes.get(locale.getCountry());
                    if (code != null) {
                        RequestCodeSmsFragment.this.phoneField.setDialCode(code);
                    }
                }
            }
        };
        this.task.execute((Object[])new String[]{"com_auth0_passwordless_countries.json"});
        this.sendButton = (Button)view.findViewById(R.id.com_auth0_passwordless_access_button_sms);
        this.sendButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RequestCodeSmsFragment.this.requestPasscode();
            }
        });
        this.progressBar = (ProgressBar)view.findViewById(R.id.com_auth0_passwordless_send_code_progress_indicator_sms);
        Button hasCodeButton = (Button)view.findViewById(R.id.com_auth0_passwordless_already_has_code_button_sms);
        hasCodeButton.setVisibility(!this.useMagicLink && phoneNumber != null && dialCode != null ? 0 : 8);
        hasCodeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SharedPreferences preferences = RequestCodeSmsFragment.this.getActivity().getPreferences(0);
                String phoneNumber = preferences.getString(RequestCodeSmsFragment.LAST_PHONE_NUMBER_KEY, null);
                String dialCode = preferences.getString(RequestCodeSmsFragment.LAST_PHONE_DIAL_CODE_KEY, null);
                if (phoneNumber != null && dialCode != null) {
                    RequestCodeSmsFragment.this.bus.post((Object)new PasscodeSentEvent(dialCode + phoneNumber));
                }
            }
        });
    }

    private void requestPasscode() {
        AuthenticationError error = this.validator.validateFrom((Fragment)this);
        if (error == null) {
            this.sendRequestCode();
        } else {
            this.bus.post((Object)error);
        }
    }

    private void sendRequestCode() {
        this.sendButton.setEnabled(false);
        this.sendButton.setText((CharSequence)"");
        this.progressBar.setVisibility(0);
        String phoneNumber = this.phoneField.getCompletePhoneNumber();
        this.bus.post((Object)new PasscodeRequestedEvent(phoneNumber));
    }

    @Subscribe
    public void onPasscodeSentEvent(PasscodeSentEvent event) {
        SharedPreferences.Editor editor = this.getActivity().getPreferences(0).edit();
        editor.putString(LAST_PHONE_NUMBER_KEY, this.phoneField.getPhoneNumber());
        editor.putString(LAST_PHONE_DIAL_CODE_KEY, this.phoneField.getDialCode());
        editor.apply();
        this.sendButton.setEnabled(true);
        this.sendButton.setText(R.string.com_auth0_passwordless_send_passcode_btn_text);
        this.progressBar.setVisibility(8);
    }

    @Subscribe
    public void onAuthenticationError(AuthenticationError error) {
        this.sendButton.setEnabled(true);
        this.sendButton.setText(R.string.com_auth0_passwordless_send_passcode_btn_text);
        this.progressBar.setVisibility(8);
    }

    @Subscribe
    public void onCountrySelected(CountryCodeSelectedEvent event) {
        Log.d((String)TAG, (String)("Received selected country " + event.getIsoCode() + " dial code " + event.getDialCode()));
        this.phoneField.setDialCode(event.getDialCode());
    }
}

