/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.lock.passwordless.util;

import android.content.Intent;
import android.net.Uri;
import android.util.Log;

public class AppLinkIntentParser {
    private static final String TAG = AppLinkIntentParser.class.getName();
    Intent intent;

    protected AppLinkIntentParser() {
    }

    public AppLinkIntentParser(Intent intent) {
        this.intent = intent;
    }

    public boolean isAppLinkIntent() {
        return "android.intent.action.VIEW".equals(this.intent.getAction());
    }

    public boolean isValidAppLinkIntent() {
        return 256 != this.getModeFromAppLink();
    }

    public int getModeFromAppLink() {
        String pathString;
        Uri uri;
        if (this.isAppLinkIntent() && null != (uri = this.intent.getData()) && null != this.getCodeFromAppLinkUri(uri) && null != (pathString = uri.getPath())) {
            if (pathString.matches("/android/.*/sms")) {
                return 16;
            }
            if (pathString.matches("/android/.*/email")) {
                return 17;
            }
        }
        Log.e((String)TAG, (String)("The app link doesn't match any of the supported types: " + this.intent));
        return 256;
    }

    public String getCodeFromAppLinkIntent() {
        Uri dataUri;
        String code;
        if (this.isAppLinkIntent() && (code = this.getCodeFromAppLinkUri(dataUri = this.intent.getData())) != null) {
            return code;
        }
        Log.d((String)TAG, (String)("Invalid app link intent: " + this.intent));
        return null;
    }

    protected String getCodeFromAppLinkUri(Uri uri) {
        if (uri == null) {
            return null;
        }
        return uri.getQueryParameter("code");
    }
}

