/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.client.channel;

import com.baidu.brpc.ChannelInfo;
import com.baidu.brpc.client.RpcClient;
import com.baidu.brpc.client.channel.AbstractBrpcChannel;
import com.baidu.brpc.client.instance.ServiceInstance;
import io.netty.channel.Channel;
import java.util.NoSuchElementException;

public class BrpcShortChannel
extends AbstractBrpcChannel {
    private volatile Channel channel;

    public BrpcShortChannel(ServiceInstance instance, RpcClient rpcClient) {
        super(instance, rpcClient.getBootstrap(), rpcClient.getProtocol(), rpcClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Channel getChannel() throws Exception, NoSuchElementException, IllegalStateException {
        if (this.channel == null || !this.channel.isActive()) {
            BrpcShortChannel brpcShortChannel = this;
            synchronized (brpcShortChannel) {
                if (this.channel != null && !this.channel.isActive()) {
                    this.channel.close();
                    this.channel = null;
                }
                if (this.channel == null) {
                    this.channel = this.connect(this.serviceInstance.getIp(), this.serviceInstance.getPort());
                    ChannelInfo channelInfo = ChannelInfo.getOrCreateClientChannelInfo(this.channel);
                    channelInfo.setProtocol(this.protocol);
                    channelInfo.setChannelGroup(this);
                }
            }
        }
        return this.channel;
    }

    @Override
    public void returnChannel(Channel channel) {
    }

    @Override
    public void removeChannel(Channel channel) {
        this.closeChannel();
    }

    @Override
    public void close() {
        this.closeChannel();
    }

    @Override
    public void updateMaxConnection(int num) {
    }

    @Override
    public int getCurrentMaxConnection() {
        return this.getActiveConnectionNum();
    }

    @Override
    public int getActiveConnectionNum() {
        if (this.channel != null && this.channel.isActive()) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getIdleConnectionNum() {
        if (this.channel == null || !this.channel.isActive()) {
            return 1;
        }
        return 0;
    }

    private void closeChannel() {
        if (this.channel != null && this.channel.isActive()) {
            this.channel.close();
        }
    }
}

