/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.client.instance;

import com.baidu.brpc.client.RpcClient;
import com.baidu.brpc.client.channel.BrpcChannel;
import com.baidu.brpc.client.channel.BrpcChannelFactory;
import com.baidu.brpc.client.instance.InstanceProcessor;
import com.baidu.brpc.client.instance.ServiceInstance;
import com.baidu.brpc.client.loadbalance.FairStrategy;
import com.baidu.brpc.thread.ClientHealthCheckTimerInstance;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhancedInstanceProcessor
implements InstanceProcessor {
    private static final Logger log = LoggerFactory.getLogger(EnhancedInstanceProcessor.class);
    private RpcClient rpcClient;
    private CopyOnWriteArraySet<ServiceInstance> instances;
    private CopyOnWriteArrayList<BrpcChannel> healthyInstanceChannels;
    private CopyOnWriteArrayList<BrpcChannel> unhealthyInstanceChannels;
    private ConcurrentMap<ServiceInstance, BrpcChannel> instanceChannelMap;
    private Lock lock;
    private Timer healthCheckTimer;
    private volatile boolean stop = false;

    public EnhancedInstanceProcessor(RpcClient rpcClient) {
        this.rpcClient = rpcClient;
        this.instances = new CopyOnWriteArraySet();
        this.healthyInstanceChannels = new CopyOnWriteArrayList();
        this.unhealthyInstanceChannels = new CopyOnWriteArrayList();
        this.instanceChannelMap = new ConcurrentHashMap<ServiceInstance, BrpcChannel>();
        this.lock = new ReentrantLock();
        this.healthCheckTimer = ClientHealthCheckTimerInstance.getOrCreateInstance();
        this.init();
    }

    private void init() {
        this.healthCheckTimer.newTimeout(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(Timeout timeout) throws Exception {
                if (!EnhancedInstanceProcessor.this.stop) {
                    ArrayList<BrpcChannel> newHealthyInstanceChannels = new ArrayList<BrpcChannel>();
                    for (BrpcChannel instance : EnhancedInstanceProcessor.this.unhealthyInstanceChannels) {
                        boolean isHealthy = EnhancedInstanceProcessor.this.isInstanceHealthy(instance.getServiceInstance().getIp(), instance.getServiceInstance().getPort());
                        if (!isHealthy) continue;
                        newHealthyInstanceChannels.add(instance);
                    }
                    ArrayList<BrpcChannel> newUnhealthyInstanceChannels = new ArrayList<BrpcChannel>();
                    for (BrpcChannel instance : EnhancedInstanceProcessor.this.healthyInstanceChannels) {
                        boolean isHealthy = EnhancedInstanceProcessor.this.isInstanceHealthy(instance.getServiceInstance().getIp(), instance.getServiceInstance().getPort());
                        if (isHealthy) continue;
                        newUnhealthyInstanceChannels.add(instance);
                    }
                    EnhancedInstanceProcessor.this.lock.lock();
                    try {
                        if (newHealthyInstanceChannels.size() > 0) {
                            ArrayList<BrpcChannel> effectiveInstances = new ArrayList<BrpcChannel>();
                            for (BrpcChannel brpcChannel : newHealthyInstanceChannels) {
                                if (!EnhancedInstanceProcessor.this.instances.contains(brpcChannel.getServiceInstance())) continue;
                                effectiveInstances.add(brpcChannel);
                            }
                            EnhancedInstanceProcessor.this.healthyInstanceChannels.addAll(effectiveInstances);
                            EnhancedInstanceProcessor.this.unhealthyInstanceChannels.removeAll(effectiveInstances);
                        }
                        if (newUnhealthyInstanceChannels.size() > 0) {
                            ArrayList<BrpcChannel> effectiveInstances = new ArrayList<BrpcChannel>();
                            for (BrpcChannel brpcChannel : newUnhealthyInstanceChannels) {
                                if (!EnhancedInstanceProcessor.this.instances.contains(brpcChannel.getServiceInstance())) continue;
                                effectiveInstances.add(brpcChannel);
                            }
                            EnhancedInstanceProcessor.this.healthyInstanceChannels.removeAll(effectiveInstances);
                            EnhancedInstanceProcessor.this.unhealthyInstanceChannels.addAll(effectiveInstances);
                            EnhancedInstanceProcessor.this.notifyInvalidInstance(effectiveInstances);
                        }
                    }
                    finally {
                        EnhancedInstanceProcessor.this.lock.unlock();
                    }
                    EnhancedInstanceProcessor.this.healthCheckTimer.newTimeout((TimerTask)this, (long)EnhancedInstanceProcessor.this.rpcClient.getRpcClientOptions().getHealthyCheckIntervalMillis(), TimeUnit.MILLISECONDS);
                }
            }
        }, (long)this.rpcClient.getRpcClientOptions().getHealthyCheckIntervalMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void addInstance(ServiceInstance instance) {
        this.lock.lock();
        try {
            if (this.instances.add(instance)) {
                BrpcChannel brpcChannel = BrpcChannelFactory.createChannel(instance, this.rpcClient);
                this.healthyInstanceChannels.add(brpcChannel);
                this.instanceChannelMap.putIfAbsent(instance, brpcChannel);
            } else {
                log.debug("endpoint already exist, {}:{}", (Object)instance.getIp(), (Object)instance.getPort());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void addInstances(Collection<ServiceInstance> addList) {
        for (ServiceInstance instance : addList) {
            this.addInstance(instance);
        }
    }

    @Override
    public void deleteInstances(Collection<ServiceInstance> deleteList) {
        for (ServiceInstance instance : deleteList) {
            this.deleteInstance(instance);
        }
    }

    @Override
    public CopyOnWriteArraySet<ServiceInstance> getInstances() {
        return this.instances;
    }

    @Override
    public CopyOnWriteArrayList<BrpcChannel> getHealthyInstanceChannels() {
        return this.healthyInstanceChannels;
    }

    @Override
    public CopyOnWriteArrayList<BrpcChannel> getUnHealthyInstanceChannels() {
        return this.unhealthyInstanceChannels;
    }

    @Override
    public ConcurrentMap<ServiceInstance, BrpcChannel> getInstanceChannelMap() {
        return this.instanceChannelMap;
    }

    @Override
    public void stop() {
        this.stop = true;
        for (BrpcChannel brpcChannel : this.healthyInstanceChannels) {
            brpcChannel.close();
        }
        for (BrpcChannel brpcChannel : this.unhealthyInstanceChannels) {
            brpcChannel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInstanceHealthy(String ip, int port) {
        boolean isHealthy = false;
        Socket socket = null;
        try {
            socket = new Socket(ip, port);
            isHealthy = true;
        }
        catch (Exception e) {
            log.warn("Recover socket test for {}:{} failed. message:{}", new Object[]{ip, port, e.getMessage()});
            isHealthy = false;
        }
        finally {
            block13: {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException e) {
                    if (!log.isDebugEnabled()) break block13;
                    log.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        return isHealthy;
    }

    private void deleteInstance(ServiceInstance instance) {
        this.lock.lock();
        try {
            if (this.instances.remove(instance)) {
                ArrayList<BrpcChannel> removedInstanceChannels = new ArrayList<BrpcChannel>();
                this.removeInstanceChannels(this.healthyInstanceChannels, instance, removedInstanceChannels);
                if (removedInstanceChannels.size() == 0) {
                    this.removeInstanceChannels(this.unhealthyInstanceChannels, instance, removedInstanceChannels);
                }
                this.instanceChannelMap.remove(instance);
                this.notifyInvalidInstance(removedInstanceChannels);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void notifyInvalidInstance(List<BrpcChannel> invalidInstances) {
        if (this.rpcClient.getRpcClientOptions().getLoadBalanceType() == 3) {
            ((FairStrategy)this.rpcClient.getLoadBalanceStrategy()).markInvalidInstance(invalidInstances);
        }
    }

    private void removeInstanceChannels(CopyOnWriteArrayList<BrpcChannel> checkedInstanceChannels, ServiceInstance instance, List<BrpcChannel> removedInstanceChannels) {
        for (BrpcChannel brpcChannel : checkedInstanceChannels) {
            if (!brpcChannel.getServiceInstance().equals(instance)) continue;
            checkedInstanceChannels.remove(brpcChannel);
            brpcChannel.close();
            removedInstanceChannels.add(brpcChannel);
            break;
        }
    }
}

