/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.protocol.http;

import com.baidu.brpc.ChannelInfo;
import com.baidu.brpc.ProtobufRpcMethodInfo;
import com.baidu.brpc.RpcMethodInfo;
import com.baidu.brpc.buffer.DynamicCompositeByteBuf;
import com.baidu.brpc.client.RpcClient;
import com.baidu.brpc.client.RpcFuture;
import com.baidu.brpc.client.channel.BrpcChannel;
import com.baidu.brpc.exceptions.BadSchemaException;
import com.baidu.brpc.exceptions.NotEnoughDataException;
import com.baidu.brpc.exceptions.RpcException;
import com.baidu.brpc.exceptions.TooBigDataException;
import com.baidu.brpc.naming.DnsNamingService;
import com.baidu.brpc.naming.NamingService;
import com.baidu.brpc.protocol.AbstractProtocol;
import com.baidu.brpc.protocol.BrpcMeta;
import com.baidu.brpc.protocol.HttpRequest;
import com.baidu.brpc.protocol.HttpResponse;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.Response;
import com.baidu.brpc.protocol.http.BrpcHttpObjectDecoder;
import com.baidu.brpc.protocol.http.BrpcHttpRequestEncoder;
import com.baidu.brpc.protocol.http.BrpcHttpResponseEncoder;
import com.baidu.brpc.server.ServiceManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRpcProtocol
extends AbstractProtocol {
    public static final String PROTOCOL_TYPE = "protocol-type";
    private static final Logger LOG = LoggerFactory.getLogger(HttpRpcProtocol.class);
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final String CONTENT_TYPE_PROTOBUF = "application/proto";
    private static final String CORRELATION_ID = "correlationId";
    private static final JsonFormat jsonPbConverter = new JsonFormat(){

        protected void print(Message message, JsonFormat.JsonGenerator generator) throws IOException {
            Iterator iter = message.getAllFields().entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry field = iter.next();
                this.printField((Descriptors.FieldDescriptor)field.getKey(), field.getValue(), generator);
                if (!iter.hasNext()) continue;
                generator.print((CharSequence)",");
            }
        }
    };
    private static final Gson gson = new GsonBuilder().serializeNulls().disableHtmlEscaping().serializeSpecialFloatingPointValues().create();
    private static final JsonParser jsonParser = new JsonParser();
    private static final Set<String> prohibitedHeaders = new HashSet<String>();
    protected int protocolType;
    protected String encoding;

    public HttpRpcProtocol(int protocolType, String encoding) {
        this.protocolType = protocolType;
        this.encoding = encoding;
    }

    @Override
    public Request createRequest() {
        return new HttpRequest();
    }

    @Override
    public Response createResponse() {
        return new HttpResponse();
    }

    @Override
    public Request getRequest() {
        HttpRequest request = HttpRequest.getHttpRequest();
        request.reset();
        return request;
    }

    @Override
    public Response getResponse() {
        HttpResponse response = HttpResponse.getHttpResponse();
        response.reset();
        return response;
    }

    @Override
    public Object decode(ChannelHandlerContext ctx, DynamicCompositeByteBuf in, boolean isDecodingRequest) throws BadSchemaException, TooBigDataException, NotEnoughDataException {
        HttpMessage httpMessage = null;
        ByteBuf byteBuf = in.retainedSlice(in.readableBytes());
        boolean decodeSuccess = false;
        try {
            httpMessage = (HttpMessage)BrpcHttpObjectDecoder.getDecoder(isDecodingRequest).decode(ctx, byteBuf);
            if (httpMessage != null) {
                String[] splits;
                String contentType;
                if (httpMessage.decoderResult() != null && httpMessage.decoderResult().isFailure()) {
                    LOG.debug("failed to decode http message", httpMessage.decoderResult().cause());
                    throw new BadSchemaException();
                }
                String contentTypeAndEncoding = httpMessage.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{contentTypeAndEncoding}) && !(contentType = (splits = StringUtils.split((String)(contentTypeAndEncoding = contentTypeAndEncoding.toLowerCase()), (String)";"))[0]).equals(CONTENT_TYPE_PROTOBUF) && !contentType.equals(CONTENT_TYPE_JSON)) {
                    httpMessage = null;
                    throw new BadSchemaException();
                }
                decodeSuccess = true;
            }
        }
        catch (Exception e) {
            throw new BadSchemaException();
        }
        finally {
            if (decodeSuccess) {
                in.skipBytes(byteBuf.readerIndex());
            }
            byteBuf.release();
        }
        if (httpMessage == null) {
            throw notEnoughDataException;
        }
        return httpMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf encodeRequest(Request request) throws Exception {
        HttpRequest httpRequest = (HttpRequest)request;
        String serviceName = httpRequest.getTargetMethod().getDeclaringClass().getName();
        String methodName = httpRequest.getTargetMethod().getName();
        BrpcMeta rpcMeta = httpRequest.getTargetMethod().getAnnotation(BrpcMeta.class);
        if (rpcMeta != null) {
            serviceName = rpcMeta.serviceName();
            methodName = rpcMeta.methodName();
        }
        LOG.debug("serviceName={}, methodName={}", (Object)serviceName, (Object)methodName);
        Object httpRequestBody = this.makeRequest((int)httpRequest.getLogId(), methodName, httpRequest.getArgs());
        byte[] httpRequestBodyBytes = this.encodeBody(this.protocolType, this.encoding, httpRequestBody, httpRequest.getRpcMethodInfo());
        DefaultFullHttpRequest nettyHttpRequest = null;
        try {
            nettyHttpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "");
            nettyHttpRequest.setUri(this.buildHttpUri(serviceName, methodName));
            if (httpRequestBodyBytes != null) {
                nettyHttpRequest.content().writeBytes(httpRequestBodyBytes);
            }
            String contentType = this.getContentType(this.protocolType);
            nettyHttpRequest.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)(contentType + "; charset=" + this.encoding));
            nettyHttpRequest.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)(httpRequestBodyBytes == null ? 0 : httpRequestBodyBytes.length));
            nettyHttpRequest.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            nettyHttpRequest.headers().set(CORRELATION_ID, (Object)httpRequest.getCorrelationId());
            for (Map.Entry header : httpRequest.headers()) {
                if (prohibitedHeaders.contains(((String)header.getKey()).toLowerCase())) continue;
                nettyHttpRequest.headers().set((String)header.getKey(), header.getValue());
            }
            if (request.getKvAttachment() != null) {
                for (Map.Entry<String, Object> kv : request.getKvAttachment().entrySet()) {
                    if (prohibitedHeaders.contains(kv.getKey().toLowerCase())) continue;
                    nettyHttpRequest.headers().set(kv.getKey(), kv.getValue());
                }
            }
            BrpcHttpRequestEncoder encoder = new BrpcHttpRequestEncoder();
            ByteBuf byteBuf = encoder.encode(nettyHttpRequest);
            return byteBuf;
        }
        finally {
            if (nettyHttpRequest != null) {
                nettyHttpRequest.release();
            }
        }
    }

    @Override
    public void beforeRequestSent(Request request, RpcClient rpcClient, BrpcChannel channelGroup) {
        HttpRequest httpRequest = (HttpRequest)request;
        NamingService namingService = rpcClient.getNamingService();
        if (!httpRequest.headers().contains((CharSequence)HttpHeaderNames.HOST)) {
            String hostPort = namingService != null && namingService instanceof DnsNamingService ? ((DnsNamingService)namingService).getHostPort() : channelGroup.getServiceInstance().getIp() + ":" + channelGroup.getServiceInstance().getPort();
            httpRequest.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)hostPort);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response decodeResponse(Object msg, ChannelHandlerContext ctx) {
        FullHttpResponse httpResponse = (FullHttpResponse)msg;
        try {
            ChannelInfo channelInfo = ChannelInfo.getClientChannelInfo(ctx.channel());
            Long correlationId = this.parseCorrelationId(httpResponse.headers().get(CORRELATION_ID), channelInfo.getCorrelationId());
            HttpResponse response = new HttpResponse();
            response.setCorrelationId(correlationId);
            RpcFuture future = channelInfo.removeRpcFuture(response.getCorrelationId());
            if (future == null) {
                HttpResponse httpResponse2 = response;
                return httpResponse2;
            }
            response.setRpcFuture(future);
            if (!httpResponse.status().equals((Object)HttpResponseStatus.OK)) {
                LOG.warn("status={}", (Object)httpResponse.status());
                response.setException(new RpcException(3, "http status=" + httpResponse.status()));
                HttpResponse httpResponse3 = response;
                return httpResponse3;
            }
            int bodyLen = httpResponse.content().readableBytes();
            byte[] bytes = new byte[bodyLen];
            httpResponse.content().readBytes(bytes);
            String contentTypeAndEncoding = httpResponse.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE).toLowerCase();
            String[] splits = StringUtils.split((String)contentTypeAndEncoding, (String)";");
            int protocolType = HttpRpcProtocol.parseProtocolType(splits[0]);
            String encoding = this.encoding;
            Object body = null;
            if (bodyLen != 0) {
                try {
                    body = this.decodeBody(protocolType, encoding, bytes);
                }
                catch (Exception ex) {
                    LOG.error("decode response body failed");
                    response.setException(ex);
                    HttpResponse httpResponse4 = response;
                    httpResponse.release();
                    return httpResponse4;
                }
            }
            if (body != null) {
                try {
                    response.setResult(this.parseHttpResponse(body, future.getRpcMethodInfo()));
                }
                catch (Exception ex) {
                    LOG.error("failed to parse result from HTTP body");
                    response.setException(ex);
                }
            } else {
                response.setResult(null);
            }
            if (response.getKvAttachment() == null) {
                response.setKvAttachment(new HashMap<String, Object>());
            }
            for (Map.Entry entry : httpResponse.headers()) {
                response.getKvAttachment().put((String)entry.getKey(), entry.getValue());
            }
            HttpResponse httpResponse5 = response;
            return httpResponse5;
        }
        finally {
            httpResponse.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Request decodeRequest(Object packet) {
        try {
            HttpRequest httpRequest = (HttpRequest)this.createRequest();
            httpRequest.setMsg(packet);
            long correlationId = this.parseCorrelationId(httpRequest.headers().get(CORRELATION_ID), null);
            httpRequest.setCorrelationId(correlationId);
            String contentTypeAndEncoding = httpRequest.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE).toLowerCase();
            String[] splits = StringUtils.split((String)contentTypeAndEncoding, (String)";");
            int protocolType = HttpRpcProtocol.parseProtocolType(splits[0]);
            String encoding = this.encoding;
            for (String string : splits) {
                String string2 = string.trim();
                if (!string2.startsWith("charset=")) continue;
                encoding = string2.substring("charset=".length());
            }
            httpRequest.headers().set(PROTOCOL_TYPE, (Object)protocolType);
            httpRequest.headers().set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, (Object)encoding);
            if (httpRequest.getKvAttachment() == null) {
                httpRequest.setKvAttachment(new HashMap<String, Object>());
            }
            for (Map.Entry entry : httpRequest.headers()) {
                httpRequest.getKvAttachment().put((String)entry.getKey(), entry.getValue());
            }
            ByteBuf byteBuf = httpRequest.content();
            int bodyLen = byteBuf.readableBytes();
            if (bodyLen == 0) {
                String errMsg = String.format("body should not be null, uri:%s", httpRequest.uri());
                LOG.warn(errMsg);
                httpRequest.setException(new RpcException(3, errMsg));
                HttpRequest httpRequest2 = httpRequest;
                return httpRequest2;
            }
            byte[] requestBytes = new byte[bodyLen];
            byteBuf.readBytes(requestBytes, 0, bodyLen);
            Object object = this.decodeBody(protocolType, encoding, requestBytes);
            QueryStringDecoder queryStringDecoder = new QueryStringDecoder(httpRequest.uri());
            String path = queryStringDecoder.path();
            String serviceName = null;
            String methodName = null;
            if (protocolType == 29 || protocolType == 30) {
                String[] uriSplit = path.split("/");
                if (uriSplit.length < 3) {
                    String errMsg = String.format("url format is error, path:%s", path);
                    LOG.warn(errMsg);
                    httpRequest.setException(new RpcException(3, errMsg));
                    HttpRequest httpRequest3 = httpRequest;
                    return httpRequest3;
                }
                serviceName = uriSplit[uriSplit.length - 2];
                methodName = uriSplit[uriSplit.length - 1];
            } else {
                JsonObject bodyObject = (JsonObject)object;
                methodName = bodyObject.get("method").getAsString();
                serviceName = path;
            }
            ServiceManager serviceManager = ServiceManager.getInstance();
            RpcMethodInfo rpcMethodInfo = serviceManager.getService(serviceName, methodName);
            if (rpcMethodInfo == null) {
                String errMsg = String.format("Fail to find path=%s", path);
                LOG.warn(errMsg);
                httpRequest.setException(new RpcException(3, errMsg));
                HttpRequest httpRequest4 = httpRequest;
                return httpRequest4;
            }
            httpRequest.setServiceName(rpcMethodInfo.getServiceName());
            httpRequest.setMethodName(rpcMethodInfo.getMethodName());
            httpRequest.setRpcMethodInfo(rpcMethodInfo);
            httpRequest.setTargetMethod(rpcMethodInfo.getMethod());
            httpRequest.setTarget(rpcMethodInfo.getTarget());
            httpRequest.setArgs(this.parseRequestParam(protocolType, object, rpcMethodInfo));
            HttpRequest httpRequest5 = httpRequest;
            return httpRequest5;
        }
        finally {
            ((FullHttpRequest)packet).release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf encodeResponse(Request request, Response response) {
        FullHttpRequest httpRequest = (FullHttpRequest)request.getMsg();
        DefaultFullHttpResponse httpResponse = null;
        try {
            if (response.getException() != null) {
                httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR);
            } else {
                httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
                this.addHttpResponseHeaders((FullHttpResponse)httpResponse, response, httpRequest);
                int protocolType = Integer.parseInt(httpRequest.headers().get(PROTOCOL_TYPE));
                Object body = this.makeResponse(protocolType, response);
                try {
                    byte[] responseBytes = this.encodeBody(protocolType, httpRequest.headers().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING), body, response.getRpcMethodInfo());
                    httpResponse.content().writeBytes(responseBytes);
                    httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)responseBytes.length);
                }
                catch (Exception e) {
                    LOG.warn("encode response failed", (Throwable)e);
                    response.setException(e);
                    httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR);
                }
            }
            BrpcHttpResponseEncoder encoder = new BrpcHttpResponseEncoder();
            ByteBuf byteBuf = encoder.encode(httpResponse);
            return byteBuf;
        }
        catch (Exception e) {
            LOG.warn("encode response failed", (Throwable)e);
            response.setException(e);
            ByteBuf byteBuf = null;
            return byteBuf;
        }
        finally {
            if (httpResponse != null) {
                httpResponse.release();
            }
        }
    }

    @Override
    public void afterResponseSent(Request request, Response response, ChannelFuture channelFuture) {
        if (!HttpUtil.isKeepAlive((HttpMessage)((HttpRequest)request).getNettyHttpRequest())) {
            channelFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public byte[] encodeResponseBody(int protocolType, Request request, Response response) {
        FullHttpRequest httpRequest = (FullHttpRequest)request.getMsg();
        Object body = this.makeResponse(protocolType, response);
        return this.encodeBody(protocolType, httpRequest.headers().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING), body, response.getRpcMethodInfo());
    }

    @Override
    public boolean returnChannelBeforeResponse() {
        return false;
    }

    @Override
    public boolean isCoexistence() {
        return true;
    }

    public static int parseProtocolType(String contentType) {
        String contentType2 = contentType.toLowerCase();
        if (contentType2.equals(CONTENT_TYPE_JSON)) {
            return 30;
        }
        if (contentType2.equals(CONTENT_TYPE_PROTOBUF)) {
            return 29;
        }
        LOG.warn("unknown contentType={}", (Object)contentType);
        throw new RpcException(5, "unknown contentType=" + contentType);
    }

    public String getContentType(Integer protocolType) {
        String contentType;
        switch (protocolType) {
            case 30: {
                contentType = CONTENT_TYPE_JSON;
                break;
            }
            case 29: {
                contentType = CONTENT_TYPE_PROTOBUF;
                break;
            }
            default: {
                LOG.warn("unknown protocolType={}", (Object)protocolType);
                throw new RpcException(5, "unknown protocolType=" + protocolType);
            }
        }
        return contentType;
    }

    public byte[] encodeBody(int protocolType, String encoding, Object body, RpcMethodInfo rpcMethodInfo) {
        byte[] bodyBytes;
        try {
            switch (protocolType) {
                case 30: {
                    String bodyJson = "";
                    if (rpcMethodInfo instanceof ProtobufRpcMethodInfo) {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        jsonPbConverter.print((Message)body, (OutputStream)out, Charset.forName(encoding));
                        out.flush();
                        bodyJson = out.toString(encoding);
                    } else {
                        bodyJson = gson.toJson(body);
                    }
                    bodyBytes = bodyJson.getBytes(encoding);
                    break;
                }
                case 29: {
                    if (rpcMethodInfo.getTarget() != null) {
                        bodyBytes = rpcMethodInfo.outputEncode(body);
                        break;
                    }
                    bodyBytes = rpcMethodInfo.inputEncode(body);
                    break;
                }
                default: {
                    LOG.warn("unkown protocolType={}", (Object)protocolType);
                    throw new RpcException(5, "unkown protocolType=" + protocolType);
                }
            }
        }
        catch (Exception ex) {
            throw new RpcException(5, "encode body failed", ex);
        }
        return bodyBytes;
    }

    public Object decodeBody(int protocolType, String encoding, byte[] bytes) {
        Object body = null;
        try {
            switch (protocolType) {
                case 30: {
                    body = new String(bytes, encoding);
                    break;
                }
                case 29: {
                    body = bytes;
                    break;
                }
                default: {
                    LOG.warn("unknown protocolType={}", (Object)protocolType);
                    throw new RpcException(5, "unknown protocolType=" + protocolType);
                }
            }
        }
        catch (Exception ex) {
            LOG.error("decodeBody failed", (Throwable)ex);
            throw new RpcException(5, "decode body failed", ex);
        }
        return body;
    }

    public void addHttpResponseHeaders(FullHttpResponse fullHttpResponse, Response response, FullHttpRequest fullHttpRequest) {
        boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)fullHttpRequest);
        if (keepAlive) {
            fullHttpResponse.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
        fullHttpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)fullHttpRequest.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE));
        if (fullHttpRequest.headers().contains("callId")) {
            fullHttpResponse.headers().set("callId", (Object)fullHttpRequest.headers().get("callId"));
        }
        if (fullHttpRequest.headers().contains(CORRELATION_ID)) {
            fullHttpResponse.headers().set(CORRELATION_ID, (Object)fullHttpRequest.headers().get(CORRELATION_ID));
        }
        if (response.getKvAttachment() != null) {
            for (Map.Entry<String, Object> entry : response.getKvAttachment().entrySet()) {
                fullHttpResponse.headers().set(entry.getKey(), entry.getValue());
            }
        }
    }

    public Object makeRequest(int id, String methodName, Object[] args) {
        if (this.protocolType == 30) {
            if (args == null || args.length == 0) {
                return null;
            }
            return args[0];
        }
        if (this.protocolType == 29) {
            if (args == null || args.length == 0) {
                return null;
            }
            return args[0];
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jsonrpc", "2.0");
        map.put("method", methodName);
        if (args != null) {
            map.put("params", args);
        } else {
            map.put("params", new Object[0]);
        }
        map.put("id", "" + id);
        return gson.toJsonTree(map);
    }

    public Object makeResponse(int protocolType, Response response) {
        Long id = response.getLogId();
        if (protocolType == 30) {
            return response.getResult();
        }
        if (protocolType == 29) {
            return response.getResult();
        }
        JsonObject res = new JsonObject();
        JsonElement result = gson.toJsonTree(response.getResult(), response.getRpcMethodInfo().getMethod().getReturnType());
        res.addProperty("jsonrpc", "2.0");
        if (result != null) {
            res.add("result", result);
        } else {
            res.addProperty("error", "bad request");
        }
        if (id != null) {
            res.addProperty("id", (Number)id.intValue());
        }
        return res;
    }

    public String buildHttpUri(String serviceName, String methodName) {
        return "/" + serviceName + "/" + methodName;
    }

    public long parseCorrelationId(String headerCorrelationId, Long channelAttachCorrelationId) {
        if (headerCorrelationId != null) {
            return Long.valueOf(headerCorrelationId);
        }
        if (channelAttachCorrelationId != null) {
            return channelAttachCorrelationId;
        }
        return -1L;
    }

    public Object parseHttpResponse(Object body, RpcMethodInfo rpcMethodInfo) {
        Object response;
        try {
            switch (this.protocolType) {
                case 30: {
                    if (rpcMethodInfo instanceof ProtobufRpcMethodInfo) {
                        ProtobufRpcMethodInfo protobufRpcMethodInfo = (ProtobufRpcMethodInfo)rpcMethodInfo;
                        Message.Builder rspBuilder = protobufRpcMethodInfo.getOutputInstance().newBuilderForType();
                        jsonPbConverter.merge((CharSequence)((String)body), ExtensionRegistry.getEmptyRegistry(), rspBuilder);
                        response = rspBuilder.build();
                        break;
                    }
                    response = gson.fromJson((String)body, rpcMethodInfo.getOutputClass());
                    break;
                }
                case 29: {
                    response = rpcMethodInfo.outputDecode((byte[])body);
                    break;
                }
                default: {
                    LOG.warn("unknown protocolType={}", (Object)this.protocolType);
                    throw new RpcException(5, "unknown protocolType=" + this.protocolType);
                }
            }
        }
        catch (Exception ex) {
            LOG.error("parse rpc response error", (Throwable)ex);
            throw new RpcException(5, "parse rpc response error", ex);
        }
        return response;
    }

    public Object[] parseRequestParam(int protocolType, Object body, RpcMethodInfo rpcMethodInfo) {
        if (body == null) {
            return null;
        }
        Object[] args = new Object[rpcMethodInfo.getMethod().getGenericParameterTypes().length];
        if (protocolType == 30) {
            try {
                if (rpcMethodInfo instanceof ProtobufRpcMethodInfo) {
                    ProtobufRpcMethodInfo protobufRpcMethodInfo = (ProtobufRpcMethodInfo)rpcMethodInfo;
                    Message.Builder argBuilder = protobufRpcMethodInfo.getInputInstance().newBuilderForType();
                    jsonPbConverter.merge((CharSequence)((String)body), ExtensionRegistry.getEmptyRegistry(), argBuilder);
                    args[0] = argBuilder.build();
                }
                args[0] = gson.fromJson((String)body, rpcMethodInfo.getInputClasses()[0]);
            }
            catch (Exception e) {
                LOG.error("decodeBody failed", (Throwable)e);
                throw new RpcException(5, "decode body failed", e);
            }
        } else if (protocolType == 29) {
            Object requestMessage = null;
            try {
                requestMessage = rpcMethodInfo.inputDecode((byte[])body);
            }
            catch (Exception ex) {
                LOG.error("invoke protobuf method error, ex : ", (Throwable)ex);
                return null;
            }
            args[0] = requestMessage;
        } else {
            throw new RpcException(5, "unknown protocol");
        }
        return args;
    }

    static {
        prohibitedHeaders.add(HttpHeaderNames.CONTENT_TYPE.toString());
        prohibitedHeaders.add(HttpHeaderNames.CONTENT_LENGTH.toString());
        prohibitedHeaders.add(HttpHeaderNames.CONNECTION.toString());
        prohibitedHeaders.add(CORRELATION_ID);
    }
}

