/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.protocol.stargate;

import com.baidu.brpc.ChannelInfo;
import com.baidu.brpc.RpcMethodInfo;
import com.baidu.brpc.buffer.DynamicCompositeByteBuf;
import com.baidu.brpc.client.RpcFuture;
import com.baidu.brpc.exceptions.BadSchemaException;
import com.baidu.brpc.exceptions.NotEnoughDataException;
import com.baidu.brpc.exceptions.TooBigDataException;
import com.baidu.brpc.protocol.AbstractProtocol;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.Response;
import com.baidu.brpc.protocol.RpcRequest;
import com.baidu.brpc.protocol.RpcResponse;
import com.baidu.brpc.protocol.stargate.StargateRpcRequestPacket;
import com.baidu.brpc.protocol.stargate.StargateRpcResponsePacket;
import com.baidu.brpc.protocol.stargate.StargateURI;
import com.baidu.brpc.server.ServiceManager;
import com.baidu.brpc.utils.NetUtils;
import com.dyuproject.protostuff.LinkedBuffer;
import com.dyuproject.protostuff.ProtobufIOUtil;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.runtime.RuntimeSchema;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StargateRpcProtocol
extends AbstractProtocol {
    private static final Logger log = LoggerFactory.getLogger(StargateRpcProtocol.class);
    private static final int FIXED_HEAD_LEN = 4;
    private static final NotEnoughDataException notEnoughDataException = new NotEnoughDataException("Stargate not enough data");
    private static final String SERIALIZATION_EXCEPTION = "decode error,this problem is usually caused by\n 1: difference of api.jar between server and client.\n 2: server do not catch Exception.\n 3: API contains a type that Stargate does not support. eg:HashMap.keySet()";
    private static Set<String> redundantAttachments = new HashSet<String>(){
        {
            this.add("parameterTypes");
            this.add("localPort");
            this.add("remoteHost");
            this.add("parmeters");
            this.add("remotePort");
            this.add("methodName");
            this.add("consumer.start");
            this.add("uri");
            this.add("c.e.i.id");
            this.add("stargate.sid");
            this.add("stargate.rid");
            this.add("localHost");
            this.add("c.app.name");
        }
    };
    private ServiceManager serviceManager = ServiceManager.getInstance();
    private boolean init = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initEnv() {
        if (this.init) return;
        Class<StargateRpcProtocol> clazz = StargateRpcProtocol.class;
        synchronized (StargateRpcProtocol.class) {
            if (this.init) return;
            System.setProperty("protostuff.runtime.collection_schema_on_repeated_fields", "true");
            System.setProperty("protostuff.runtime.morph_collection_interfaces", "true");
            System.setProperty("protostuff.runtime.morph_map_interfaces", "true");
            this.init = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object decode(ChannelHandlerContext ctx, DynamicCompositeByteBuf in, boolean isDecodingRequest) throws TooBigDataException, NotEnoughDataException, BadSchemaException {
        if (in.readableBytes() < 4) {
            throw notEnoughDataException;
        }
        ByteBuf head = in.retainedSlice(4);
        try {
            int bodySize = head.readInt();
            if (in.readableBytes() < bodySize + 4) {
                throw notEnoughDataException;
            }
            if (bodySize > 0x20000000) {
                throw new TooBigDataException("StarGate too big body size:" + bodySize);
            }
            byte[] body = new byte[bodySize];
            in.skipBytes(4);
            in.readBytes(body);
            byte[] byArray = body;
            return byArray;
        }
        finally {
            head.release();
        }
    }

    @Override
    public ByteBuf encodeRequest(Request request) throws Exception {
        StargateURI stargateURI = new StargateURI.Builder("star", NetUtils.getLogHost(), 0).param("version", request.getSubscribeInfo().getVersion()).param("group", request.getSubscribeInfo().getGroup()).param("interface", request.getSubscribeInfo().getInterfaceName()).param("consumer.id", UUID.randomUUID().toString()).build();
        Method method = request.getTargetMethod();
        StargateRpcRequestPacket requestPacket = new StargateRpcRequestPacket(stargateURI, method.getName(), method.getParameterTypes(), request.getArgs());
        requestPacket.setId(request.getCorrelationId() + "");
        if (request.getKvAttachment() != null && !request.getKvAttachment().isEmpty()) {
            requestPacket.setAttachments(request.getKvAttachment());
        }
        try {
            this.initEnv();
            Schema schema = RuntimeSchema.getSchema(StargateRpcRequestPacket.class);
            byte[] body = ProtobufIOUtil.toByteArray((Object)requestPacket, (Schema)schema, (LinkedBuffer)LinkedBuffer.allocate((int)500));
            byte[] head = this.buildHead(body);
            return Unpooled.wrappedBuffer((byte[][])new byte[][]{head, body});
        }
        catch (Exception e) {
            log.warn(SERIALIZATION_EXCEPTION, (Throwable)e);
            throw new BadSchemaException(SERIALIZATION_EXCEPTION, (Throwable)e);
        }
    }

    @Override
    public Response decodeResponse(Object msg, ChannelHandlerContext ctx) throws Exception {
        try {
            StargateRpcResponsePacket rpcResponse = new StargateRpcResponsePacket();
            Schema schema = RuntimeSchema.getSchema(StargateRpcResponsePacket.class);
            ProtobufIOUtil.mergeFrom((byte[])((byte[])msg), (Object)rpcResponse, (Schema)schema);
            try {
                RpcResponse response = new RpcResponse();
                response.setResult(rpcResponse.getResult());
                long correlationId = Long.parseLong(rpcResponse.getId());
                ChannelInfo channelInfo = ChannelInfo.getClientChannelInfo(ctx.channel());
                RpcFuture future = channelInfo.removeRpcFuture(correlationId);
                if (future == null) {
                    return response;
                }
                response.setRpcFuture(future);
                response.setCorrelationId(correlationId);
                response.setKvAttachment(rpcResponse.getAttachments());
                return response;
            }
            catch (NumberFormatException n) {
                log.error(" when brpc is Client unexpect logId at {}", (Object)rpcResponse.getId(), (Object)n);
                throw new BadSchemaException(SERIALIZATION_EXCEPTION, (Throwable)n);
            }
        }
        catch (Exception e) {
            log.warn(SERIALIZATION_EXCEPTION, (Throwable)e);
            throw new BadSchemaException(SERIALIZATION_EXCEPTION, (Throwable)e);
        }
    }

    @Override
    public Request decodeRequest(Object packet) throws BadSchemaException {
        try {
            StargateRpcRequestPacket requestPacket = new StargateRpcRequestPacket();
            this.initEnv();
            Schema schema = RuntimeSchema.getSchema(StargateRpcRequestPacket.class);
            ProtobufIOUtil.mergeFrom((byte[])((byte[])packet), (Object)requestPacket, (Schema)schema);
            String serviceName = requestPacket.getUri().getServiceName();
            String methodName = requestPacket.getMethodName();
            RpcMethodInfo rpcMethodInfo = this.serviceManager.getService(serviceName, methodName);
            RpcRequest request = new RpcRequest();
            request.setArgs(requestPacket.getParameters());
            request.setServiceName(serviceName);
            request.setMethodName(methodName);
            request.setRpcMethodInfo(rpcMethodInfo);
            request.setTarget(rpcMethodInfo.getTarget());
            request.setTargetMethod(rpcMethodInfo.getMethod());
            request.setMsg(requestPacket);
            if (requestPacket.getAttachments() != null && requestPacket.getAttachments().size() > 0) {
                for (Map.Entry<String, Object> entry : requestPacket.getAttachments().entrySet()) {
                    if (redundantAttachments.contains(entry.getKey())) continue;
                    if (request.getKvAttachment() == null) {
                        request.setKvAttachment(new HashMap<String, Object>());
                    }
                    request.getKvAttachment().put(entry.getKey(), entry.getValue());
                }
            }
            return request;
        }
        catch (Exception e) {
            log.error(" stargate decodeRequest error at {} ", (Object)e.getMessage(), (Object)e);
            throw new BadSchemaException(SERIALIZATION_EXCEPTION, (Throwable)e);
        }
    }

    @Override
    public ByteBuf encodeResponse(Request request, Response response) throws Exception {
        try {
            StargateRpcRequestPacket stargateRpcRequestPacket = (StargateRpcRequestPacket)request.getMsg();
            StargateRpcResponsePacket responsePacket = new StargateRpcResponsePacket(stargateRpcRequestPacket.getId(), response.getResult(), response.getException());
            if (response.getKvAttachment() != null && !response.getKvAttachment().isEmpty()) {
                responsePacket.setAttachments(response.getKvAttachment());
            }
            Schema schema = RuntimeSchema.getSchema(StargateRpcResponsePacket.class);
            byte[] body = ProtobufIOUtil.toByteArray((Object)responsePacket, (Schema)schema, (LinkedBuffer)LinkedBuffer.allocate((int)500));
            byte[] head = this.buildHead(body);
            return Unpooled.wrappedBuffer((byte[][])new byte[][]{head, body});
        }
        catch (Exception e) {
            log.warn(SERIALIZATION_EXCEPTION, (Throwable)e);
            throw new BadSchemaException(SERIALIZATION_EXCEPTION, (Throwable)e);
        }
    }

    private byte[] buildHead(byte[] body) {
        int length = body.length;
        return new byte[]{(byte)(length >> 24 & 0xFF), (byte)(length >> 16 & 0xFF), (byte)(length >> 8 & 0xFF), (byte)(length & 0xFF)};
    }
}

