/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.server;

import com.baidu.brpc.server.ChannelStoreManager;
import com.baidu.brpc.server.DefaultChannelStoreManager;
import com.baidu.brpc.server.push.PushChannelContextHolder;
import io.netty.channel.Channel;
import io.netty.util.Attribute;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelManager {
    private static final Logger log = LoggerFactory.getLogger(ChannelManager.class);
    private static volatile ChannelManager instance;
    private static ChannelStoreManager storeManager;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private ChannelStoreManager innerStoreManager;

    public static void setStoreManager(ChannelStoreManager manager) {
        storeManager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ChannelManager getInstance() {
        if (instance != null) return instance;
        Class<ChannelManager> clazz = ChannelManager.class;
        synchronized (ChannelManager.class) {
            if (instance != null) return instance;
            instance = storeManager != null ? new ChannelManager(storeManager) : new ChannelManager(new DefaultChannelStoreManager());
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ChannelManager(ChannelStoreManager storeManager) {
        this.innerStoreManager = storeManager;
    }

    public void putChannel(String clientName, Channel channel) {
        this.lock.writeLock().lock();
        this.innerStoreManager.putChannel(clientName, channel);
        this.lock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel getChannel(String clientName) {
        if (log.isDebugEnabled()) {
            for (Map.Entry entry : this.innerStoreManager.getChannelMap().entrySet()) {
                log.debug("participantName={}, channelNum={}", entry.getKey(), (Object)(entry.getValue() == null ? 0 : ((List)entry.getValue()).size()));
            }
        }
        this.lock.readLock().lock();
        try {
            Channel channel = this.innerStoreManager.getChannel(clientName);
            return channel;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void removeChannel(Channel channel) {
        Attribute participant = channel.attr(PushChannelContextHolder.CLIENTNAME_KEY);
        String participantName = (String)participant.get();
        if (StringUtils.isNotBlank((CharSequence)participantName)) {
            this.lock.writeLock().lock();
            this.innerStoreManager.removeChannel(channel);
            this.lock.writeLock().unlock();
        }
    }

    public Map<String, List<Channel>> getChannelMap() {
        return this.innerStoreManager.getChannelMap();
    }
}

