/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.server;

import com.baidu.brpc.ChannelInfo;
import com.baidu.brpc.client.AsyncAwareFuture;
import com.baidu.brpc.client.RpcFuture;
import com.baidu.brpc.exceptions.RpcException;
import com.baidu.brpc.interceptor.Interceptor;
import com.baidu.brpc.interceptor.ServerInvokeInterceptor;
import com.baidu.brpc.interceptor.ServerTraceInterceptor;
import com.baidu.brpc.naming.BrpcURL;
import com.baidu.brpc.naming.NamingOptions;
import com.baidu.brpc.naming.NamingService;
import com.baidu.brpc.naming.NamingServiceFactory;
import com.baidu.brpc.naming.NamingServiceFactoryManager;
import com.baidu.brpc.naming.RegisterInfo;
import com.baidu.brpc.protocol.Protocol;
import com.baidu.brpc.protocol.ProtocolManager;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.Response;
import com.baidu.brpc.protocol.push.ServerPushProtocol;
import com.baidu.brpc.server.PushServerRpcFutureManager;
import com.baidu.brpc.server.RpcServerOptions;
import com.baidu.brpc.server.ServerPushRpcFuture;
import com.baidu.brpc.server.ServerStatus;
import com.baidu.brpc.server.ServiceManager;
import com.baidu.brpc.server.handler.RpcServerChannelIdleHandler;
import com.baidu.brpc.server.handler.RpcServerHandler;
import com.baidu.brpc.server.push.RegisterServiceImpl;
import com.baidu.brpc.spi.ExtensionLoaderManager;
import com.baidu.brpc.thread.BrpcBossGroupInstance;
import com.baidu.brpc.thread.BrpcWorkServerThreadPoolInstance;
import com.baidu.brpc.thread.BrpcWorkerGroupInstance;
import com.baidu.brpc.thread.ClientTimeoutTimerInstance;
import com.baidu.brpc.thread.ShutDownManager;
import com.baidu.brpc.utils.BrpcConstants;
import com.baidu.brpc.utils.CollectionUtils;
import com.baidu.brpc.utils.CustomThreadFactory;
import com.baidu.brpc.utils.NetUtils;
import com.baidu.brpc.utils.ThreadPool;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollMode;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcServer {
    private static final Logger LOG = LoggerFactory.getLogger(RpcServer.class);
    private RpcServerOptions rpcServerOptions = new RpcServerOptions();
    private String host;
    private int port;
    private ServerBootstrap bootstrap;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private List<Interceptor> interceptors = new ArrayList<Interceptor>();
    private Protocol protocol;
    private ThreadPool threadPool;
    private List<ThreadPool> customThreadPools = new ArrayList<ThreadPool>();
    private NamingService namingService;
    private List<Object> serviceList = new ArrayList<Object>();
    private List<RegisterInfo> registerInfoList = new ArrayList<RegisterInfo>();
    private ServerStatus serverStatus;
    private AtomicBoolean stop = new AtomicBoolean(false);
    private Timer timeoutTimer;

    public RpcServer(int port) {
        this(null, port, new RpcServerOptions(), null);
    }

    public RpcServer(String host, int port) {
        this(host, port, new RpcServerOptions(), null);
    }

    public RpcServer(int port, RpcServerOptions options) {
        this(null, port, options, null);
    }

    public RpcServer(String host, int port, RpcServerOptions options) {
        this(host, port, options, null);
    }

    public RpcServer(int port, RpcServerOptions options, List<Interceptor> interceptors) {
        this(null, port, options, interceptors);
    }

    public RpcServer(String host, int port, RpcServerOptions options, List<Interceptor> interceptors) {
        this.host = host;
        this.port = port;
        if (options != null) {
            try {
                this.rpcServerOptions.copyFrom(options);
            }
            catch (Exception ex) {
                LOG.warn("init options failed, so use default");
            }
        }
        if (interceptors != null) {
            this.interceptors.addAll(interceptors);
        }
        ExtensionLoaderManager.getInstance().loadAllExtensions(this.rpcServerOptions.getEncoding());
        if (StringUtils.isNotBlank((CharSequence)this.rpcServerOptions.getNamingServiceUrl())) {
            BrpcURL url = new BrpcURL(this.rpcServerOptions.getNamingServiceUrl());
            NamingServiceFactory namingServiceFactory = NamingServiceFactoryManager.getInstance().getNamingServiceFactory(url.getSchema());
            this.namingService = namingServiceFactory.createNamingService(url);
        }
        if (this.rpcServerOptions.getProtocolType() != null) {
            this.protocol = ProtocolManager.getInstance().getProtocol(this.rpcServerOptions.getProtocolType());
        }
        this.bootstrap = new ServerBootstrap();
        this.threadPool = this.rpcServerOptions.isGlobalThreadPoolSharing() ? BrpcWorkServerThreadPoolInstance.getOrCreateInstance(this.rpcServerOptions.getWorkThreadNum()) : new ThreadPool(this.rpcServerOptions.getWorkThreadNum(), new CustomThreadFactory("server-work-thread"));
        if (this.rpcServerOptions.getIoEventType() == BrpcConstants.IO_EVENT_NETTY_EPOLL) {
            if (this.rpcServerOptions.isGlobalThreadPoolSharing()) {
                this.bossGroup = BrpcBossGroupInstance.getOrCreateEpollInstance(this.rpcServerOptions.getAcceptorThreadNum());
                this.workerGroup = BrpcWorkerGroupInstance.getOrCreateEpollInstance(this.rpcServerOptions.getAcceptorThreadNum());
            } else {
                this.bossGroup = new EpollEventLoopGroup(this.rpcServerOptions.getAcceptorThreadNum(), (ThreadFactory)new CustomThreadFactory("server-acceptor-thread"));
                this.workerGroup = new EpollEventLoopGroup(this.rpcServerOptions.getIoThreadNum(), (ThreadFactory)new CustomThreadFactory("server-io-thread"));
            }
            ((EpollEventLoopGroup)this.bossGroup).setIoRatio(100);
            ((EpollEventLoopGroup)this.workerGroup).setIoRatio(100);
            this.bootstrap.channel(EpollServerSocketChannel.class);
            this.bootstrap.option(EpollChannelOption.EPOLL_MODE, (Object)EpollMode.EDGE_TRIGGERED);
            this.bootstrap.childOption(EpollChannelOption.EPOLL_MODE, (Object)EpollMode.EDGE_TRIGGERED);
            LOG.info("use netty epoll edge trigger mode");
        } else {
            if (this.rpcServerOptions.isGlobalThreadPoolSharing()) {
                this.bossGroup = BrpcBossGroupInstance.getOrCreateNioInstance(this.rpcServerOptions.getAcceptorThreadNum());
                this.workerGroup = BrpcWorkerGroupInstance.getOrCreateNioInstance(this.rpcServerOptions.getAcceptorThreadNum());
            } else {
                this.bossGroup = new NioEventLoopGroup(this.rpcServerOptions.getAcceptorThreadNum(), (ThreadFactory)new CustomThreadFactory("server-acceptor-thread"));
                this.workerGroup = new NioEventLoopGroup(this.rpcServerOptions.getIoThreadNum(), (ThreadFactory)new CustomThreadFactory("server-io-thread"));
            }
            ((NioEventLoopGroup)this.bossGroup).setIoRatio(100);
            ((NioEventLoopGroup)this.workerGroup).setIoRatio(100);
            this.bootstrap.channel(NioServerSocketChannel.class);
            LOG.info("use jdk nio event mode");
        }
        this.bootstrap.option(ChannelOption.SO_BACKLOG, (Object)this.rpcServerOptions.getBacklog());
        this.bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)this.rpcServerOptions.isKeepAlive());
        this.bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)this.rpcServerOptions.isTcpNoDelay());
        this.bootstrap.childOption(ChannelOption.SO_REUSEADDR, (Object)true);
        this.bootstrap.childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        this.bootstrap.childOption(ChannelOption.SO_LINGER, (Object)this.rpcServerOptions.getSoLinger());
        this.bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)this.rpcServerOptions.getSendBufferSize());
        this.bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)this.rpcServerOptions.getReceiveBufferSize());
        final RpcServerHandler rpcServerHandler = new RpcServerHandler(this);
        ChannelInitializer<SocketChannel> initializer = new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast("idleStateAwareHandler", (ChannelHandler)new IdleStateHandler(RpcServer.this.rpcServerOptions.getReaderIdleTime(), RpcServer.this.rpcServerOptions.getWriterIdleTime(), RpcServer.this.rpcServerOptions.getKeepAliveTime()));
                ch.pipeline().addLast("idle", (ChannelHandler)new RpcServerChannelIdleHandler());
                ch.pipeline().addLast(new ChannelHandler[]{rpcServerHandler});
            }
        };
        this.bootstrap.group(this.bossGroup, this.workerGroup).childHandler((ChannelHandler)initializer);
        this.serverStatus = new ServerStatus(this);
        ShutDownManager.getInstance();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                RpcServer.this.shutdown();
            }
        }));
        this.timeoutTimer = ClientTimeoutTimerInstance.getOrCreateInstance();
        if (this.protocol instanceof ServerPushProtocol) {
            this.registerService(new RegisterServiceImpl());
        }
    }

    public void registerService(Object service) {
        this.registerService(service, null, null, null);
    }

    public void registerService(Object service, NamingOptions namingOptions) {
        this.registerService(service, null, namingOptions, null);
    }

    public void registerService(Object service, Class targetClass, NamingOptions namingOptions) {
        this.registerService(service, targetClass, namingOptions, null);
    }

    public void registerService(Object service, RpcServerOptions serverOptions) {
        this.registerService(service, null, null, serverOptions);
    }

    public void registerService(Object service, Class targetClass, NamingOptions namingOptions, RpcServerOptions serverOptions) {
        this.serviceList.add(service);
        RegisterInfo registerInfo = null;
        registerInfo = namingOptions != null ? new RegisterInfo(namingOptions) : new RegisterInfo();
        if (targetClass != null) {
            registerInfo.setInterfaceName(targetClass.getInterfaces()[0].getName());
        } else {
            registerInfo.setInterfaceName(service.getClass().getInterfaces()[0].getName());
        }
        registerInfo.setHost(NetUtils.getLocalAddress().getHostAddress());
        registerInfo.setPort(this.port);
        ServiceManager serviceManager = ServiceManager.getInstance();
        ThreadPool customThreadPool = this.threadPool;
        if (serverOptions != null) {
            customThreadPool = new ThreadPool(serverOptions.getWorkThreadNum(), new CustomThreadFactory(service.getClass().getSimpleName() + "-work-thread"));
            this.customThreadPools.add(customThreadPool);
        }
        if (targetClass == null) {
            serviceManager.registerService(service, customThreadPool);
        } else {
            serviceManager.registerService(targetClass, service, customThreadPool);
        }
        this.registerInfoList.add(registerInfo);
    }

    public void start() {
        this.interceptors.add(0, new ServerTraceInterceptor());
        this.interceptors.add(new ServerInvokeInterceptor());
        try {
            if (this.rpcServerOptions.getJarvisPortName() != null && System.getenv(this.rpcServerOptions.getJarvisPortName()) != null) {
                this.port = Integer.valueOf(System.getenv(this.rpcServerOptions.getJarvisPortName()));
            }
            ChannelFuture channelFuture = null != this.host ? this.bootstrap.bind(this.host, this.port) : this.bootstrap.bind(this.port);
            channelFuture.sync();
            if (this.namingService != null) {
                for (RegisterInfo registerInfo : this.registerInfoList) {
                    this.namingService.register(registerInfo);
                }
            }
        }
        catch (InterruptedException e) {
            LOG.error("server failed to start, {}", (Object)e.getMessage());
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("server started on port={} success", (Object)this.port);
        }
    }

    public void shutdown() {
        if (this.stop.compareAndSet(false, true)) {
            if (this.namingService != null) {
                for (RegisterInfo registerInfo : this.registerInfoList) {
                    this.namingService.unregister(registerInfo);
                }
            }
            if (this.bossGroup != null && !this.rpcServerOptions.isGlobalThreadPoolSharing()) {
                this.bossGroup.shutdownGracefully().syncUninterruptibly();
            }
            if (this.workerGroup != null && !this.rpcServerOptions.isGlobalThreadPoolSharing()) {
                this.workerGroup.shutdownGracefully().syncUninterruptibly();
            }
            if (this.threadPool != null && !this.rpcServerOptions.isGlobalThreadPoolSharing()) {
                this.threadPool.stop();
            }
            if (CollectionUtils.isNotEmpty(this.customThreadPools)) {
                LOG.info("clean customized thread pool");
                for (ThreadPool pool : this.customThreadPools) {
                    pool.stop();
                }
            }
        }
    }

    public boolean isShutdown() {
        return this.stop.get();
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public <T> AsyncAwareFuture<T> sendServerPush(Request request) {
        Channel channel = request.getChannel();
        ChannelInfo orCreateServerChannelInfo = ChannelInfo.getOrCreateServerChannelInfo(channel);
        ServerPushRpcFuture rpcFuture = new ServerPushRpcFuture();
        rpcFuture.setRpcMethodInfo(request.getRpcMethodInfo());
        rpcFuture.setCallback(request.getCallback());
        rpcFuture.setChannelInfo(orCreateServerChannelInfo);
        final long correlationId = PushServerRpcFutureManager.getInstance().putRpcFuture(rpcFuture);
        request.setCorrelationId(correlationId);
        request.getSpHead().setCorrelationId(correlationId);
        long readTimeout = request.getReadTimeoutMillis().intValue();
        long writeTimeout = request.getWriteTimeoutMillis().intValue();
        Timeout timeout = this.timeoutTimer.newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                long timeoutCorrelationId = correlationId;
                PushServerRpcFutureManager rpcFutureManager = PushServerRpcFutureManager.getInstance();
                RpcFuture rpcFuture = rpcFutureManager.removeRpcFuture(timeoutCorrelationId);
                if (rpcFuture == null) {
                    LOG.error("timeout rpc is missing, correlationId={}", (Object)timeoutCorrelationId);
                    throw new RpcException(0, "timeout rpc is missing");
                }
                long elapseTime = System.currentTimeMillis() - rpcFuture.getStartTime();
                String errMsg = String.format("request timeout,correlationId=%d,ip=%s,port=%d,elapse=%dms", timeoutCorrelationId, "?", RpcServer.this.port, elapseTime);
                LOG.info(errMsg);
                Response response = RpcServer.this.protocol.createResponse();
                response.setException(new RpcException(2, errMsg));
                response.setRpcFuture(rpcFuture);
                rpcFuture.handleResponse(response);
            }
        }, readTimeout, TimeUnit.MILLISECONDS);
        rpcFuture.setTimeout(timeout);
        try {
            request.retain();
            ByteBuf byteBuf = this.protocol.encodeRequest(request);
            ChannelFuture sendFuture = channel.writeAndFlush((Object)byteBuf);
            sendFuture.awaitUninterruptibly(writeTimeout);
            if (!sendFuture.isSuccess()) {
                if (!(sendFuture.cause() instanceof ClosedChannelException)) {
                    LOG.warn("send request failed, channelActive={}, ex=", (Object)channel.isActive(), (Object)sendFuture.cause());
                }
                String errMsg = String.format("send request failed, channelActive=%b, ex=%s", channel.isActive(), sendFuture.cause().getMessage());
                throw new RpcException(1, errMsg);
            }
        }
        catch (Exception ex) {
            timeout.cancel();
            if (ex instanceof RpcException) {
                throw (RpcException)ex;
            }
            throw new RpcException(5, ex.getMessage(), ex);
        }
        return rpcFuture;
    }

    public RpcServerOptions getRpcServerOptions() {
        return this.rpcServerOptions;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public ServerBootstrap getBootstrap() {
        return this.bootstrap;
    }

    public EventLoopGroup getBossGroup() {
        return this.bossGroup;
    }

    public EventLoopGroup getWorkerGroup() {
        return this.workerGroup;
    }

    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public List<ThreadPool> getCustomThreadPools() {
        return this.customThreadPools;
    }

    public NamingService getNamingService() {
        return this.namingService;
    }

    public List<Object> getServiceList() {
        return this.serviceList;
    }

    public List<RegisterInfo> getRegisterInfoList() {
        return this.registerInfoList;
    }

    public ServerStatus getServerStatus() {
        return this.serverStatus;
    }

    public AtomicBoolean getStop() {
        return this.stop;
    }

    public Timer getTimeoutTimer() {
        return this.timeoutTimer;
    }
}

