/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.thread;

import com.baidu.brpc.thread.BrpcBossGroupInstance;
import com.baidu.brpc.thread.BrpcIoThreadPoolInstance;
import com.baidu.brpc.thread.BrpcWorkClientThreadPoolInstance;
import com.baidu.brpc.thread.BrpcWorkServerThreadPoolInstance;
import com.baidu.brpc.thread.BrpcWorkerGroupInstance;
import com.baidu.brpc.thread.ClientCallBackThreadPoolInstance;
import com.baidu.brpc.thread.ClientHealthCheckTimerInstance;
import com.baidu.brpc.thread.ClientTimeoutTimerInstance;
import com.baidu.brpc.utils.ThreadPool;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.Timer;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutDownManager {
    private static final Logger log = LoggerFactory.getLogger(ShutDownManager.class);
    private static volatile ShutDownManager clientShutDownManager;

    public static void shutdownGlobalThreadPools() {
        log.info("invoke shutdownGlobalThreadPools");
        EpollEventLoopGroup ioThread = BrpcIoThreadPoolInstance.getEpollInstance();
        NioEventLoopGroup nioInstance = BrpcIoThreadPoolInstance.getNioInstance();
        ThreadPool clientWorkThreadPool = BrpcWorkClientThreadPoolInstance.getInstance();
        ThreadPool serverWorkThreadPool = BrpcWorkServerThreadPoolInstance.getInstance();
        EpollEventLoopGroup epollBossGroup = BrpcBossGroupInstance.getEpollInstance();
        NioEventLoopGroup nioBossGroup = BrpcBossGroupInstance.getNioInstance();
        EpollEventLoopGroup epollWorkerGroup = BrpcWorkerGroupInstance.getEpollInstance();
        NioEventLoopGroup nioWorkerGroup = BrpcWorkerGroupInstance.getNioInstance();
        ExecutorService clientCallBackThread = ClientCallBackThreadPoolInstance.getInstance();
        Timer clientHealthCheckerTimer = ClientHealthCheckTimerInstance.getInstance();
        Timer clientTimeOutTimer = ClientTimeoutTimerInstance.getInstance();
        if (clientCallBackThread != null) {
            clientCallBackThread.shutdownNow();
        }
        if (ioThread != null) {
            ioThread.shutdownGracefully();
        }
        if (clientWorkThreadPool != null) {
            clientWorkThreadPool.stop();
        }
        if (nioInstance != null) {
            nioInstance.shutdownGracefully();
        }
        if (epollBossGroup != null) {
            epollBossGroup.shutdownGracefully();
        }
        if (nioBossGroup != null) {
            nioBossGroup.shutdownGracefully();
        }
        if (epollWorkerGroup != null) {
            epollWorkerGroup.shutdownGracefully();
        }
        if (nioWorkerGroup != null) {
            nioWorkerGroup.shutdownGracefully();
        }
        if (clientHealthCheckerTimer != null) {
            clientHealthCheckerTimer.stop();
        }
        if (clientTimeOutTimer != null) {
            clientTimeOutTimer.stop();
        }
        if (serverWorkThreadPool != null) {
            serverWorkThreadPool.stop();
        }
    }

    private ShutDownManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ShutDownManager getInstance() {
        if (clientShutDownManager != null) return clientShutDownManager;
        Class<ShutDownManager> clazz = ShutDownManager.class;
        synchronized (ShutDownManager.class) {
            if (clientShutDownManager != null) return clientShutDownManager;
            clientShutDownManager = new ShutDownManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return clientShutDownManager;
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                log.info("Brpc do clean work...");
                ShutDownManager.shutdownGlobalThreadPools();
            }
        }));
    }
}

