/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.creator.hikaricp;

import com.baomidou.dynamic.datasource.creator.DataSourceCreator;
import com.baomidou.dynamic.datasource.creator.DataSourceProperty;
import com.baomidou.dynamic.datasource.creator.hikaricp.HikariCpConfig;
import com.baomidou.dynamic.datasource.toolkit.ConfigMergeCreator;
import com.baomidou.dynamic.datasource.toolkit.DsStrUtils;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.sql.DataSource;

public class HikariDataSourceCreator
implements DataSourceCreator {
    private static final ConfigMergeCreator<HikariCpConfig, HikariConfig> MERGE_CREATOR = new ConfigMergeCreator<HikariCpConfig, HikariConfig>("HikariCp", HikariCpConfig.class, HikariConfig.class);
    private static Method configCopyMethod = null;
    private HikariCpConfig gConfig;

    private static void fetchMethod() {
        Class<HikariConfig> hikariConfigClass = HikariConfig.class;
        try {
            configCopyMethod = hikariConfigClass.getMethod("copyState", hikariConfigClass);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                configCopyMethod = hikariConfigClass.getMethod("copyStateTo", hikariConfigClass);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw new RuntimeException("HikariConfig does not has 'copyState' or 'copyStateTo' method!");
            }
        }
    }

    @Override
    public DataSource createDataSource(DataSourceProperty dataSourceProperty) {
        HikariConfig config = MERGE_CREATOR.create(this.gConfig, dataSourceProperty.getHikari());
        config.setUsername(dataSourceProperty.getUsername());
        config.setPassword(dataSourceProperty.getPassword());
        config.setJdbcUrl(dataSourceProperty.getUrl());
        config.setPoolName(dataSourceProperty.getPoolName());
        String driverClassName = dataSourceProperty.getDriverClassName();
        if (DsStrUtils.hasText(driverClassName)) {
            config.setDriverClassName(driverClassName);
        }
        if (Boolean.FALSE.equals(dataSourceProperty.getLazy())) {
            return new HikariDataSource(config);
        }
        config.validate();
        HikariDataSource dataSource = new HikariDataSource();
        try {
            configCopyMethod.invoke((Object)config, dataSource);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("HikariConfig failed to copy to HikariDataSource", e);
        }
        return dataSource;
    }

    @Override
    public boolean support(DataSourceProperty dataSourceProperty) {
        Class<? extends DataSource> type = dataSourceProperty.getType();
        return type == null || "com.zaxxer.hikari.HikariDataSource".equals(type.getName());
    }

    public HikariDataSourceCreator() {
    }

    public HikariDataSourceCreator(HikariCpConfig gConfig) {
        this.gConfig = gConfig;
    }

    static {
        HikariDataSourceCreator.fetchMethod();
    }
}

