/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource;

import com.alibaba.druid.filter.Filter;
import com.alibaba.druid.filter.stat.StatFilter;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallFilter;
import com.baomidou.dynamic.datasource.exception.ErrorCreateDataSourceException;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.druid.DruidConfig;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.druid.DruidWallConfigUtil;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.hikari.HikariCpConfig;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.jdbc.datasource.lookup.JndiDataSourceLookup;
import org.springframework.util.StringUtils;

public class DynamicDataSourceCreator {
    private static final Logger log = LoggerFactory.getLogger(DynamicDataSourceCreator.class);
    private static final String DRUID_DATASOURCE = "com.alibaba.druid.pool.DruidDataSource";
    private static final String HIKARI_DATASOURCE = "com.zaxxer.hikari.HikariDataSource";
    private static final JndiDataSourceLookup JNDI_DATA_SOURCE_LOOKUP = new JndiDataSourceLookup();
    private static Method createMethod;
    private static Method typeMethod;
    private static Method urlMethod;
    private static Method usernameMethod;
    private static Method passwordMethod;
    private static Method driverClassNameMethod;
    private static Method buildMethod;
    private static Boolean druidExists;
    private static Boolean hikariExists;
    private DruidConfig druidGlobalConfig;
    private HikariCpConfig hikariGlobalConfig;
    @Autowired(required=false)
    private ApplicationContext applicationContext;
    private String globalPublicKey;

    public DataSource createDataSource(DataSourceProperty dataSourceProperty) {
        String data;
        Class<? extends DataSource> type;
        String jndiName = dataSourceProperty.getJndiName();
        DataSource dataSource = jndiName != null && !jndiName.isEmpty() ? this.createJNDIDataSource(jndiName) : ((type = dataSourceProperty.getType()) == null ? (druidExists.booleanValue() ? this.createDruidDataSource(dataSourceProperty) : (hikariExists.booleanValue() ? this.createHikariDataSource(dataSourceProperty) : this.createBasicDataSource(dataSourceProperty))) : (DRUID_DATASOURCE.equals(type.getName()) ? this.createDruidDataSource(dataSourceProperty) : (HIKARI_DATASOURCE.equals(type.getName()) ? this.createHikariDataSource(dataSourceProperty) : this.createBasicDataSource(dataSourceProperty))));
        String schema = dataSourceProperty.getSchema();
        if (StringUtils.hasText((String)schema)) {
            this.runScript(dataSource, schema, dataSourceProperty);
        }
        if (StringUtils.hasText((String)(data = dataSourceProperty.getData()))) {
            this.runScript(dataSource, data, dataSourceProperty);
        }
        return dataSource;
    }

    public DataSource createBasicDataSource(DataSourceProperty dataSourceProperty) {
        try {
            if (StringUtils.isEmpty((Object)dataSourceProperty.getPublicKey())) {
                dataSourceProperty.setPublicKey(this.globalPublicKey);
            }
            Object o1 = createMethod.invoke(null, new Object[0]);
            Object o2 = typeMethod.invoke(o1, dataSourceProperty.getType());
            Object o3 = urlMethod.invoke(o2, dataSourceProperty.getUrl());
            Object o4 = usernameMethod.invoke(o3, dataSourceProperty.getUsername());
            Object o5 = passwordMethod.invoke(o4, dataSourceProperty.getPassword());
            Object o6 = driverClassNameMethod.invoke(o5, dataSourceProperty.getDriverClassName());
            return (DataSource)buildMethod.invoke(o6, new Object[0]);
        }
        catch (Exception e) {
            throw new ErrorCreateDataSourceException("dynamic-datasource create basic database named " + dataSourceProperty.getPollName() + " error");
        }
    }

    public DataSource createJNDIDataSource(String jndiName) {
        return JNDI_DATA_SOURCE_LOOKUP.getDataSource(jndiName);
    }

    public DataSource createDruidDataSource(DataSourceProperty dataSourceProperty) {
        Boolean logAbandoned;
        Boolean abandoned;
        Integer timeout;
        Boolean breakAfterAcquireFailure;
        Integer connectionErrorRetryAttempts;
        Boolean sharePreparedStatements;
        Integer validationQueryTimeout;
        Boolean testOnReturn;
        if (StringUtils.isEmpty((Object)dataSourceProperty.getPublicKey())) {
            dataSourceProperty.setPublicKey(this.globalPublicKey);
        }
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setUsername(dataSourceProperty.getUsername());
        dataSource.setPassword(dataSourceProperty.getPassword());
        dataSource.setUrl(dataSourceProperty.getUrl());
        dataSource.setDriverClassName(dataSourceProperty.getDriverClassName());
        dataSource.setName(dataSourceProperty.getPollName());
        DruidConfig config = dataSourceProperty.getDruid();
        Properties properties = config.toProperties(this.druidGlobalConfig);
        String filters = properties.getProperty("druid.filters");
        ArrayList<Object> proxyFilters = new ArrayList<Object>(2);
        if (!StringUtils.isEmpty((Object)filters) && filters.contains("stat")) {
            StatFilter statFilter = new StatFilter();
            statFilter.configFromProperties(properties);
            proxyFilters.add(statFilter);
        }
        if (!StringUtils.isEmpty((Object)filters) && filters.contains("wall")) {
            WallConfig wallConfig = DruidWallConfigUtil.toWallConfig(dataSourceProperty.getDruid().getWall(), this.druidGlobalConfig.getWall());
            WallFilter wallFilter = new WallFilter();
            wallFilter.setConfig(wallConfig);
            proxyFilters.add(wallFilter);
        }
        if (this.applicationContext != null) {
            for (String filterId : this.druidGlobalConfig.getProxyFilters()) {
                proxyFilters.add(this.applicationContext.getBean(filterId, Filter.class));
            }
        }
        dataSource.setProxyFilters(proxyFilters);
        dataSource.configFromPropety(properties);
        dataSource.setConnectProperties(config.getConnectionProperties());
        Boolean bl = testOnReturn = config.getTestOnReturn() == null ? this.druidGlobalConfig.getTestOnReturn() : config.getTestOnReturn();
        if (testOnReturn != null && testOnReturn.equals(true)) {
            dataSource.setTestOnReturn(true);
        }
        Integer n = validationQueryTimeout = config.getValidationQueryTimeout() == null ? this.druidGlobalConfig.getValidationQueryTimeout() : config.getValidationQueryTimeout();
        if (validationQueryTimeout != null && !validationQueryTimeout.equals(-1)) {
            dataSource.setValidationQueryTimeout(validationQueryTimeout.intValue());
        }
        Boolean bl2 = sharePreparedStatements = config.getSharePreparedStatements() == null ? this.druidGlobalConfig.getSharePreparedStatements() : config.getSharePreparedStatements();
        if (sharePreparedStatements != null && sharePreparedStatements.equals(true)) {
            dataSource.setSharePreparedStatements(true);
        }
        Integer n2 = connectionErrorRetryAttempts = config.getConnectionErrorRetryAttempts() == null ? this.druidGlobalConfig.getConnectionErrorRetryAttempts() : config.getConnectionErrorRetryAttempts();
        if (connectionErrorRetryAttempts != null && !connectionErrorRetryAttempts.equals(1)) {
            dataSource.setConnectionErrorRetryAttempts(connectionErrorRetryAttempts.intValue());
        }
        Boolean bl3 = breakAfterAcquireFailure = config.getBreakAfterAcquireFailure() == null ? this.druidGlobalConfig.getBreakAfterAcquireFailure() : config.getBreakAfterAcquireFailure();
        if (breakAfterAcquireFailure != null && breakAfterAcquireFailure.equals(true)) {
            dataSource.setBreakAfterAcquireFailure(true);
        }
        Integer n3 = timeout = config.getRemoveAbandonedTimeoutMillis() == null ? this.druidGlobalConfig.getRemoveAbandonedTimeoutMillis() : config.getRemoveAbandonedTimeoutMillis();
        if (timeout != null) {
            dataSource.setRemoveAbandonedTimeout(timeout.intValue());
        }
        Boolean bl4 = abandoned = config.getRemoveAbandoned() == null ? this.druidGlobalConfig.getRemoveAbandoned() : config.getRemoveAbandoned();
        if (abandoned != null) {
            dataSource.setRemoveAbandoned(abandoned.booleanValue());
        }
        Boolean bl5 = logAbandoned = config.getLogAbandoned() == null ? this.druidGlobalConfig.getLogAbandoned() : config.getLogAbandoned();
        if (logAbandoned != null) {
            dataSource.setLogAbandoned(logAbandoned.booleanValue());
        }
        try {
            dataSource.init();
        }
        catch (SQLException e) {
            throw new ErrorCreateDataSourceException("druid create error", e);
        }
        return dataSource;
    }

    public DataSource createHikariDataSource(DataSourceProperty dataSourceProperty) {
        if (StringUtils.isEmpty((Object)dataSourceProperty.getPublicKey())) {
            dataSourceProperty.setPublicKey(this.globalPublicKey);
        }
        HikariCpConfig hikariCpConfig = dataSourceProperty.getHikari();
        HikariConfig config = hikariCpConfig.toHikariConfig(this.hikariGlobalConfig);
        config.setUsername(dataSourceProperty.getUsername());
        config.setPassword(dataSourceProperty.getPassword());
        config.setJdbcUrl(dataSourceProperty.getUrl());
        config.setDriverClassName(dataSourceProperty.getDriverClassName());
        config.setPoolName(dataSourceProperty.getPollName());
        return new HikariDataSource(config);
    }

    private void runScript(DataSource dataSource, String location, DataSourceProperty dataSourceProperty) {
        if (StringUtils.hasText((String)location)) {
            ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
            populator.setContinueOnError(dataSourceProperty.isContinueOnError());
            populator.setSeparator(dataSourceProperty.getSeparator());
            ClassPathResource resource = new ClassPathResource(location);
            if (resource.exists()) {
                populator.addScript((Resource)resource);
                try {
                    DatabasePopulatorUtils.execute((DatabasePopulator)populator, (DataSource)dataSource);
                }
                catch (Exception e) {
                    log.warn("execute sql error", (Throwable)e);
                }
            } else {
                log.warn("could not find schema or data file {}", (Object)location);
            }
        }
    }

    public void setDruidGlobalConfig(DruidConfig druidGlobalConfig) {
        this.druidGlobalConfig = druidGlobalConfig;
    }

    public void setHikariGlobalConfig(HikariCpConfig hikariGlobalConfig) {
        this.hikariGlobalConfig = hikariGlobalConfig;
    }

    public void setGlobalPublicKey(String globalPublicKey) {
        this.globalPublicKey = globalPublicKey;
    }

    static {
        druidExists = false;
        hikariExists = false;
        Class<?> builderClass = null;
        try {
            builderClass = Class.forName("org.springframework.boot.jdbc.DataSourceBuilder");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (builderClass == null) {
            try {
                builderClass = Class.forName("org.springframework.boot.autoconfigure.jdbc.DataSourceBuilder");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (builderClass != null) {
            try {
                createMethod = builderClass.getDeclaredMethod("create", new Class[0]);
                typeMethod = builderClass.getDeclaredMethod("type", Class.class);
                urlMethod = builderClass.getDeclaredMethod("url", String.class);
                usernameMethod = builderClass.getDeclaredMethod("username", String.class);
                passwordMethod = builderClass.getDeclaredMethod("password", String.class);
                driverClassNameMethod = builderClass.getDeclaredMethod("driverClassName", String.class);
                buildMethod = builderClass.getDeclaredMethod("build", new Class[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            Class.forName(DRUID_DATASOURCE);
            druidExists = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Class.forName(HIKARI_DATASOURCE);
            hikariExists = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

