/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.spring.boot.autoconfigure.dbcp2;

import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.dbcp2.Dbcp2Config;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.dbcp2.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Dbcp2Utils {
    private static final Logger log = LoggerFactory.getLogger(Dbcp2Utils.class);

    public static BasicDataSource createDataSource(Dbcp2Config g, Dbcp2Config item) {
        Field[] fields;
        BasicDataSource dataSource = new BasicDataSource();
        Class<BasicDataSource> dataSourceClass = BasicDataSource.class;
        Class<Dbcp2Config> clazz = Dbcp2Config.class;
        for (Field f : fields = clazz.getDeclaredFields()) {
            try {
                String propertyName = f.getName();
                PropertyDescriptor pd = new PropertyDescriptor(propertyName, clazz);
                Method readMethod = pd.getReadMethod();
                Object value = readMethod.invoke((Object)item, new Object[0]);
                if (value == null) {
                    value = readMethod.invoke((Object)g, new Object[0]);
                }
                if (value == null) continue;
                try {
                    Method writeMethod = new PropertyDescriptor(propertyName, dataSourceClass).getWriteMethod();
                    writeMethod.invoke((Object)dataSource, value);
                }
                catch (IntrospectionException e1) {
                    log.warn("dynamic-datasource create dbcp2 get into trouble,your dbcp2 not support " + propertyName);
                }
            }
            catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
                log.warn("dynamic-datasource create dbcp2 get into trouble", (Throwable)e);
            }
        }
        return dataSource;
    }

    private Dbcp2Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

