/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.support;

import com.baomidou.dynamic.datasource.annotation.BasicAttribute;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.dynamic.datasource.tx.TransactionalInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.MethodClassKey;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.ClassUtils;

public class DataSourceClassResolver {
    private static final Logger log = LoggerFactory.getLogger(DataSourceClassResolver.class);
    private static final TransactionalInfo NULL_TRANSACTION_ATTRIBUTE = new TransactionalInfo(){

        public String toString() {
            return "null";
        }
    };
    private static boolean mpEnabled = false;
    private static Field mapperInterfaceField;
    private final Map<Object, String> dsCache = new ConcurrentHashMap<Object, String>();
    private final Map<Object, TransactionalInfo> dsTransactionalCache = new ConcurrentHashMap<Object, TransactionalInfo>();
    private final boolean allowedPublicOnly;

    public DataSourceClassResolver(boolean allowedPublicOnly) {
        this.allowedPublicOnly = allowedPublicOnly;
    }

    public String findKey(Method method, Object targetObject, Class<? extends Annotation> annotation) {
        if (method.getDeclaringClass() == Object.class) {
            return "";
        }
        MethodClassKey cacheKey = new MethodClassKey(method, targetObject.getClass());
        String ds = this.dsCache.get(cacheKey);
        if (ds == null) {
            BasicAttribute dsOperation = this.computeDatasource(method, targetObject, annotation);
            ds = dsOperation == null ? "" : (String)dsOperation.getDataOperation();
            this.dsCache.put(cacheKey, ds);
        }
        return ds;
    }

    public TransactionalInfo findTransactionalInfo(Method method, Object targetObject, Class<? extends Annotation> annotation) {
        if (method.getDeclaringClass() == Object.class) {
            return NULL_TRANSACTION_ATTRIBUTE;
        }
        MethodClassKey cacheKey = new MethodClassKey(method, targetObject.getClass());
        TransactionalInfo dsTransactional = this.dsTransactionalCache.get(cacheKey);
        if (dsTransactional == null) {
            BasicAttribute dsTransactionalOperation = this.computeDatasource(method, targetObject, annotation);
            dsTransactional = dsTransactionalOperation == null ? NULL_TRANSACTION_ATTRIBUTE : (TransactionalInfo)dsTransactionalOperation.getDataOperation();
            this.dsTransactionalCache.put(cacheKey, dsTransactional);
        }
        return dsTransactional;
    }

    private <T> BasicAttribute<T> computeDatasource(Method method, Object targetObject, Class<? extends Annotation> annotation) {
        if (this.allowedPublicOnly && !Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        BasicAttribute<T> dsAttr = this.findDataSourceAttribute(method, annotation);
        if (dsAttr != null) {
            return dsAttr;
        }
        Class<?> targetClass = targetObject.getClass();
        Class userClass = ClassUtils.getUserClass(targetClass);
        Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, (Class)userClass);
        dsAttr = this.findDataSourceAttribute(specificMethod = BridgeMethodResolver.findBridgedMethod((Method)specificMethod), annotation);
        if (dsAttr != null) {
            return dsAttr;
        }
        dsAttr = this.findDataSourceAttribute(userClass, annotation);
        if (dsAttr != null && ClassUtils.isUserLevelMethod((Method)method)) {
            return dsAttr;
        }
        for (Class interfaceClazz : ClassUtils.getAllInterfacesForClassAsSet((Class)userClass)) {
            dsAttr = this.findDataSourceAttribute(interfaceClazz, annotation);
            if (dsAttr == null) continue;
            return dsAttr;
        }
        if (specificMethod != method) {
            dsAttr = this.findDataSourceAttribute(method, annotation);
            if (dsAttr != null) {
                return dsAttr;
            }
            dsAttr = this.findDataSourceAttribute(method.getDeclaringClass(), annotation);
            if (dsAttr != null && ClassUtils.isUserLevelMethod((Method)method)) {
                return dsAttr;
            }
        }
        return this.getDefaultDataSourceAttr(targetObject, annotation);
    }

    private <T> BasicAttribute<T> getDefaultDataSourceAttr(Object targetObject, Class<? extends Annotation> annotation) {
        Class<?> clazz;
        BasicAttribute<T> datasourceAttr;
        Class<?> targetClass = targetObject.getClass();
        if (!Proxy.isProxyClass(targetClass)) {
            for (Class<?> currentClass = targetClass; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
                datasourceAttr = this.findDataSourceAttribute(currentClass, annotation);
                if (datasourceAttr == null) continue;
                return datasourceAttr;
            }
        }
        if (mpEnabled && (clazz = this.getMapperInterfaceClass(targetObject)) != null) {
            datasourceAttr = this.findDataSourceAttribute(clazz, annotation);
            if (datasourceAttr != null) {
                return datasourceAttr;
            }
            return this.findDataSourceAttribute(clazz.getSuperclass(), annotation);
        }
        return null;
    }

    private Class<?> getMapperInterfaceClass(Object target) {
        Object currentRefObject;
        Object current = target;
        while (Proxy.isProxyClass(current.getClass()) && (currentRefObject = AopProxyUtils.getSingletonTarget((Object)current)) != null) {
            current = currentRefObject;
        }
        try {
            if (Proxy.isProxyClass(current.getClass())) {
                return (Class)mapperInterfaceField.get(Proxy.getInvocationHandler(current));
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    private <T> BasicAttribute<T> findDataSourceAttribute(AnnotatedElement ae, Class<? extends Annotation> annotation) {
        DSTransactional dsTransactional;
        if (annotation.isAssignableFrom(DS.class)) {
            DS ds = (DS)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)ae, DS.class);
            if (ds != null) {
                return new BasicAttribute<String>(ds.value());
            }
        } else if (annotation.isAssignableFrom(DSTransactional.class) && (dsTransactional = (DSTransactional)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)ae, DSTransactional.class)) != null) {
            TransactionalInfo transactionalInfo = new TransactionalInfo();
            transactionalInfo.setPropagation(dsTransactional.propagation());
            transactionalInfo.setRollbackFor(dsTransactional.rollbackFor());
            transactionalInfo.setNoRollbackFor(dsTransactional.noRollbackFor());
            return new BasicAttribute<TransactionalInfo>(transactionalInfo);
        }
        return null;
    }

    static {
        Class<?> proxyClass = null;
        try {
            proxyClass = Class.forName("com.baomidou.mybatisplus.core.override.MybatisMapperProxy");
        }
        catch (ClassNotFoundException e1) {
            try {
                proxyClass = Class.forName("com.baomidou.mybatisplus.core.override.PageMapperProxy");
            }
            catch (ClassNotFoundException e2) {
                try {
                    proxyClass = Class.forName("org.apache.ibatis.binding.MapperProxy");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (proxyClass != null) {
            try {
                mapperInterfaceField = proxyClass.getDeclaredField("mapperInterface");
                mapperInterfaceField.setAccessible(true);
                mpEnabled = true;
            }
            catch (NoSuchFieldException e) {
                log.warn("Failed to init mybatis-plus support.");
            }
        }
    }
}

