/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.tx;

import com.baomidou.dynamic.datasource.annotation.DsTxEventListener;
import com.baomidou.dynamic.datasource.tx.TransactionContext;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Objects;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ApplicationListenerMethodAdapter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.support.TransactionSynchronization;

public class DsTxListenerMethodAdapter
extends ApplicationListenerMethodAdapter {
    private final DsTxEventListener dsTxEventListener;

    public DsTxListenerMethodAdapter(String beanName, Class<?> targetClass, Method method) {
        super(beanName, targetClass, method);
        DsTxEventListener annotation = (DsTxEventListener)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, DsTxEventListener.class);
        if (annotation == null) {
            throw new IllegalStateException("No DsTxEventListener annotation found on method: " + method);
        }
        this.dsTxEventListener = annotation;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (Objects.nonNull(TransactionContext.getXID())) {
            DsTxEventSynchronization dsTxSynchronization = this.createTransactionSynchronization(event);
            TransactionContext.registerSynchronization(dsTxSynchronization);
        }
    }

    private DsTxEventSynchronization createTransactionSynchronization(ApplicationEvent event) {
        return new DsTxEventSynchronization(this, event, this.dsTxEventListener.phase());
    }

    private static class DsTxEventSynchronization
    implements TransactionSynchronization {
        private final ApplicationListenerMethodAdapter listener;
        private final ApplicationEvent event;
        private final TransactionPhase phase;

        public DsTxEventSynchronization(ApplicationListenerMethodAdapter listener, ApplicationEvent event, TransactionPhase phase) {
            this.listener = listener;
            this.event = event;
            this.phase = phase;
        }

        public int getOrder() {
            return this.listener.getOrder();
        }

        public void beforeCommit(boolean readOnly) {
            if (this.phase == TransactionPhase.BEFORE_COMMIT) {
                this.processEvent();
            }
        }

        public void afterCommit() {
            if (this.phase == TransactionPhase.AFTER_COMMIT) {
                this.processEvent();
            }
        }

        public void afterCompletion(int status) {
            if (this.phase == TransactionPhase.AFTER_ROLLBACK && status == 1) {
                this.processEvent();
            } else if (this.phase == TransactionPhase.AFTER_COMPLETION) {
                this.processEvent();
            }
        }

        protected void processEvent() {
            this.listener.processEvent(this.event);
        }
    }
}

