/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.tx;

import com.baomidou.dynamic.datasource.tx.ConnectionProxy;
import java.sql.SQLException;
import java.sql.SQLTransientConnectionException;
import java.sql.Savepoint;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SavePointHolder {
    private static final Logger log = LoggerFactory.getLogger(SavePointHolder.class);
    private static final String SAVEPOINT_NAME_PREFIX = "DYNAMIC_";
    private ConnectionProxy connectionProxy;
    private LinkedList<Savepoint> savepoints;

    public SavePointHolder(ConnectionProxy connectionProxy) {
        this.connectionProxy = connectionProxy;
        this.savepoints = new LinkedList();
    }

    public void conversionSavePointHolder() throws SQLException {
        if (this.connectionProxy == null) {
            throw new SQLTransientConnectionException();
        }
        int savepointCounter = this.connectionProxy.getSavepointCounter();
        Savepoint savepoint = this.connectionProxy.setSavepoint(SAVEPOINT_NAME_PREFIX + savepointCounter);
        this.connectionProxy.setSavepointCounter(savepointCounter + 1);
        this.savepoints.addLast(savepoint);
    }

    public boolean releaseSavepoint() throws SQLException {
        Savepoint savepoint = this.savepoints.pollLast();
        if (savepoint != null) {
            this.connectionProxy.releaseSavepoint(savepoint);
            String savepointName = savepoint.getSavepointName();
            log.info("dynamic-datasource releaseSavepoint [{}]", (Object)savepointName);
            return this.savepoints.isEmpty();
        }
        return true;
    }

    public boolean rollbackSavePoint() throws SQLException {
        Savepoint savepoint = this.savepoints.pollLast();
        if (savepoint != null) {
            this.connectionProxy.rollback(savepoint);
            String savepointName = savepoint.getSavepointName();
            log.info("dynamic-datasource rollbackSavePoint [{}]", (Object)savepointName);
            return this.savepoints.isEmpty();
        }
        return true;
    }

    public ConnectionProxy getConnectionProxy() {
        return this.connectionProxy;
    }

    public List<Savepoint> getSavePoints() {
        return this.savepoints;
    }
}

