/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core;

import com.baomidou.mybatisplus.core.handlers.IJsonTypeHandler;
import com.baomidou.mybatisplus.core.toolkit.MybatisUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.mapping.ResultFlag;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.reflection.MetaClass;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;

public class MybatisMapperBuilderAssistant
extends MapperBuilderAssistant {
    public MybatisMapperBuilderAssistant(Configuration configuration, String resource) {
        super(configuration, resource);
    }

    public ResultMapping buildResultMapping(Class<?> resultType, String property, String column, Class<?> javaType, JdbcType jdbcType, String nestedSelect, String nestedResultMap, String notNullColumn, String columnPrefix, Class<? extends TypeHandler<?>> typeHandler, List<ResultFlag> flags, String resultSet, String foreignColumn, boolean lazy) {
        Class<?> javaTypeClass = this.resolveResultJavaType(resultType, property, javaType);
        TypeHandler<?> typeHandlerInstance = null;
        if (typeHandler != null) {
            if (IJsonTypeHandler.class.isAssignableFrom(typeHandler)) {
                try {
                    Field field = resultType.getDeclaredField(property);
                    typeHandlerInstance = MybatisUtils.newJsonTypeHandler(typeHandler, javaTypeClass, field);
                }
                catch (NoSuchFieldException e) {
                    typeHandlerInstance = this.resolveTypeHandler(javaTypeClass, typeHandler);
                }
            } else {
                typeHandlerInstance = this.resolveTypeHandler(javaTypeClass, typeHandler);
            }
        }
        List<Object> composites = !(nestedSelect != null && !nestedSelect.isEmpty() || foreignColumn != null && !foreignColumn.isEmpty()) ? Collections.emptyList() : this.parseCompositeColumnName(column);
        return new ResultMapping.Builder(this.configuration, property, column, javaTypeClass).jdbcType(jdbcType).nestedQueryId(this.applyCurrentNamespace(nestedSelect, true)).nestedResultMapId(this.applyCurrentNamespace(nestedResultMap, true)).resultSet(resultSet).typeHandler(typeHandlerInstance).flags((List)(flags == null ? new ArrayList() : flags)).composites(composites).notNullColumns(this.parseMultipleColumnNames(notNullColumn)).columnPrefix(columnPrefix).foreignColumn(foreignColumn).lazy(lazy).build();
    }

    private Set<String> parseMultipleColumnNames(String columnName) {
        HashSet<String> columns = new HashSet<String>();
        if (columnName != null) {
            if (columnName.indexOf(44) > -1) {
                StringTokenizer parser = new StringTokenizer(columnName, "{}, ", false);
                while (parser.hasMoreTokens()) {
                    String column = parser.nextToken();
                    columns.add(column);
                }
            } else {
                columns.add(columnName);
            }
        }
        return columns;
    }

    private List<ResultMapping> parseCompositeColumnName(String columnName) {
        ArrayList<ResultMapping> composites = new ArrayList<ResultMapping>();
        if (columnName != null && (columnName.indexOf(61) > -1 || columnName.indexOf(44) > -1)) {
            StringTokenizer parser = new StringTokenizer(columnName, "{}=, ", false);
            while (parser.hasMoreTokens()) {
                String property = parser.nextToken();
                String column = parser.nextToken();
                ResultMapping complexResultMapping = new ResultMapping.Builder(this.configuration, property, column, this.configuration.getTypeHandlerRegistry().getUnknownTypeHandler()).build();
                composites.add(complexResultMapping);
            }
        }
        return composites;
    }

    private Class<?> resolveResultJavaType(Class<?> resultType, String property, Class<?> javaType) {
        if (javaType == null && property != null) {
            try {
                MetaClass metaResultType = MetaClass.forClass(resultType, (ReflectorFactory)this.configuration.getReflectorFactory());
                javaType = metaResultType.getSetterType(property);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (javaType == null) {
            javaType = Object.class;
        }
        return javaType;
    }
}

