/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.mapper;

import com.baomidou.mybatisplus.entity.Column;
import com.baomidou.mybatisplus.entity.Columns;
import com.baomidou.mybatisplus.enums.SqlLike;
import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.mapper.SqlPlus;
import com.baomidou.mybatisplus.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.toolkit.MapUtils;
import com.baomidou.mybatisplus.toolkit.SqlUtils;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class Wrapper<T>
implements Serializable {
    private static final String PLACE_HOLDER = "{%s}";
    private static final String MYBATIS_PLUS_TOKEN = "#{%s.paramNameValuePairs.%s}";
    private static final String MP_GENERAL_PARAMNAME = "MPGENVAL";
    private static final String DEFAULT_PARAM_ALIAS = "ew";
    protected final SqlPlus sql = new SqlPlus();
    private final Map<String, Object> paramNameValuePairs = new HashMap<String, Object>();
    private final AtomicInteger paramNameSeq = new AtomicInteger(0);
    protected String paramAlias = null;
    protected String sqlSelect = null;
    protected Boolean isWhere;
    protected String AND_OR = "AND";

    public T getEntity() {
        return null;
    }

    public boolean isEmptyOfWhere() {
        return this.sql.isEmptyOfWhere();
    }

    public boolean isNotEmptyOfWhere() {
        return !this.isEmptyOfWhere();
    }

    public String getSqlSelect() {
        return StringUtils.isEmpty(this.sqlSelect) ? null : SqlUtils.stripSqlInjection(this.sqlSelect);
    }

    public Wrapper<T> setSqlSelect(String sqlSelect) {
        if (StringUtils.isNotEmpty(sqlSelect)) {
            this.sqlSelect = sqlSelect;
        }
        return this;
    }

    public Wrapper<T> setSqlSelect(String ... columns) {
        StringBuilder builder = new StringBuilder();
        for (String column : columns) {
            if (!StringUtils.isNotEmpty(column)) continue;
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append(column);
        }
        this.sqlSelect = builder.toString();
        return this;
    }

    public Wrapper<T> setSqlSelect(Column ... column) {
        if (ArrayUtils.isNotEmpty(column)) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < column.length; ++i) {
                if (column[i] == null) continue;
                String col = column[i].getColumn();
                String as = column[i].getAs();
                if (StringUtils.isEmpty(col)) continue;
                builder.append(col).append(as);
                if (i >= column.length - 1) continue;
                builder.append(",");
            }
            this.sqlSelect = builder.toString();
        }
        return this;
    }

    public Wrapper<T> setSqlSelect(Columns columns) {
        Object[] columnArray = columns.getColumns();
        if (ArrayUtils.isNotEmpty(columnArray)) {
            this.setSqlSelect((Column[])columnArray);
        }
        return this;
    }

    public abstract String getSqlSegment();

    public String toString() {
        StringBuilder sb = new StringBuilder("Wrapper<T>:");
        String sqlSegment = this.getSqlSegment();
        sb.append(this.replacePlaceholder(sqlSegment));
        T entity = this.getEntity();
        if (entity != null) {
            sb.append("\n");
            sb.append("entity=").append(entity.toString());
        }
        return sb.toString();
    }

    private String replacePlaceholder(String sqlSegment) {
        if (StringUtils.isEmpty(sqlSegment)) {
            return "";
        }
        return sqlSegment.replaceAll("#\\{" + this.getParamAlias() + ".paramNameValuePairs.MPGENVAL[0-9]+}", "\\?");
    }

    public String originalSql() {
        return this.replacePlaceholder(this.getSqlSegment());
    }

    public Wrapper<T> where(boolean condition, String sqlWhere, Object ... params) {
        if (condition) {
            this.sql.WHERE(this.formatSql(sqlWhere, params));
        }
        return this;
    }

    public Wrapper<T> where(String sqlWhere, Object ... params) {
        return this.where(true, sqlWhere, params);
    }

    public Wrapper<T> eq(boolean condition, String column, Object params) {
        if (condition) {
            this.sql.WHERE(this.formatSql(String.format("%s = {0}", column), params));
        }
        return this;
    }

    public Wrapper<T> eq(String column, Object params) {
        return this.eq(true, column, params);
    }

    public Wrapper<T> ne(boolean condition, String column, Object params) {
        if (condition) {
            this.sql.WHERE(this.formatSql(String.format("%s <> {0}", column), params));
        }
        return this;
    }

    public Wrapper<T> ne(String column, Object params) {
        return this.ne(true, column, params);
    }

    public Wrapper<T> allEq(boolean condition, Map<String, Object> params) {
        if (condition && MapUtils.isNotEmpty(params)) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                Object value = entry.getValue();
                if (!StringUtils.checkValNotNull(value)) continue;
                this.sql.WHERE(this.formatSql(String.format("%s = {0}", entry.getKey()), entry.getValue()));
            }
        }
        return this;
    }

    public Wrapper<T> allEq(Map<String, Object> params) {
        return this.allEq(true, params);
    }

    public Wrapper<T> gt(boolean condition, String column, Object params) {
        if (condition) {
            this.sql.WHERE(this.formatSql(String.format("%s > {0}", column), params));
        }
        return this;
    }

    public Wrapper<T> gt(String column, Object params) {
        return this.gt(true, column, params);
    }

    public Wrapper<T> ge(boolean condition, String column, Object params) {
        if (condition) {
            this.sql.WHERE(this.formatSql(String.format("%s >= {0}", column), params));
        }
        return this;
    }

    public Wrapper<T> ge(String column, Object params) {
        return this.ge(true, column, params);
    }

    public Wrapper<T> lt(boolean condition, String column, Object params) {
        if (condition) {
            this.sql.WHERE(this.formatSql(String.format("%s < {0}", column), params));
        }
        return this;
    }

    public Wrapper<T> lt(String column, Object params) {
        return this.lt(true, column, params);
    }

    public Wrapper<T> le(boolean condition, String column, Object params) {
        if (condition) {
            this.sql.WHERE(this.formatSql(String.format("%s <= {0}", column), params));
        }
        return this;
    }

    public Wrapper<T> le(String column, Object params) {
        return this.le(true, column, params);
    }

    public Wrapper<T> and(boolean condition, String sqlAnd, Object ... params) {
        if (condition) {
            ((SqlPlus)this.sql.AND()).WHERE(this.formatSql(sqlAnd, params));
        }
        return this;
    }

    public Wrapper<T> and(String sqlAnd, Object ... params) {
        return this.and(true, sqlAnd, params);
    }

    public Wrapper<T> andNew(boolean condition, String sqlAnd, Object ... params) {
        if (condition) {
            ((SqlPlus)this.sql.AND_NEW()).WHERE(this.formatSql(sqlAnd, params));
        }
        return this;
    }

    public Wrapper<T> andNew() {
        this.sql.AND_NEW();
        return this;
    }

    public Wrapper<T> andNew(String sqlAnd, Object ... params) {
        return this.andNew(true, sqlAnd, params);
    }

    public Wrapper<T> and() {
        this.sql.AND();
        return this;
    }

    public Wrapper<T> or() {
        this.sql.OR();
        return this;
    }

    public Wrapper<T> or(boolean condition, String sqlOr, Object ... params) {
        if (condition) {
            if (StringUtils.isEmpty(this.sql.toString())) {
                this.AND_OR = "OR";
            }
            ((SqlPlus)this.sql.OR()).WHERE(this.formatSql(sqlOr, params));
        }
        return this;
    }

    public Wrapper<T> or(String sqlOr, Object ... params) {
        return this.or(true, sqlOr, params);
    }

    public Wrapper<T> orNew() {
        this.sql.OR_NEW();
        return this;
    }

    public Wrapper<T> orNew(boolean condition, String sqlOr, Object ... params) {
        if (condition) {
            if (StringUtils.isEmpty(this.sql.toString())) {
                this.AND_OR = "OR";
            }
            ((SqlPlus)this.sql.OR_NEW()).WHERE(this.formatSql(sqlOr, params));
        }
        return this;
    }

    public Wrapper<T> orNew(String sqlOr, Object ... params) {
        return this.orNew(true, sqlOr, params);
    }

    public Wrapper<T> groupBy(boolean condition, String columns) {
        if (condition) {
            this.sql.GROUP_BY(columns);
        }
        return this;
    }

    public Wrapper<T> groupBy(String columns) {
        return this.groupBy(true, columns);
    }

    public Wrapper<T> having(boolean condition, String sqlHaving, Object ... params) {
        if (condition) {
            this.sql.HAVING(this.formatSql(sqlHaving, params));
        }
        return this;
    }

    public Wrapper<T> having(String sqlHaving, Object ... params) {
        return this.having(true, sqlHaving, params);
    }

    public Wrapper<T> orderBy(boolean condition, String columns) {
        if (condition) {
            this.sql.ORDER_BY(columns);
        }
        return this;
    }

    public Wrapper<T> orderBy(String columns) {
        return this.orderBy(true, columns);
    }

    public Wrapper<T> orderBy(boolean condition, String columns, boolean isAsc) {
        if (condition && StringUtils.isNotEmpty(columns)) {
            this.sql.ORDER_BY(columns + (isAsc ? " ASC" : " DESC"));
        }
        return this;
    }

    public Wrapper<T> orderBy(boolean condition, Collection<String> columns, boolean isAsc) {
        if (condition && CollectionUtils.isNotEmpty(columns)) {
            for (String column : columns) {
                this.orderBy(condition, column, isAsc);
            }
        }
        return this;
    }

    public Wrapper<T> orderBy(String columns, boolean isAsc) {
        return this.orderBy(true, columns, isAsc);
    }

    public Wrapper<T> orderAsc(Collection<String> columns) {
        return this.orderBy(true, columns, true);
    }

    public Wrapper<T> orderDesc(Collection<String> columns) {
        return this.orderBy(true, columns, false);
    }

    public Wrapper<T> like(boolean condition, String column, String value) {
        if (condition) {
            this.handerLike(column, value, SqlLike.DEFAULT, false);
        }
        return this;
    }

    public Wrapper<T> like(String column, String value) {
        return this.like(true, column, value);
    }

    public Wrapper<T> notLike(boolean condition, String column, String value) {
        if (condition) {
            this.handerLike(column, value, SqlLike.DEFAULT, true);
        }
        return this;
    }

    public Wrapper<T> notLike(String column, String value) {
        return this.notLike(true, column, value);
    }

    private void handerLike(String column, String value, SqlLike type, boolean isNot) {
        if (StringUtils.isNotEmpty(column) && StringUtils.isNotEmpty(value)) {
            StringBuilder inSql = new StringBuilder();
            inSql.append(column);
            if (isNot) {
                inSql.append(" NOT");
            }
            inSql.append(" LIKE {0}");
            this.sql.WHERE(this.formatSql(inSql.toString(), SqlUtils.concatLike(value, type)));
        }
    }

    public Wrapper<T> like(boolean condition, String column, String value, SqlLike type) {
        if (condition) {
            this.handerLike(column, value, type, false);
        }
        return this;
    }

    public Wrapper<T> like(String column, String value, SqlLike type) {
        return this.like(true, column, value, type);
    }

    public Wrapper<T> notLike(boolean condition, String column, String value, SqlLike type) {
        if (condition) {
            this.handerLike(column, value, type, true);
        }
        return this;
    }

    public Wrapper<T> notLike(String column, String value, SqlLike type) {
        return this.notLike(true, column, value, type);
    }

    public Wrapper<T> isNotNull(boolean condition, String columns) {
        if (condition) {
            this.sql.IS_NOT_NULL(columns);
        }
        return this;
    }

    public Wrapper<T> isNotNull(String columns) {
        return this.isNotNull(true, columns);
    }

    public Wrapper<T> isNull(boolean condition, String columns) {
        if (condition) {
            this.sql.IS_NULL(columns);
        }
        return this;
    }

    public Wrapper<T> isNull(String columns) {
        return this.isNull(true, columns);
    }

    public Wrapper<T> exists(boolean condition, String value) {
        if (condition) {
            this.sql.EXISTS(value);
        }
        return this;
    }

    public Wrapper<T> exists(String value) {
        return this.exists(true, value);
    }

    public Wrapper<T> notExists(boolean condition, String value) {
        if (condition) {
            this.sql.NOT_EXISTS(value);
        }
        return this;
    }

    public Wrapper<T> notExists(String value) {
        return this.notExists(true, value);
    }

    public Wrapper<T> in(boolean condition, String column, String value) {
        if (condition && StringUtils.isNotEmpty(value)) {
            this.in(column, StringUtils.splitWorker(value, ",", -1, false));
        }
        return this;
    }

    public Wrapper<T> in(String column, String value) {
        return this.in(true, column, value);
    }

    public Wrapper<T> notIn(boolean condition, String column, String value) {
        if (condition && StringUtils.isNotEmpty(value)) {
            this.notIn(column, StringUtils.splitWorker(value, ",", -1, false));
        }
        return this;
    }

    public Wrapper<T> notIn(String column, String value) {
        return this.notIn(true, column, value);
    }

    public Wrapper<T> in(boolean condition, String column, Collection<?> value) {
        if (condition && CollectionUtils.isNotEmpty(value)) {
            this.sql.WHERE(this.formatSql(this.inExpression(column, value, false), value.toArray()));
        }
        return this;
    }

    public Wrapper<T> in(String column, Collection<?> value) {
        return this.in(true, column, value);
    }

    public Wrapper<T> notIn(boolean condition, String column, Collection<?> value) {
        if (condition && CollectionUtils.isNotEmpty(value)) {
            this.sql.WHERE(this.formatSql(this.inExpression(column, value, true), value.toArray()));
        }
        return this;
    }

    public Wrapper<T> notIn(String column, Collection<?> value) {
        return this.notIn(true, column, value);
    }

    public Wrapper<T> in(boolean condition, String column, Object[] value) {
        if (condition && ArrayUtils.isNotEmpty(value)) {
            this.sql.WHERE(this.formatSql(this.inExpression(column, Arrays.asList(value), false), value));
        }
        return this;
    }

    public Wrapper<T> in(String column, Object[] value) {
        return this.in(true, column, value);
    }

    public Wrapper<T> notIn(boolean condition, String column, Object ... value) {
        if (condition && ArrayUtils.isNotEmpty(value)) {
            this.sql.WHERE(this.formatSql(this.inExpression(column, Arrays.asList(value), true), value));
        }
        return this;
    }

    public Wrapper<T> notIn(String column, Object ... value) {
        return this.notIn(true, column, value);
    }

    private String inExpression(String column, Collection<?> value, boolean isNot) {
        if (StringUtils.isNotEmpty(column) && CollectionUtils.isNotEmpty(value)) {
            StringBuilder inSql = new StringBuilder();
            inSql.append(column);
            if (isNot) {
                inSql.append(" NOT");
            }
            inSql.append(" IN ");
            inSql.append("(");
            int size = value.size();
            for (int i = 0; i < size; ++i) {
                inSql.append(String.format(PLACE_HOLDER, i));
                if (i + 1 >= size) continue;
                inSql.append(",");
            }
            inSql.append(")");
            return inSql.toString();
        }
        return null;
    }

    public Wrapper<T> between(boolean condition, String column, Object val1, Object val2) {
        if (condition) {
            this.sql.WHERE(this.formatSql(String.format("%s BETWEEN {0} AND {1}", column), val1, val2));
        }
        return this;
    }

    public Wrapper<T> between(String column, Object val1, Object val2) {
        return this.between(true, column, val1, val2);
    }

    public Wrapper<T> notBetween(boolean condition, String column, Object val1, Object val2) {
        if (condition) {
            this.sql.WHERE(this.formatSql(String.format("%s NOT BETWEEN {0} AND {1}", column), val1, val2));
        }
        return this;
    }

    public Wrapper<T> notBetween(String column, Object val1, Object val2) {
        return this.notBetween(true, column, val1, val2);
    }

    public Wrapper<T> addFilter(String sqlWhere, Object ... params) {
        return this.and(sqlWhere, params);
    }

    public Wrapper<T> addFilterIfNeed(boolean need, String sqlWhere, Object ... params) {
        return need ? this.where(sqlWhere, params) : this;
    }

    protected String formatSql(String sqlStr, Object ... params) {
        return this.formatSqlIfNeed(true, sqlStr, params);
    }

    protected String formatSqlIfNeed(boolean need, String sqlStr, Object ... params) {
        if (!need || StringUtils.isEmpty(sqlStr)) {
            return null;
        }
        if (ArrayUtils.isNotEmpty(params)) {
            for (int i = 0; i < params.length; ++i) {
                String genParamName = MP_GENERAL_PARAMNAME + this.paramNameSeq.incrementAndGet();
                sqlStr = sqlStr.replace(String.format(PLACE_HOLDER, i), String.format(MYBATIS_PLUS_TOKEN, this.getParamAlias(), genParamName));
                this.paramNameValuePairs.put(genParamName, params[i]);
            }
        }
        return sqlStr;
    }

    public Wrapper<T> isWhere(Boolean bool) {
        this.isWhere = bool;
        return this;
    }

    public Wrapper<T> last(String limit) {
        this.sql.LAST(limit);
        return this;
    }

    public Map<String, Object> getParamNameValuePairs() {
        return this.paramNameValuePairs;
    }

    public String getParamAlias() {
        return StringUtils.isEmpty(this.paramAlias) ? DEFAULT_PARAM_ALIAS : this.paramAlias;
    }

    public Wrapper<T> setParamAlias(String paramAlias) {
        if (StringUtils.isNotEmpty(this.getSqlSegment())) {
            throw new MybatisPlusException("Error: Please call this method when initializing!");
        }
        if (StringUtils.isNotEmpty(this.paramAlias)) {
            throw new MybatisPlusException("Error: Please do not call the method repeatedly!");
        }
        this.paramAlias = paramAlias;
        return this;
    }
}

