/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsonorg;

import com.fasterxml.jackson.datatype.jsonorg.JSONObjectDeserializer;
import java.io.IOException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.deser.StdDeserializer;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONArrayDeserializer
extends StdDeserializer<JSONArray> {
    public static final JSONArrayDeserializer instance = new JSONArrayDeserializer();

    public JSONArrayDeserializer() {
        super(JSONArray.class);
    }

    @Override
    public JSONArray deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t;
        JSONArray array = new JSONArray();
        block11: while ((t = jp.nextToken()) != JsonToken.END_ARRAY) {
            switch (t) {
                case START_ARRAY: {
                    array.put(this.deserialize(jp, ctxt));
                    continue block11;
                }
                case START_OBJECT: {
                    array.put(JSONObjectDeserializer.instance.deserialize(jp, ctxt));
                    continue block11;
                }
                case VALUE_STRING: {
                    array.put(jp.getText());
                    continue block11;
                }
                case VALUE_NULL: {
                    array.put(JSONObject.NULL);
                    continue block11;
                }
                case VALUE_TRUE: {
                    array.put(Boolean.TRUE);
                    continue block11;
                }
                case VALUE_FALSE: {
                    array.put(Boolean.FALSE);
                    continue block11;
                }
                case VALUE_NUMBER_INT: {
                    array.put(jp.getNumberValue());
                    continue block11;
                }
                case VALUE_NUMBER_FLOAT: {
                    array.put(jp.getNumberValue());
                    continue block11;
                }
                case VALUE_EMBEDDED_OBJECT: {
                    array.put(jp.getEmbeddedObject());
                    continue block11;
                }
            }
            throw ctxt.mappingException("Urecognized or unsupported JsonToken type: " + (Object)((Object)t));
        }
        return array;
    }
}

