/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.bulk;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.frameworkset.bulk.BulkAction;
import org.frameworkset.bulk.CommonBulkCommand;
import org.frameworkset.bulk.CommonBulkConfig;
import org.frameworkset.bulk.CommonBulkData;
import org.frameworkset.bulk.CommonBulkProcessorException;
import org.frameworkset.util.concurrent.ThreadPoolFactory;
import org.frameworkset.util.shutdown.ShutdownUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonBulkProcessor {
    private Logger logger = LoggerFactory.getLogger(CommonBulkProcessor.class);
    private CommonBulkCommand bulkCommand;
    private long lastAppendDataTime = -1L;
    private Lock r = new ReentrantLock();
    private Lock w = new ReentrantLock();
    private CommonBulkConfig bulkConfig;
    private Flush flush;
    private ExecutorService executor;
    private BulkAction bulkAction;
    private boolean inited;
    private int status;
    private long totalSize = 0L;
    private long failedSize = 0L;

    public CommonBulkConfig getBulkConfig() {
        return this.bulkConfig;
    }

    private CommonBulkCommand buildBulkCommand() {
        return new CommonBulkCommand(this);
    }

    public BulkAction getBulkAction() {
        return this.bulkAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop() {
        this.status = 1;
        Flush flush = this.flush;
        synchronized (flush) {
            this.flush.notify();
        }
    }

    public CommonBulkProcessor(CommonBulkConfig bulkConfig) {
        this.bulkConfig = bulkConfig;
    }

    public synchronized void increamentTotalsize(int totalSize) {
        try {
            this.r.lock();
            this.totalSize += (long)totalSize;
        }
        finally {
            this.r.unlock();
        }
    }

    public void init() {
        if (this.inited) {
            return;
        }
        this.inited = true;
        this.bulkAction = this.bulkConfig.getBulkAction();
        this.executor = ThreadPoolFactory.buildThreadPool(this.bulkConfig.getBulkProcessorName(), this.bulkConfig.getBulkRejectMessage(), this.bulkConfig.getWorkThreads(), this.bulkConfig.getWorkThreadQueue(), this.bulkConfig.getBlockedWaitTimeout(), this.bulkConfig.getWarnMultsRejects());
        this.bulkCommand = this.buildBulkCommand();
        if (this.bulkConfig.getFlushInterval() > 0L) {
            this.flush = new Flush(this.bulkConfig.getBulkProcessorName() + "-flush-thread");
            this.flush.start();
        }
        ShutdownUtil.addShutdownHook(new Runnable(){

            @Override
            public void run() {
                CommonBulkProcessor.this.shutDown();
            }
        });
    }

    private boolean touchBatchSize() {
        return this.bulkCommand != null && this.bulkCommand.getBulkDataSize() >= this.bulkConfig.getBulkSizes();
    }

    public long getLastAppendDataTime() {
        return this.lastAppendDataTime;
    }

    private void appendBulkData(CommonBulkData bulkData) {
        try {
            this.w.lock();
            if (this.bulkCommand == null) {
                return;
            }
            this._appendBulkData(bulkData);
        }
        finally {
            this.w.unlock();
        }
    }

    private void _appendBulkData(CommonBulkData bulkData) {
        this.lastAppendDataTime = System.currentTimeMillis();
        this.bulkCommand.addBulkData(bulkData);
        if (this.touchBatchSize()) {
            this.execute(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceFlush(long flushInterval) {
        try {
            this.w.lock();
            if (this.bulkCommand == null) {
                return;
            }
            long interval = System.currentTimeMillis() - this.lastAppendDataTime;
            if (interval > flushInterval && this.bulkCommand.getBulkDataSize() > 0) {
                this.execute(true);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    private void forceExecute() {
        try {
            this.w.lock();
            if (this.bulkCommand != null && this.bulkCommand.getBulkDataSize() > 0) {
                this.execute(false);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    public void insertData(Object data) {
        this.assertShutdown();
        CommonBulkData bulkData = new CommonBulkData();
        bulkData.setData(data);
        bulkData.setType(0);
        this.appendBulkData(bulkData);
    }

    public void updateData(Object data) {
        this.assertShutdown();
        CommonBulkData bulkData = new CommonBulkData();
        bulkData.setData(data);
        bulkData.setType(1);
        this.appendBulkData(bulkData);
    }

    public void deleteData(Object data) {
        this.assertShutdown();
        CommonBulkData bulkData = new CommonBulkData();
        bulkData.setData(data);
        bulkData.setType(2);
        this.appendBulkData(bulkData);
    }

    private void execute(boolean initBuilCommand) {
        this.executor.submit(this.bulkCommand);
        this.bulkCommand = initBuilCommand ? this.buildBulkCommand() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertDatas(List<?> datas) {
        if (datas == null || datas.size() == 0) {
            return;
        }
        this.assertShutdown();
        try {
            this.w.lock();
            if (this.bulkCommand == null) {
                return;
            }
            for (Object data : datas) {
                CommonBulkData bulkData = new CommonBulkData();
                bulkData.setData(data);
                bulkData.setType(0);
                this._appendBulkData(bulkData);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDatas(List<?> datas) {
        if (datas == null || datas.size() == 0) {
            return;
        }
        this.assertShutdown();
        try {
            this.w.lock();
            if (this.bulkCommand == null) {
                return;
            }
            for (Object data : datas) {
                CommonBulkData bulkData = new CommonBulkData();
                bulkData.setData(data);
                bulkData.setType(1);
                this._appendBulkData(bulkData);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    public boolean isShutdown() {
        return this.status == 1;
    }

    public void assertShutdown() {
        if (this.isShutdown()) {
            throw new CommonBulkProcessorException("Bulk processor is Shutdown.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDatas(List<?> datas) {
        if (datas == null || datas.size() == 0) {
            return;
        }
        this.assertShutdown();
        try {
            this.w.lock();
            if (this.bulkCommand == null) {
                return;
            }
            for (Object data : datas) {
                CommonBulkData bulkData = new CommonBulkData();
                bulkData.setData(data);
                bulkData.setType(2);
                this._appendBulkData(bulkData);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    public long getFailedSize() {
        return this.failedSize;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public void increamentFailedSize(int failedSize) {
        try {
            this.r.lock();
            this.failedSize += (long)failedSize;
        }
        finally {
            this.r.unlock();
        }
    }

    public int getBulkSizes() {
        return this.bulkConfig.getBulkSizes();
    }

    public void shutDown() {
        block9: {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("ShutDown BulkProcessor[{}] begin.....", (Object)this.bulkConfig.getBulkProcessorName());
            }
            this.stop();
            try {
                this.forceExecute();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.executor != null) {
                try {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("ShutDown BulkProcessor[" + this.bulkConfig.getBulkProcessorName() + "] thread executor pool  begin......");
                    }
                    this.executor.shutdown();
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("ShutDown BulkProcessor[" + this.bulkConfig.getBulkProcessorName() + "] thread executor pool complete.");
                    }
                }
                catch (Exception e) {
                    if (!this.logger.isErrorEnabled()) break block9;
                    this.logger.error("ShutDown BulkProcessor[" + this.bulkConfig.getBulkProcessorName() + "] thread executor pool failed:", (Throwable)e);
                }
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ShutDown BulkProcessor[{}] complete.", (Object)this.bulkConfig.getBulkProcessorName());
        }
    }

    class Flush
    extends Thread {
        public Flush(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long flushInterval = CommonBulkProcessor.this.bulkConfig.getFlushInterval();
            try {
                while (true) {
                    Flush flush = this;
                    synchronized (flush) {
                        this.wait(flushInterval);
                    }
                    CommonBulkProcessor.this.forceFlush(flushInterval);
                    if (!CommonBulkProcessor.this.isShutdown()) {
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
            }
        }
    }
}

