/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.support;

import com.frameworkset.util.VariableHandler;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EnvUtil {
    private static Logger log = LoggerFactory.getLogger(EnvUtil.class);

    public static Map evalEnvVariable(Map properties) {
        if (!properties.isEmpty()) {
            HashMap<String, String> allProperties = new HashMap<String, String>(properties.size());
            Iterator temp = properties.entrySet().iterator();
            StringBuilder builder = new StringBuilder();
            while (temp.hasNext()) {
                Map.Entry entry = temp.next();
                String key = (String)entry.getKey();
                try {
                    EnvUtil.getSystemEnv(builder, key, null, properties);
                    allProperties.put(key, builder.toString());
                    builder.setLength(0);
                }
                catch (Throwable e) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn("", e);
                }
            }
            return allProperties;
        }
        return null;
    }

    public static Map evalEnvVariableForObjectContainer(Map properties) {
        if (!properties.isEmpty()) {
            HashMap<String, String> allProperties = new HashMap<String, String>(properties.size());
            Iterator temp = properties.entrySet().iterator();
            StringBuilder builder = new StringBuilder();
            while (temp.hasNext()) {
                Map.Entry entry = temp.next();
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof String) {
                    try {
                        EnvUtil.getSystemEnv(builder, key, null, properties);
                        allProperties.put(key, builder.toString());
                        builder.setLength(0);
                    }
                    catch (Throwable e) {
                        if (!log.isWarnEnabled()) continue;
                        log.warn("", e);
                    }
                    continue;
                }
                allProperties.put(key, (String)value);
            }
            return allProperties;
        }
        return null;
    }

    public static void getSystemEnv(StringBuilder propertiesValue, String property, String parentName, Map properties) {
        Object value = properties.get(property);
        if (value != null) {
            String value_ = String.valueOf(value);
            VariableHandler.URLStruction urlStruction = VariableHandler.parserTempateStruction((String)value_);
            if (urlStruction == null) {
                propertiesValue.append(value_);
            } else if (!urlStruction.hasVars()) {
                propertiesValue.append(value_);
            } else {
                EnvUtil.evalStruction(propertiesValue, urlStruction, properties, property);
            }
        } else {
            String value_ = System.getProperty(property);
            if (value_ == null) {
                value_ = System.getenv(property);
            }
            if (value_ != null) {
                propertiesValue.append(value_);
            } else {
                if (parentName == null) {
                    throw new IllegalArgumentException("Eval property " + property + " value failed:not set variable value in config file or system environment.");
                }
                if (log.isWarnEnabled()) {
                    log.warn("Eval property " + property + " for " + parentName + " value failed:not set variable value in config file or system environment.");
                }
                propertiesValue.append("#[").append(property).append("]");
            }
        }
    }

    private static void evalStruction(StringBuilder builder, VariableHandler.URLStruction templateStruction, Map properties, String parentName) {
        List tokens = templateStruction.getTokens();
        List variables = templateStruction.getVariables();
        for (int i = 0; i < tokens.size(); ++i) {
            builder.append((String)tokens.get(i));
            if (i >= variables.size()) continue;
            VariableHandler.Variable variable = (VariableHandler.Variable)variables.get(i);
            if (parentName.equals(variable.getVariableName())) {
                throw new IllegalArgumentException("Eval property " + variable.getVariableName() + " for " + parentName + " value failed:loop reference ocour.");
            }
            EnvUtil.getSystemEnv(builder, variable.getVariableName(), parentName, properties);
        }
    }
}

