/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi;

import java.io.InputStream;
import java.net.URL;
import org.frameworkset.spi.BaseApplicationContext;
import org.frameworkset.spi.BeanDestroyHook;
import org.frameworkset.spi.CallContext;
import org.frameworkset.spi.DefaultApplicationContext;
import org.frameworkset.spi.LocalCallContextImpl;
import org.frameworkset.spi.SPIException;
import org.frameworkset.spi.assemble.Pro;
import org.frameworkset.spi.assemble.ServiceProviderManager;
import org.frameworkset.spi.assemble.soa.SOAServiceProviderManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOAApplicationContext
extends DefaultApplicationContext {
    private static Logger log = LoggerFactory.getLogger(SOAApplicationContext.class);
    private String charset;
    protected boolean serial;

    public SOAApplicationContext(String soacontent) {
        super(soacontent, false, true);
    }

    public SOAApplicationContext(String soacontent, boolean init) {
        super(soacontent, false, init);
    }

    public SOAApplicationContext(String soacontent, String charset) {
        super(soacontent, false, charset, true);
    }

    public SOAApplicationContext(String soacontent, String charset, boolean init) {
        super(soacontent, false, charset, init);
    }

    public SOAApplicationContext(String baseDir, URL file, String path) {
        super(baseDir, file, path);
    }

    public SOAApplicationContext(InputStream instream) {
        super(instream, false, true);
    }

    public SOAApplicationContext(InputStream instream, boolean init) {
        super(instream, false, init);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SOAApplicationContext getApplicationContext(String configfile) {
        SOAApplicationContext instance;
        if (configfile == null || configfile.equals("")) {
            log.debug("configfile is null or empty.default Config File[" + ServiceProviderManager.defaultConfigFile + "] will be used. ");
            configfile = ServiceProviderManager.defaultConfigFile;
        }
        if ((instance = (SOAApplicationContext)applicationContexts.get(configfile)) != null) {
            instance.initApplicationContext();
            return instance;
        }
        Object object = lock;
        synchronized (object) {
            instance = (SOAApplicationContext)applicationContexts.get(configfile);
            if (instance != null) {
                return instance;
            }
            instance = new SOAApplicationContext(configfile);
            BaseApplicationContext.addShutdownHook(new BeanDestroyHook(instance));
            applicationContexts.put(configfile, instance);
        }
        instance.initApplicationContext();
        return instance;
    }

    public boolean isSerial() {
        return this.serial;
    }

    public void setSerial(boolean serial) {
        this.serial = serial;
    }

    @Override
    public void init() {
        try {
            this.providerManager = this._getServiceProviderManager();
            this.providerManager.setSerial(this.serial);
            if (this.instream == null) {
                this.providerManager.init(this.docbaseType, this.docbase, this.configfile);
            } else {
                this.providerManager.init(this.docbaseType, this.docbase, this.instream);
            }
        }
        finally {
            this.docbaseType = null;
            this.docbase = null;
            this.configfile = null;
            this.instream = null;
        }
    }

    @Override
    public Object getBeanObject(CallContext context, Pro providerManagerInfo, Object defaultValue) {
        if (providerManagerInfo == null) {
            throw new SPIException("bean\u5bf9\u8c61\u4e3a\u7a7a\u3002");
        }
        if (providerManagerInfo.isRefereced()) {
            Object retvalue = providerManagerInfo.getTrueValue(context, defaultValue);
            return retvalue;
        }
        Object finalsynProvider = this.providerManager.getBeanObject(context, providerManagerInfo, defaultValue);
        return finalsynProvider;
    }

    @Override
    protected Object getBeanObject(CallContext context, String name, Object defaultValue, boolean fromprovider) {
        if (context == null) {
            context = new LocalCallContextImpl(this);
        }
        Pro providerManagerInfo = this.providerManager.getPropertyBean(name);
        return this.getBeanObject(context, providerManagerInfo, defaultValue);
    }

    @Override
    public Object proxyObject(Pro providerManagerInfo, Object refvalue, String refid) {
        return refvalue;
    }

    @Override
    protected ServiceProviderManager _getServiceProviderManager() {
        return new SOAServiceProviderManager(this);
    }

    @Override
    protected ServiceProviderManager _getServiceProviderManagerWithCharset(String charset) {
        return new SOAServiceProviderManager(this, charset);
    }
}

