/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.assemble;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.frameworkset.soa.SerialFactory;
import org.frameworkset.spi.BaseApplicationContext;
import org.frameworkset.spi.SPIException;
import org.frameworkset.spi.assemble.BaseTXManager;
import org.frameworkset.spi.assemble.Construction;
import org.frameworkset.spi.assemble.Editor;
import org.frameworkset.spi.assemble.InterceptorInfo;
import org.frameworkset.spi.assemble.LinkConfigFile;
import org.frameworkset.spi.assemble.ManagerImport;
import org.frameworkset.spi.assemble.Param;
import org.frameworkset.spi.assemble.Pro;
import org.frameworkset.spi.assemble.ProArray;
import org.frameworkset.spi.assemble.ProList;
import org.frameworkset.spi.assemble.ProMap;
import org.frameworkset.spi.assemble.ProProperties;
import org.frameworkset.spi.assemble.ProSet;
import org.frameworkset.spi.assemble.PropertiesContainer;
import org.frameworkset.spi.assemble.ProviderManagerInfo;
import org.frameworkset.spi.assemble.RollbackException;
import org.frameworkset.spi.assemble.SecurityProviderInfo;
import org.frameworkset.spi.assemble.SynchronizedMethod;
import org.frameworkset.spi.assemble.Transactions;
import org.frameworkset.spi.assemble.ValueContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class ProviderParser
extends DefaultHandler
implements ValueContainer {
    private Stack traceStack;
    private StringBuilder currentValue;
    private Map managers;
    private List mangerimports;
    private boolean serial = false;
    protected PropertiesContainer configPropertiesFile;
    protected Map<String, Pro> properties = new LinkedHashMap<String, Pro>();
    protected BaseApplicationContext applicationContext;
    protected LinkConfigFile linkfile;
    private String file;
    private static Logger log = LoggerFactory.getLogger(ProviderParser.class);

    public void setSerial(boolean serial) {
        this.serial = serial;
    }

    public BaseApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Map<String, Pro> getProperties() {
        return this.properties;
    }

    public Pro _getRealProperty(String name) {
        if (this.properties == null || this.properties.size() == 0) {
            return null;
        }
        return this.properties.get(name);
    }

    public Object getRealPropertyValue(Pro pro) {
        return pro.getValue();
    }

    public ProviderParser(BaseApplicationContext applicationContext, String file, LinkConfigFile linkfile) {
        this.traceStack = new Stack();
        this.managers = new LinkedHashMap();
        this.mangerimports = new ArrayList();
        this.currentValue = new StringBuilder();
        this.file = file;
        this.linkfile = linkfile;
        this.applicationContext = applicationContext;
        this.mergeParentConfigProperties();
    }

    protected void mergeParentConfigProperties() {
        if (this.linkfile != null && this.linkfile.getParent() != null && this.linkfile.getParent().hasConfigProperties()) {
            this.configPropertiesFile = new PropertiesContainer();
            this.configPropertiesFile.mergeParentConfigProperties(this.linkfile.getParent().getConfigPropertiesFile());
        }
    }

    public ProviderParser(BaseApplicationContext applicationContext) {
        if (applicationContext.isfile()) {
            this.managers = new LinkedHashMap();
            this.mangerimports = new ArrayList();
        }
        this.currentValue = new StringBuilder();
        this.applicationContext = applicationContext;
        if (applicationContext.getServiceProviderManager().findVariableFromSelf()) {
            this.configPropertiesFile = new PropertiesContainer();
        }
        this.traceStack = new Stack();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentValue.append(ch, start, length);
    }

    private boolean isbean(Pro p) {
        boolean isbean;
        boolean bl = isbean = p.isBean() || p.getValue() == null && p.getClazz() != null && !p.getClazz().equals("") && (p.getRefid() == null || p.getRefid().equals(""));
        if (isbean) {
            return true;
        }
        if (p.getMagicclass() != null) {
            return true;
        }
        if (p.getValue() != null) {
            boolean bl2 = isbean = p.getValue() instanceof ProList || p.getValue() instanceof ProMap || p.getValue() instanceof ProSet || p.getValue() instanceof ProArray || p.getValue() instanceof ProProperties;
        }
        if (isbean) {
            return true;
        }
        String factory_bean = p.getFactory_bean();
        if (factory_bean != null && !factory_bean.equals("")) {
            return true;
        }
        String factory_class = p.getFactory_class();
        if (factory_class != null && !factory_class.equals("")) {
            return true;
        }
        String iocplugin = p.getIocplugin();
        return iocplugin != null && !iocplugin.equals("");
    }

    private void endProperty(Pro p, String uri, String localName, String name) {
        boolean isinterceptor = p instanceof InterceptorInfo;
        if (!isinterceptor && p.getValue() == null) {
            String _value = null;
            if (this.currentValue.length() > 0) {
                if (this.serial) {
                    _value = this.currentValue.toString();
                    p.setValue(_value, this.configPropertiesFile, this);
                    this.currentValue.delete(0, this.currentValue.length());
                } else {
                    boolean trim = p.getBooleanExtendAttribute("trim", true);
                    String string = _value = trim ? this.currentValue.toString().trim() : this.currentValue.toString();
                    if (_value.length() > 0) {
                        p.setValue(_value, this.configPropertiesFile, this);
                        this.currentValue.delete(0, this.currentValue.length());
                    }
                }
            }
        }
        if (this.isbean(p)) {
            p.setBean(true);
        }
        if (this.traceStack.size() > 0) {
            Object value = this.traceStack.peek();
            if (value instanceof Pro) {
                if (!isinterceptor) {
                    Pro pro = (Pro)value;
                    pro.addReferenceParam(p);
                } else {
                    BaseTXManager providerManagerInfo = (BaseTXManager)value;
                    providerManagerInfo.addInterceptor((InterceptorInfo)p);
                }
            } else if (value instanceof List) {
                ProList list = (ProList)value;
                list.add(p);
            } else if (value instanceof ProProperties) {
                ProProperties map = (ProProperties)value;
                map.put(p.getName(), p);
            } else if (value instanceof Map) {
                ProMap map = (ProMap)value;
                map.put(p.getName(), p);
            } else if (value instanceof ProArray) {
                ProArray set = (ProArray)value;
                set.addPro(p);
            } else if (value instanceof Construction) {
                Construction construction = (Construction)value;
                construction.addParam(p);
            } else if (value instanceof Set) {
                ProSet set = (ProSet)value;
                set.add(p);
            } else if (value instanceof ProviderManagerInfo) {
                ProviderManagerInfo providerManagerInfo = (ProviderManagerInfo)value;
                if (!isinterceptor) {
                    providerManagerInfo.addReference(p);
                } else {
                    providerManagerInfo.addInterceptor((InterceptorInfo)p);
                }
            } else {
                this.properties.put(p.getName(), p);
            }
        } else {
            this.properties.put(p.getName(), p);
        }
        p.freeze();
        p = null;
    }

    @Override
    public void endElement(String uri, String localName, String name) {
        if (name.equals("p") || name.equals("property")) {
            Pro p = (Pro)this.traceStack.pop();
            this.endProperty(p, uri, localName, name);
        } else if (name.equals("l") || name.equals("list")) {
            ProList list = (ProList)this.traceStack.pop();
            Pro pro = (Pro)this.traceStack.peek();
            list.freeze();
            pro.setCollectionValue(list);
            pro.setList(true);
        } else if (name.equals("m") || name.equals("map")) {
            ProMap map = (ProMap)this.traceStack.pop();
            Pro pro = (Pro)this.traceStack.peek();
            map.freeze();
            pro.setCollectionValue(map);
            pro.setMap(true);
        } else if (name.equals("propes")) {
            ProProperties map = (ProProperties)this.traceStack.pop();
            Pro pro = (Pro)this.traceStack.peek();
            map.freeze();
            pro.setCollectionValue(map);
            pro.setIsProperties(true);
        } else if (name.equals("construction")) {
            Construction map = (Construction)this.traceStack.pop();
        } else if (name.equals("a") || name.equals("array")) {
            ProArray array = (ProArray)this.traceStack.pop();
            Pro pro = (Pro)this.traceStack.peek();
            array.freeze();
            pro.setCollectionValue(array);
            pro.setArray(true);
        } else if (name.equals("s") || name.equals("set")) {
            ProSet set = (ProSet)this.traceStack.pop();
            Pro pro = (Pro)this.traceStack.peek();
            set.freeze();
            pro.setCollectionValue(set);
            pro.setSet(true);
        } else if (name.equals("manager")) {
            ProviderManagerInfo providerManger = (ProviderManagerInfo)this.traceStack.pop();
            providerManger.unmodify();
        } else if (name.equals("provider")) {
            this.traceStack.pop();
        } else if (!name.equals("synchronize") && !name.equals("managerimport")) {
            if (name.equals("transactions")) {
                Transactions txs = (Transactions)this.traceStack.pop();
                txs.unmodify();
            } else if (!name.equals("reference")) {
                if (name.equals("method")) {
                    SynchronizedMethod synchronizedMethod = (SynchronizedMethod)this.traceStack.pop();
                    Object parent = this.traceStack.peek();
                    if (parent instanceof ProviderManagerInfo) {
                        ProviderManagerInfo providerManagerInfo = (ProviderManagerInfo)this.traceStack.peek();
                        providerManagerInfo.addSynchronizedMethod(synchronizedMethod);
                    } else if (parent instanceof InterceptorInfo) {
                        InterceptorInfo txs = (InterceptorInfo)this.traceStack.peek();
                        txs.addInterceptMethod(synchronizedMethod);
                    } else {
                        Transactions txs = (Transactions)this.traceStack.peek();
                        txs.addTransactionMethod(synchronizedMethod);
                    }
                } else if (!(name.equals("rollbackexceptions") || name.equals("exception") || name.equals("param"))) {
                    if (name.equals("description")) {
                        if (this.traceStack.size() <= 0) {
                            this.currentValue.delete(0, this.currentValue.length());
                            return;
                        }
                        Object p = this.traceStack.peek();
                        if (p instanceof Pro) {
                            Pro pro = (Pro)p;
                            pro.setDescription(this.currentValue.toString());
                        }
                    } else if (!name.equals("editor") && name.equals("interceptor")) {
                        InterceptorInfo interceptor = (InterceptorInfo)this.traceStack.pop();
                        this.endProperty(interceptor, uri, localName, name);
                    }
                }
            }
        }
        this.currentValue.delete(0, this.currentValue.length());
    }

    protected Pro _buildPro() {
        return new Pro(this.applicationContext);
    }

    protected void setFAttr(Pro property, Attributes attributes) {
        if (attributes == null || attributes.getLength() == 0) {
            return;
        }
        int length = attributes.getLength();
        HashMap<String, Object> extendsAttributes = new HashMap<String, Object>();
        HashMap<String, String> pathAttributes = new HashMap<String, String>();
        HashMap<String, String> WSAttributes = new HashMap<String, String>();
        HashMap<String, String> SOAAttributes = new HashMap<String, String>();
        HashMap<String, String> RMIAttributes = new HashMap<String, String>();
        for (int i = 0; i < length; ++i) {
            String name = attributes.getQName(i);
            if (name.equals("n") || name.equals("name")) continue;
            if (name.startsWith("s:")) {
                SOAAttributes.put(name, attributes.getValue(i));
                continue;
            }
            if (name.equals("cs") || name.equals("v") || name.equals("class") || name.equals("value")) continue;
            if (name.startsWith("f:")) {
                Pro f = this._buildPro();
                f.setName(name.substring(2));
                String value = attributes.getValue(i);
                if (value.startsWith("service:") || value.startsWith("attr:")) {
                    f.setRefid(value);
                } else {
                    f.setValue(value, this.configPropertiesFile, this);
                }
                f.setXpath(property.getXpath() + "->" + f.getName());
                property.addReferenceParam(f);
                continue;
            }
            if (name.startsWith("path:")) {
                pathAttributes.put(name, attributes.getValue(i));
                continue;
            }
            if (name.startsWith("ws:")) {
                WSAttributes.put(name, attributes.getValue(i));
                continue;
            }
            if (name.startsWith("rmi:")) {
                RMIAttributes.put(name, attributes.getValue(i));
                continue;
            }
            if (Pro.isFixAttribute(name)) continue;
            String value = attributes.getValue(i);
            if (this.configPropertiesFile != null) {
                value = Pro.evalValue(value, this.configPropertiesFile, this, property.isEscapeQuoted());
            }
            extendsAttributes.put(name, value);
        }
        if (pathAttributes.size() > 0) {
            property.setMvcpaths(pathAttributes);
        }
        if (WSAttributes.size() > 0) {
            property.setWSAttributes(WSAttributes);
        }
        if (SOAAttributes.size() > 0) {
            property.setSOAAttributes(SOAAttributes);
        }
        if (RMIAttributes.size() > 0) {
            property.setRMIAttributes(RMIAttributes);
        }
        property.setExtendsAttributes(extendsAttributes);
    }

    private Map<String, String> converAttributes(Attributes attributes) {
        if (attributes == null || attributes.getLength() == 0) {
            return new HashMap<String, String>();
        }
        int length = attributes.getLength();
        HashMap<String, String> extendsAttributes = new HashMap<String, String>();
        for (int i = 0; i < length; ++i) {
            String name = attributes.getQName(i);
            extendsAttributes.put(name, attributes.getValue(i));
        }
        return extendsAttributes;
    }

    private void buildXpath(Pro p) {
        String xpath = null;
        if (this.traceStack.size() > 0) {
            Object value = this.traceStack.peek();
            if (value instanceof Pro) {
                Pro pro = (Pro)value;
                xpath = pro.getXpath() + "->" + p.getName();
                p.setXpath(xpath);
            } else if (value instanceof List) {
                ProList list = (ProList)value;
                Pro pp = (Pro)this.traceStack.get(this.traceStack.size() - 2);
                xpath = list.size() > 0 ? pp.getXpath() + "[" + (list.size() - 1) + "]" : pp.getXpath() + "[0]";
                p.setXpath(xpath);
            } else if (value instanceof Map) {
                Pro pp = (Pro)this.traceStack.get(this.traceStack.size() - 2);
                xpath = pp.getXpath() + "[" + p.getName() + "]";
                p.setXpath(xpath);
            } else if (value instanceof ProArray) {
                ProArray set = (ProArray)value;
                Pro pp = (Pro)this.traceStack.get(this.traceStack.size() - 2);
                xpath = set.size() > 0 ? pp.getXpath() + "[" + (set.size() - 1) + "]" : pp.getXpath() + "[0]";
                p.setXpath(xpath);
            } else if (value instanceof Construction) {
                Construction construction = (Construction)value;
                Pro pp = (Pro)this.traceStack.get(this.traceStack.size() - 2);
                xpath = construction.getParams() != null && construction.getParams().size() > 0 ? pp.getXpath() + "{" + (construction.getParams().size() - 1) + "}" : pp.getXpath() + "{0}";
                p.setXpath(xpath);
            } else if (value instanceof Set) {
                ProSet set = (ProSet)value;
                Pro pp = (Pro)this.traceStack.get(this.traceStack.size() - 2);
                xpath = set.size() > 0 ? pp.getXpath() + "[" + (set.size() - 1) + "]" : pp.getXpath() + "[0]";
                p.setXpath(xpath);
            } else if (value instanceof ProviderManagerInfo) {
                xpath = p.getName();
                p.setXpath(xpath);
            } else {
                xpath = p.getName();
                p.setXpath(xpath);
            }
        } else {
            xpath = p.getName();
            p.setXpath(xpath);
        }
    }

    private void startProperty(Pro p, String uri, String localName, String name, Attributes attributes) {
        String enablerpc;
        String id;
        String name_ = null;
        String value = null;
        String clazz = null;
        String escapeQuoted = attributes.getValue("escapeQuoted");
        if (escapeQuoted != null && escapeQuoted.equals("false")) {
            p.setEscapeQuoted(false);
        }
        if (this.serial) {
            name_ = attributes.getValue("n");
            if (name_ == null && ((name_ = attributes.getValue("name")) == null || name_.equals(""))) {
                name_ = id = attributes.getValue("id");
            }
            if ((value = attributes.getValue("v")) == null) {
                value = attributes.getValue("value");
            }
            if ((clazz = attributes.getValue("cs")) == null) {
                clazz = attributes.getValue("class");
            }
        } else {
            name_ = attributes.getValue("name");
            if (name_ == null || name_.equals("")) {
                name_ = id = attributes.getValue("id");
            }
            value = attributes.getValue("value");
            clazz = attributes.getValue("class");
        }
        if (name_ != null && !name_.equals("")) {
            p.setName(name_.trim());
        }
        if (value != null) {
            p.setValue(value, this.configPropertiesFile, this);
        }
        if (clazz != null && !clazz.equals("")) {
            p.setClazz(clazz);
        }
        String refid = attributes.getValue("refid");
        String label = attributes.getValue("label");
        String factory_bean = attributes.getValue("factory-bean");
        String factory_class = attributes.getValue("factory-class");
        String factory_method = attributes.getValue("factory-method");
        String iocplugin = attributes.getValue("iocplugin");
        boolean singlable = ProviderParser.getBoolean(attributes.getValue("singlable"), true);
        if (iocplugin != null) {
            p.setIocplugin(iocplugin);
        }
        if ((enablerpc = attributes.getValue("enablerpc")) != null && enablerpc.equals("true")) {
            p.setEnablerpc(true);
        }
        p.setConfigFile(this.file);
        p.setSinglable(singlable);
        p.setFactory_bean(factory_bean);
        p.setFactory_class(factory_class);
        p.setFactory_method(factory_method);
        String destroyMethod = attributes.getValue("destroy-method");
        p.setDestroyMethod(destroyMethod);
        String initMethod = attributes.getValue("init-method");
        p.setInitMethod(initMethod);
        p.setCallorder_sequence(ProviderParser.getBoolean(attributes.getValue("callorder_sequence"), false));
        this.buildXpath(p);
        String mg = attributes.getValue("mg");
        if (mg != null) {
            p.setMagicNumber(mg);
            SerialFactory.MagicClass mgc = SerialFactory.getSerialFactory().getMagicClassByMagicNumber(mg);
            if (mgc == null) {
                throw new IllegalArgumentException("magic=" + mg + "\u5bf9\u5e94\u7684MagicClass\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5org/frameworkset/soa/serialconf.xml\u6587\u4ef6\u4e2d\u662f\u5426\u5b9a\u4e49\u4e86magic='" + mg + "'\u7684\u5e8f\u5217\u5316\u63d2\u4ef6.");
            }
            if (mgc.getMagicclass() != null && p.getClazz() == null) {
                p.setClazz(mgc.getMagicclass());
            }
            p.setMagicclass(mgc);
        }
        this.setFAttr(p, attributes);
        if (label != null && !label.equals("")) {
            p.setLabel(label);
        }
        if (refid != null && !refid.equals("")) {
            p.setRefid(refid);
        }
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) {
        if (this.currentValue.length() > 0) {
            this.currentValue.delete(0, this.currentValue.length());
        }
        if (name.equals("propes")) {
            ProProperties properties = new ProProperties();
            this.traceStack.push(properties);
        } else if (name.equals("p") || name.equals("property")) {
            Pro p = this._buildPro();
            this.startProperty(p, uri, localName, name, attributes);
            this.traceStack.push(p);
        } else if (name.equals("l") || name.equals("list")) {
            ProList list = new ProList();
            String componentType = null;
            componentType = attributes.getValue("cmt");
            if (componentType == null) {
                componentType = attributes.getValue("componentType");
            }
            list.setComponentType(componentType);
            this.traceStack.push(list);
        } else if (name.equals("m") || name.equals("map")) {
            ProMap map = new ProMap();
            String componentType = null;
            componentType = attributes.getValue("cmt");
            if (componentType == null) {
                componentType = attributes.getValue("componentType");
            }
            map.setComponentType(componentType);
            this.traceStack.push(map);
        } else if (name.equals("a") || name.equals("array")) {
            ProArray array = new ProArray();
            String componentType = null;
            componentType = attributes.getValue("cmt");
            if (componentType == null) {
                componentType = attributes.getValue("componentType");
            }
            array.setComponentType(componentType);
            this.traceStack.push(array);
        } else if (name.equals("construction")) {
            Construction construction = new Construction();
            Object parent = this.traceStack.peek();
            if (parent instanceof ProviderManagerInfo) {
                ProviderManagerInfo providerManagerInfo = (ProviderManagerInfo)parent;
                providerManagerInfo.setConstruction(construction);
            } else if (parent instanceof Pro) {
                Pro p = (Pro)parent;
                p.addConstructor(construction);
            }
            this.traceStack.push(construction);
        } else if (name.equals("s") || name.equals("set")) {
            ProSet set = new ProSet();
            String componentType = null;
            componentType = attributes.getValue("cmt");
            if (componentType == null) {
                componentType = attributes.getValue("componentType");
            }
            set.setComponentType(componentType);
            this.traceStack.push(set);
        } else if (name.equals("manager")) {
            String id = attributes.getValue("id");
            ProviderManagerInfo providerManger = new ProviderManagerInfo();
            providerManger.setId(id);
            String enablerpc = attributes.getValue("enablerpc");
            if (enablerpc != null && enablerpc.equals("true")) {
                providerManger.setEnablerpc(true);
            }
            providerManger.setJndiName(attributes.getValue("jndiname"));
            providerManger.setSinglable(ProviderParser.getBoolean(attributes.getValue("singlable"), true));
            providerManger.setDefaultable(ProviderParser.getBoolean(attributes.getValue("default"), false));
            providerManger.setCallorder_sequence(ProviderParser.getBoolean(attributes.getValue("callorder_sequence"), false));
            this.managers.put(id, providerManger);
            this.traceStack.push(providerManger);
        } else if (name.equals("managerimport")) {
            ManagerImport mi = new ManagerImport();
            mi.setFile(attributes.getValue("file"));
            this.mangerimports.add(mi);
        } else if (name.equals("provider")) {
            ProviderManagerInfo providerManager = (ProviderManagerInfo)this.traceStack.peek();
            SecurityProviderInfo provider = new SecurityProviderInfo();
            provider.setConfigFile(this.file);
            boolean isdefault = ProviderParser.getBoolean(attributes.getValue("default"), false);
            provider.setIsdefault(isdefault);
            provider.setProviderClass(attributes.getValue("class"));
            provider.setType(attributes.getValue("type"));
            provider.setUsed(ProviderParser.getBoolean(attributes.getValue("used"), false));
            String destroyMethod = attributes.getValue("destroy-method");
            provider.setDestroyMethod(destroyMethod);
            String initMethod = attributes.getValue("init-method");
            provider.setInitMethod(initMethod);
            provider.setApplicationContext(this.applicationContext);
            if (isdefault) {
                providerManager.setDefaulProviderInfo(provider);
            }
            providerManager.addSecurityProviderInfo(provider);
            this.traceStack.push(provider);
        } else if (name.equals("synchronize")) {
            ProviderManagerInfo providerManagerInfo = (ProviderManagerInfo)this.traceStack.peek();
            providerManagerInfo.setSynchronizedEnabled(ProviderParser.getBoolean(attributes.getValue("enabled"), false));
        } else if (name.equals("transactions")) {
            Object tobj = this.traceStack.peek();
            if (tobj instanceof ProviderManagerInfo) {
                ProviderManagerInfo providerManagerInfo = (ProviderManagerInfo)tobj;
                Transactions txs = new Transactions();
                providerManagerInfo.setTransactions(txs);
                this.traceStack.push(txs);
            } else {
                Pro pro = (Pro)tobj;
                Transactions txs = new Transactions();
                pro.setTransactions(txs);
                this.traceStack.push(txs);
            }
        } else if (name.equals("reference")) {
            ProviderManagerInfo providerManagerInfo = (ProviderManagerInfo)this.traceStack.peek();
            Pro ref = this._buildPro();
            String fieldname = attributes.getValue("fieldname");
            if (fieldname == null) {
                fieldname = attributes.getValue("name");
            }
            String refid = attributes.getValue("refid");
            String reftype = attributes.getValue("reftype");
            String value = attributes.getValue("value");
            String clazz = attributes.getValue("class");
            if (value == null && refid == null) {
                if (clazz != null && !clazz.equals("")) {
                    ref.setBean(true);
                } else {
                    throw new SPIException("reference\u5143\u7d20\u5fc5\u987b\u5e26class,value,refid\u4e09\u4e2a\u5c5e\u6027\u4e2d\u7684\u4efb\u4f55\u4e00\u4e2a\u3002");
                }
            }
            ref.setName(fieldname);
            ref.setRefid(refid);
            ref.setReftype(reftype);
            ref.setValue(value, this.configPropertiesFile, this);
            ref.setClazz(clazz);
            providerManagerInfo.addReference(ref);
        } else if (name.equals("interceptor")) {
            InterceptorInfo interceptor = new InterceptorInfo(this.applicationContext);
            this.startProperty(interceptor, uri, localName, name, attributes);
            this.traceStack.push(interceptor);
        } else if (name.equals("method")) {
            SynchronizedMethod synchronizedMethod = new SynchronizedMethod();
            synchronizedMethod.setMethodName(attributes.getValue("name"));
            synchronizedMethod.setPattern(attributes.getValue("pattern"));
            synchronizedMethod.setTxtype(attributes.getValue("txtype"));
            this.traceStack.push(synchronizedMethod);
        } else if (!name.equals("rollbackexceptions")) {
            if (name.equals("exception")) {
                RollbackException e = new RollbackException();
                String exceptionName = attributes.getValue("class");
                String exceptionType = attributes.getValue("type");
                e.setExceptionName(exceptionName);
                e.setExceptionType(exceptionType);
                SynchronizedMethod method = (SynchronizedMethod)this.traceStack.peek();
                method.addRollbackException(e);
            } else if (name.equals("param")) {
                String paramType = attributes.getValue("type");
                if (paramType == null) {
                    paramType = attributes.getValue("class");
                }
                String value = attributes.getValue("value");
                String refid = attributes.getValue("refid");
                Param param = new Param(this.applicationContext);
                param.setClazz(paramType);
                param.setRefid(refid);
                param.setValue(value, this.configPropertiesFile, this);
                Object o = this.traceStack.peek();
                if (o instanceof SynchronizedMethod) {
                    SynchronizedMethod method = (SynchronizedMethod)o;
                    method.addParam(param);
                } else if (o instanceof Construction) {
                    Construction construction = (Construction)o;
                    construction.addParam(param);
                }
            } else if (name.equals("description")) {
                this.currentValue.delete(0, this.currentValue.length());
            } else if (name.equals("editor")) {
                Editor editor = new Editor();
                String clazz = attributes.getValue("class");
                if (clazz == null || clazz.equals("")) {
                    this.throwable("editor \u8282\u70b9\u6ca1\u6709\u6307\u5b9aclass\u5c5e\u6027\u3002");
                }
                editor.setEditor(clazz);
                Pro currentElement = (Pro)this.traceStack.peek();
                currentElement.setEditor(editor);
            } else if (name.equals("config")) {
                String file;
                if (this.configPropertiesFile == null) {
                    this.configPropertiesFile = new PropertiesContainer();
                }
                if ((file = attributes.getValue("file")) != null) {
                    this.configPropertiesFile.addConfigPropertiesFile(file, this.linkfile);
                } else {
                    Map<String, String> extendsAttributes = this.converAttributes(attributes);
                    file = attributes.getValue("plugin");
                    if (file != null) {
                        this.configPropertiesFile.addConfigPropertiesFromPlugin(file, this.linkfile, this.applicationContext, extendsAttributes);
                    } else {
                        file = attributes.getValue("apolloNamespace");
                        this.configPropertiesFile.addConfigPropertiesFromApollo(file, this.linkfile, this.applicationContext, extendsAttributes);
                    }
                }
            }
        }
    }

    public Map getManagers() {
        return this.managers;
    }

    public List getMangerimports() {
        return this.mangerimports;
    }

    public void throwable(String message) {
        if (this.linkfile == null) {
            throw new IllegalArgumentException("editor \u8282\u70b9\u6ca1\u6709\u6307\u5b9aclass\u5c5e\u6027\u3002\u5bf9\u5e94\u7684\u914d\u7f6e\u6587\u4ef6\u4e3a\uff1a" + this.file);
        }
        throw new IllegalArgumentException("editor \u8282\u70b9\u6ca1\u6709\u6307\u5b9aclass\u5c5e\u6027\u3002\u5bf9\u5e94\u7684\u914d\u7f6e\u6587\u4ef6\u4e3a\uff1a" + this.linkfile.toString(this.file));
    }

    public static boolean getBoolean(String value, boolean nullReplace) {
        boolean ret = false;
        ret = value == null ? nullReplace : value.trim().equalsIgnoreCase("true");
        return ret;
    }

    public PropertiesContainer getConfigPropertiesFile() {
        return this.configPropertiesFile;
    }

    @Override
    public String getMacroVariableValue(List<String> links, String macroVariable) {
        String varvalue = null;
        Pro p = this._getRealProperty(macroVariable);
        if (p != null) {
            varvalue = (String)this.getRealPropertyValue(p);
        }
        return varvalue;
    }
}

