/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.schedule;

import org.frameworkset.schedule.DelegatingErrorHandlingRunnable;
import org.frameworkset.schedule.ErrorHandler;
import org.frameworkset.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TaskUtils {
    public static final ErrorHandler LOG_AND_SUPPRESS_ERROR_HANDLER = new LoggingErrorHandler();
    public static final ErrorHandler LOG_AND_PROPAGATE_ERROR_HANDLER = new PropagatingErrorHandler();

    public static DelegatingErrorHandlingRunnable decorateTaskWithErrorHandler(Runnable task, ErrorHandler errorHandler, boolean isRepeatingTask) {
        if (task instanceof DelegatingErrorHandlingRunnable) {
            return (DelegatingErrorHandlingRunnable)task;
        }
        ErrorHandler eh = errorHandler != null ? errorHandler : TaskUtils.getDefaultErrorHandler(isRepeatingTask);
        return new DelegatingErrorHandlingRunnable(task, eh);
    }

    public static ErrorHandler getDefaultErrorHandler(boolean isRepeatingTask) {
        return isRepeatingTask ? LOG_AND_SUPPRESS_ERROR_HANDLER : LOG_AND_PROPAGATE_ERROR_HANDLER;
    }

    private static class LoggingErrorHandler
    implements ErrorHandler {
        private final Logger logger = LoggerFactory.getLogger(LoggingErrorHandler.class);

        private LoggingErrorHandler() {
        }

        @Override
        public void handleError(Throwable t) {
            this.logger.error("Unexpected error occurred in scheduled task.", t);
        }
    }

    private static class PropagatingErrorHandler
    extends LoggingErrorHandler {
        private PropagatingErrorHandler() {
        }

        @Override
        public void handleError(Throwable t) {
            super.handleError(t);
            ReflectionUtils.rethrowRuntimeException((Throwable)t);
        }
    }
}

