/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.assemble;

import com.frameworkset.util.ValueCastUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import org.frameworkset.spi.assemble.AbstractGetProperties;
import org.frameworkset.spi.support.EnvUtil;

public class MapGetProperties
extends AbstractGetProperties {
    private Map<String, Object> values;

    public MapGetProperties(Map<String, Object> values) {
        this.values = EnvUtil.evalEnvVariableForObjectContainer(values);
    }

    public String getProperty(String property) {
        return this.getExternalProperty(property);
    }

    public boolean getBooleanProperty(String property, boolean defaultValue) {
        Object value = this.values.get(property);
        if (value == null) {
            return defaultValue;
        }
        return ValueCastUtil.toBoolean((Object)value, (boolean)defaultValue);
    }

    @Override
    public void reset() {
    }

    @Override
    public String getExternalProperty(String property) {
        Object value = this.values.get(property);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public Map<String, Object> getExternalProperties(String namespace, String propertyPrex, boolean truncated) {
        LinkedHashMap<String, Object> values = null;
        int len = propertyPrex.length() + 1;
        if (this.values != null) {
            for (Map.Entry<String, Object> entry : this.values.entrySet()) {
                String key = entry.getKey();
                if (!key.startsWith(propertyPrex)) continue;
                if (values == null) {
                    values = new LinkedHashMap<String, Object>();
                }
                if (truncated) {
                    key = key.substring(len);
                }
                values.put(key, entry.getValue());
            }
        }
        return values;
    }

    @Override
    public String getExternalProperty(String property, String defaultValue) {
        Object value = this.values.get(property);
        if (value != null) {
            return value.toString();
        }
        return defaultValue;
    }

    @Override
    public Object getExternalObjectProperty(String property) {
        Object value = this.values.get(property);
        if (value == null) {
            return null;
        }
        return value;
    }

    @Override
    public Object getExternalObjectProperty(String property, Object defaultValue) {
        Object value = this.values.get(property);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public Map getAllExternalProperties() {
        return this.values;
    }
}

