/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.assemble;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.frameworkset.spi.UNmodify;
import org.frameworkset.spi.assemble.BaseTXManager;
import org.frameworkset.spi.assemble.Construction;
import org.frameworkset.spi.assemble.Pro;
import org.frameworkset.spi.assemble.ProviderInfoQueue;
import org.frameworkset.spi.assemble.SecurityProviderInfo;
import org.frameworkset.spi.assemble.SynchronizedMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderManagerInfo
extends BaseTXManager
implements UNmodify {
    private static Logger log = LoggerFactory.getLogger(ProviderManagerInfo.class);
    private String id;
    private String jndiName;
    private ProviderInfoQueue providerQueue;
    private Map providerIndexByType = Collections.synchronizedMap(new HashMap());
    private Map synchronizedMethods = Collections.synchronizedMap(new HashMap());
    private Map realysynchronizedMethods = Collections.synchronizedMap(new HashMap());
    private List synchronizedMethodLists;
    private Construction construction;
    private boolean enablerpc = false;
    private boolean singlable = true;
    private boolean defaultable = false;
    private SecurityProviderInfo defaulProvider;
    private boolean synchronizedEnabled = false;
    private List<Pro> references;
    public static final Boolean TRUE = new Boolean(true);
    public static final Boolean FALSE = new Boolean(false);

    public static void main(String[] args) {
    }

    public ProviderManagerInfo() {
        this.providerQueue = new ProviderInfoQueue();
        this.synchronizedMethodLists = new ArrayList();
        this.references = new ArrayList<Pro>();
    }

    public SecurityProviderInfo getDefaulProviderInfo() {
        try {
            if (this.defaulProvider == null && this.providerQueue != null && this.providerQueue.size() > 0) {
                this.defaulProvider = this.providerQueue.getSecurityProviderInfo(0);
            }
            return this.defaulProvider;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void addSynchronizedMethod(SynchronizedMethod synchronizedMethod) {
        this.synchronizedMethodLists.add(synchronizedMethod);
        this.synchronizedMethods.put(synchronizedMethod.getUUID(), synchronizedMethod);
    }

    public SynchronizedMethod getSynchronizedMethod(String methodUUID) {
        return (SynchronizedMethod)this.synchronizedMethods.get(methodUUID);
    }

    public boolean isSynchronizedMethod(Method method) {
        String methodUUID = SynchronizedMethod.buildMethodUUID(method);
        Boolean match = (Boolean)this.realysynchronizedMethods.get(methodUUID);
        if (match == null) {
            for (int i = 0; i < this.synchronizedMethodLists.size(); ++i) {
                SynchronizedMethod m = (SynchronizedMethod)this.synchronizedMethodLists.get(i);
                if (!m.match(method, methodUUID)) continue;
                this.realysynchronizedMethods.put(methodUUID, TRUE);
                return true;
            }
            this.realysynchronizedMethods.put(methodUUID, FALSE);
            return false;
        }
        return match;
    }

    public String getId() {
        return this.id;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public ProviderInfoQueue getProviderInfoQueue() {
        return this.providerQueue;
    }

    public boolean isSynchronizedEnabled() {
        return this.synchronizedEnabled;
    }

    public boolean isSinglable() {
        return this.singlable;
    }

    public boolean isDefaultable() {
        return this.defaultable;
    }

    public void setDefaulProviderInfo(SecurityProviderInfo defaulProvider) {
        this.defaulProvider = defaulProvider;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public void setProviderInfoQueue(ProviderInfoQueue providerQueue) {
        this.providerQueue = providerQueue;
    }

    public void setSynchronizedEnabled(boolean synchronizedEnabled) {
        this.synchronizedEnabled = synchronizedEnabled;
    }

    public void setSinglable(boolean singlable) {
        this.singlable = singlable;
    }

    public void setDefaultable(boolean defaultable) {
        this.defaultable = defaultable;
    }

    public void addSecurityProviderInfo(SecurityProviderInfo provider) {
        provider.setProviderManagerInfo(this);
        this.providerIndexByType.put(provider.getType(), provider);
        this.getProviderInfoQueue().addSecurityProviderInfo(provider);
    }

    public SecurityProviderInfo getSecurityProviderInfoByType(String type) {
        return (SecurityProviderInfo)this.providerIndexByType.get(type);
    }

    public List<Pro> getReferences() {
        return this.references;
    }

    public void addReference(Pro ref) {
        this.references.add(ref);
    }

    public List getSynchronizedMethodLists() {
        return this.synchronizedMethodLists;
    }

    public void setConstruction(Construction construction) {
        this.construction = construction;
    }

    public Construction getConstruction() {
        return this.construction;
    }

    @Override
    public void unmodify() {
        super.unmodify();
        this.synchronizedMethodLists = Collections.unmodifiableList(this.synchronizedMethodLists);
        this.synchronizedMethods = Collections.unmodifiableMap(this.synchronizedMethods);
        this.references = Collections.unmodifiableList(this.references);
    }

    @Override
    public void initTransactions() {
    }

    @Override
    protected void initAsyncMethods() {
    }

    public boolean isEnablerpc() {
        return this.enablerpc;
    }

    public void setEnablerpc(boolean enablerpc) {
        this.enablerpc = enablerpc;
    }
}

