/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.cglib;

import com.frameworkset.proxy.Interceptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.NoOp;
import org.frameworkset.spi.CallContext;
import org.frameworkset.spi.assemble.BaseTXManager;
import org.frameworkset.spi.assemble.Pro;
import org.frameworkset.spi.assemble.ProviderInfoQueue;
import org.frameworkset.spi.assemble.ProviderManagerInfo;
import org.frameworkset.spi.assemble.SecurityProviderInfo;
import org.frameworkset.spi.assemble.SynchronizedMethod;
import org.frameworkset.spi.async.AsyncCall;
import org.frameworkset.spi.async.CallBack;
import org.frameworkset.spi.async.CallBackService;
import org.frameworkset.spi.async.CallBackServiceImpl;
import org.frameworkset.spi.async.CallService;
import org.frameworkset.spi.cglib.AopProxyFilter;
import org.frameworkset.spi.interceptor.AfterThrowable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CGLibUtil {
    private static Logger log = LoggerFactory.getLogger(CGLibUtil.class);
    private static AsyncCall asyncCall;
    private static Object lock;
    private static AopProxyFilter filter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        if (asyncCall != null) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            if (asyncCall == null) {
                asyncCall = new AsyncCall();
                asyncCall.start();
            }
        }
    }

    public static Object invoke(final Object delegate, final Method method, final Object[] args, final MethodProxy proxy, final CallContext callcontext, final BaseTXManager providerManagerInfo) throws Throwable {
        final SynchronizedMethod synmethod = providerManagerInfo.isAsyncMethod(method, null);
        if (synmethod == null) {
            return CGLibUtil.invoke_(delegate, method, args, proxy, callcontext, providerManagerInfo);
        }
        CGLibUtil.init();
        return asyncCall.runCallService(new CallService(){

            @Override
            public SynchronizedMethod getAsyncMethod() {
                return synmethod;
            }

            @Override
            public CallBackService getCallBackService() {
                if (callcontext != null && callcontext.getApplicationContext() != null && synmethod.getAsyncCallback() != null) {
                    CallBack callBack = (CallBack)callcontext.getApplicationContext().getBeanObject(synmethod.getAsyncCallback());
                    return new CallBackServiceImpl(callBack);
                }
                return null;
            }

            public Object call() throws Exception {
                try {
                    return CGLibUtil.invoke_(delegate, method, args, proxy, callcontext, providerManagerInfo);
                }
                catch (Exception e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new Exception(e);
                }
            }
        });
    }

    public static Object invoke(final Object delegate, final Method method, final Object[] args, final MethodProxy proxy, final Pro providerManagerInfo) throws Throwable {
        final SynchronizedMethod synmethod = providerManagerInfo.isAsyncMethod(method, null);
        if (synmethod == null) {
            return CGLibUtil.invoke_(delegate, method, args, proxy, providerManagerInfo);
        }
        CGLibUtil.init();
        return asyncCall.runCallService(new CallService(){

            @Override
            public SynchronizedMethod getAsyncMethod() {
                return synmethod;
            }

            @Override
            public CallBackService getCallBackService() {
                if (providerManagerInfo.getApplicationContext() != null && synmethod.getAsyncCallback() != null) {
                    CallBack callBack = (CallBack)providerManagerInfo.getApplicationContext().getBeanObject(synmethod.getAsyncCallback());
                    return new CallBackServiceImpl(callBack);
                }
                return null;
            }

            public Object call() throws Exception {
                try {
                    return CGLibUtil.invoke_(delegate, method, args, proxy, providerManagerInfo);
                }
                catch (Exception e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new Exception(e);
                }
            }
        });
    }

    private static Object invoke_(Object delegate, Method method, Object[] args, MethodProxy proxy, CallContext callcontext, BaseTXManager providerManagerInfo) throws Throwable {
        Interceptor txinterceptor = null;
        String muuid = null;
        if (providerManagerInfo.enableTransaction()) {
            muuid = SynchronizedMethod.buildMethodUUID(method);
            txinterceptor = providerManagerInfo.getTransactionInterceptor(method, muuid);
        }
        Interceptor interceptor = null;
        if (providerManagerInfo.enableInterceptor()) {
            if (muuid == null) {
                muuid = SynchronizedMethod.buildMethodUUID(method);
            }
            interceptor = providerManagerInfo.getChainInterceptor(method, muuid);
        }
        Object obj = null;
        if (interceptor != null) {
            interceptor.before(method, args);
        }
        try {
            obj = txinterceptor == null ? CGLibUtil.untxinvoke_(delegate, method, args, proxy, providerManagerInfo) : CGLibUtil.txinvoke_(delegate, method, args, proxy, providerManagerInfo, txinterceptor);
            if (interceptor != null) {
                try {
                    interceptor.after(method, args);
                }
                catch (Throwable e) {
                    throw new AfterThrowable(e);
                }
            }
            Object e = obj;
            return e;
        }
        catch (AfterThrowable e) {
            throw e.getCause();
        }
        catch (InvocationTargetException e) {
            if (interceptor != null) {
                interceptor.afterThrowing(method, args, e.getTargetException());
            }
            throw e.getTargetException();
        }
        catch (Throwable t) {
            if (interceptor != null) {
                interceptor.afterThrowing(method, args, t);
            }
            throw t;
        }
        finally {
            if (interceptor != null) {
                interceptor.afterFinally(method, args);
                interceptor = null;
            }
        }
    }

    private static Object txinvoke_(Object delegate, Method method, Object[] args, MethodProxy proxy, BaseTXManager providerManagerInfo, Interceptor tx) throws Throwable {
        Object obj = null;
        try {
            tx.before(method, args);
            obj = proxy == null ? method.invoke(delegate, args) : method.invoke(delegate, args);
            tx.after(method, args);
            Object object = obj;
            return object;
        }
        catch (InvocationTargetException e) {
            tx.afterThrowing(method, args, e.getTargetException());
            throw e;
        }
        catch (Throwable e) {
            tx.afterThrowing(method, args, e);
            throw e;
        }
        finally {
            tx.afterFinally(method, args);
        }
    }

    private static Object untxinvoke_(Object delegate, Method method, Object[] args, MethodProxy proxy, BaseTXManager providerManagerInfo) throws Throwable {
        Object obj = null;
        obj = proxy == null ? method.invoke(delegate, args) : method.invoke(delegate, args);
        Object object = obj;
        return object;
    }

    private static Object invoke_(Object delegate, Method method, Object[] args, MethodProxy proxy, BaseTXManager providerManagerInfo) throws Throwable {
        Interceptor txinterceptor = null;
        String muuid = null;
        if (providerManagerInfo.enableTransaction()) {
            muuid = SynchronizedMethod.buildMethodUUID(method);
            txinterceptor = providerManagerInfo.getTransactionInterceptor(method, muuid);
        }
        Interceptor interceptor = null;
        if (providerManagerInfo.enableInterceptor()) {
            if (muuid == null) {
                muuid = SynchronizedMethod.buildMethodUUID(method);
            }
            interceptor = providerManagerInfo.getChainInterceptor(method, muuid);
        }
        Object obj = null;
        if (interceptor != null) {
            interceptor.before(method, args);
        }
        try {
            obj = txinterceptor != null ? CGLibUtil.txinvoke_(delegate, method, args, proxy, providerManagerInfo, txinterceptor) : CGLibUtil.untxinvoke_(delegate, method, args, proxy, providerManagerInfo);
            if (interceptor != null) {
                try {
                    interceptor.after(method, args);
                }
                catch (Throwable e) {
                    throw new AfterThrowable(e);
                }
            }
            Object e = obj;
            return e;
        }
        catch (AfterThrowable e) {
            throw e.getCause();
        }
        catch (InvocationTargetException e) {
            if (interceptor != null) {
                interceptor.afterThrowing(method, args, e.getTargetException());
            }
            throw e.getTargetException();
        }
        catch (Throwable t) {
            if (interceptor != null) {
                interceptor.afterThrowing(method, args, t);
            }
            throw t;
        }
        finally {
            if (interceptor != null) {
                interceptor.afterFinally(method, args);
                interceptor = null;
            }
        }
    }

    public static Object invokeSynTX(final Object delegate, final Method method, final Object[] args, final MethodProxy proxy, final CallContext callcontext, final ProviderManagerInfo providerManagerInfo) throws Throwable {
        final SynchronizedMethod synmethod = providerManagerInfo.isAsyncMethod(method, null);
        if (synmethod == null) {
            return CGLibUtil.invokeSynTX_(delegate, method, args, proxy, callcontext, providerManagerInfo);
        }
        CGLibUtil.init();
        return asyncCall.runCallService(new CallService(){

            @Override
            public SynchronizedMethod getAsyncMethod() {
                return synmethod;
            }

            @Override
            public CallBackService getCallBackService() {
                if (callcontext != null && callcontext.getApplicationContext() != null) {
                    CallBack callBack = (CallBack)callcontext.getApplicationContext().getBeanObject(synmethod.getAsyncCallback());
                    return new CallBackServiceImpl(callBack);
                }
                return null;
            }

            public Object call() throws Exception {
                try {
                    return CGLibUtil.invokeSynTX_(delegate, method, args, proxy, callcontext, providerManagerInfo);
                }
                catch (Exception e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new Exception(e);
                }
            }
        });
    }

    private static Object invokeSynTX_(Object delegate, Method method, Object[] args, MethodProxy proxy, CallContext callcontext, ProviderManagerInfo providerManagerInfo) throws Throwable {
        String uuid = SynchronizedMethod.buildMethodUUID(method);
        Interceptor interceptor = providerManagerInfo.getSynTransactionInterceptor(method, uuid);
        try {
            Object obj = null;
            if (!providerManagerInfo.isSynchronizedEnabled() || !providerManagerInfo.isSynchronizedMethod(method)) {
                if (interceptor != null) {
                    interceptor.before(method, args);
                }
                obj = proxy == null ? method.invoke(delegate, args) : method.invoke(delegate, args);
                if (interceptor != null) {
                    interceptor.after(method, args);
                }
                Object object = obj;
                return object;
            }
            ProviderInfoQueue providerInfoQueue = providerManagerInfo.getProviderInfoQueue();
            SynchronizedMethod synm = providerManagerInfo.isTransactionMethod(method, uuid);
            boolean isTXMethod = synm != null;
            Throwable throwable = null;
            if (interceptor != null) {
                interceptor.before(method, args);
            }
            for (int i = 0; i < providerInfoQueue.size(); ++i) {
                boolean isdelegate;
                SecurityProviderInfo securityProviderInfo = providerInfoQueue.getSecurityProviderInfo(i);
                if (!securityProviderInfo.isUsed() && !securityProviderInfo.isIsdefault()) continue;
                Object provider = securityProviderInfo.getProvider(callcontext);
                boolean bl = isdelegate = provider.getClass() == delegate.getClass();
                if (!isdelegate && !securityProviderInfo.isUsed() && !securityProviderInfo.isIsdefault()) continue;
                if (isdelegate && !securityProviderInfo.isUsed()) {
                    log.warn("\u8c03\u7528\u7684Provider[" + delegate.getClass() + "]\uff0c[" + securityProviderInfo + "]\u88ab\u8bbe\u7f6e\u4e3a\u672a\u4f7f\u7528\u7684\u670d\u52a1\u63d0\u4f9b\u8005\u3002");
                }
                if (!isTXMethod) {
                    if (isdelegate) {
                        try {
                            method = provider.getClass().getMethod(method.getName(), method.getParameterTypes());
                            if (proxy == null) {
                                obj = method.invoke(provider, args);
                                continue;
                            }
                            obj = method.invoke(provider, args);
                        }
                        catch (InvocationTargetException e) {
                            throwable = e.getTargetException();
                            log.error("\u8c03\u7528\u670d\u52a1\u63d0\u4f9b\u8005[" + securityProviderInfo + "]\u4e2d\u65b9\u6cd5[" + method + "]\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
                        }
                        catch (Exception e) {
                            throwable = e;
                            log.error("\u8c03\u7528\u670d\u52a1\u63d0\u4f9b\u8005[" + securityProviderInfo + "]\u4e2d\u65b9\u6cd5[" + method + "]\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
                        }
                        continue;
                    }
                    try {
                        method = provider.getClass().getMethod(method.getName(), method.getParameterTypes());
                        method.invoke(provider, args);
                    }
                    catch (Exception e) {
                        log.error("\u540c\u6b65\u8c03\u7528\u670d\u52a1\u63d0\u4f9b\u8005[" + securityProviderInfo + "]\u4e2d\u65b9\u6cd5[" + method + "]\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                if (isdelegate) {
                    try {
                        method = provider.getClass().getMethod(method.getName(), method.getParameterTypes());
                        if (proxy == null) {
                            obj = method.invoke(provider, args);
                            continue;
                        }
                        obj = method.invoke(provider, args);
                    }
                    catch (InvocationTargetException e) {
                        if (synm.isRollbackException(e.getTargetException())) {
                            throw e.getTargetException();
                        }
                        throwable = e.getTargetException();
                    }
                    catch (Exception e) {
                        if (synm.isRollbackException(e)) {
                            throw e;
                        }
                        throwable = e;
                    }
                    continue;
                }
                try {
                    method = provider.getClass().getMethod(method.getName(), method.getParameterTypes());
                    method.invoke(provider, args);
                    continue;
                }
                catch (InvocationTargetException e) {
                    if (synm.isRollbackException(e.getTargetException())) {
                        throw e;
                    }
                    log.error("\u540c\u6b65\u8c03\u7528\u670d\u52a1\u63d0\u4f9b\u8005[" + securityProviderInfo + "]\u4e2d\u65b9\u6cd5[" + method + "]\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
                    continue;
                }
                catch (Exception e) {
                    if (synm.isRollbackException(e)) {
                        throw e;
                    }
                    log.error("\u540c\u6b65\u8c03\u7528\u670d\u52a1\u63d0\u4f9b\u8005[" + securityProviderInfo + "]\u4e2d\u65b9\u6cd5[" + method + "]\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
                }
            }
            if (throwable != null) {
                throw throwable;
            }
            if (interceptor != null) {
                interceptor.after(method, args);
            }
            Object object = obj;
            return object;
        }
        catch (InvocationTargetException e) {
            if (interceptor != null) {
                try {
                    interceptor.afterThrowing(method, args, e.getTargetException());
                }
                catch (Exception ei) {
                    ei.printStackTrace();
                }
            }
            throw e.getTargetException();
        }
        catch (Throwable t) {
            try {
                t.printStackTrace();
                if (interceptor != null) {
                    interceptor.afterThrowing(method, args, t);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            throw t;
        }
        finally {
            try {
                if (interceptor != null) {
                    interceptor.afterFinally(method, args);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            interceptor = null;
        }
    }

    public static Object invokeSyn(final Object delegate, final Method method, final Object[] args, final MethodProxy proxy, final CallContext callcontext, final ProviderManagerInfo providerManagerInfo) throws Throwable {
        final SynchronizedMethod synmethod = providerManagerInfo.isAsyncMethod(method, null);
        if (synmethod == null) {
            return CGLibUtil.invokeSyn_(delegate, method, args, proxy, callcontext, providerManagerInfo);
        }
        CGLibUtil.init();
        return asyncCall.runCallService(new CallService(){

            @Override
            public SynchronizedMethod getAsyncMethod() {
                return synmethod;
            }

            @Override
            public CallBackService getCallBackService() {
                if (callcontext != null && callcontext.getApplicationContext() != null) {
                    CallBack callBack = (CallBack)callcontext.getApplicationContext().getBeanObject(synmethod.getAsyncCallback());
                    return new CallBackServiceImpl(callBack);
                }
                return null;
            }

            public Object call() throws Exception {
                try {
                    return CGLibUtil.invokeSyn_(delegate, method, args, proxy, callcontext, providerManagerInfo);
                }
                catch (Exception e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new Exception(e);
                }
            }
        });
    }

    private static Object invokeSyn_(Object delegate, Method method, Object[] args, MethodProxy proxy, CallContext callcontext, ProviderManagerInfo providerManagerInfo) throws Throwable {
        Interceptor interceptor = providerManagerInfo.getSynTransactionInterceptor(method, null);
        try {
            Object obj = null;
            if (!providerManagerInfo.isSynchronizedEnabled() || !providerManagerInfo.isSynchronizedMethod(method)) {
                if (interceptor != null) {
                    interceptor.before(method, args);
                }
                obj = proxy == null ? method.invoke(delegate, args) : method.invoke(delegate, args);
                if (interceptor != null) {
                    interceptor.after(method, args);
                }
                Object object = obj;
                return object;
            }
            ProviderInfoQueue providerInfoQueue = providerManagerInfo.getProviderInfoQueue();
            Throwable throwable = null;
            if (interceptor != null) {
                interceptor.before(method, args);
            }
            for (int i = 0; i < providerInfoQueue.size(); ++i) {
                boolean isdelegate;
                SecurityProviderInfo securityProviderInfo = providerInfoQueue.getSecurityProviderInfo(i);
                if (!securityProviderInfo.isUsed() && !securityProviderInfo.isIsdefault()) continue;
                Object provider = securityProviderInfo.getProvider(callcontext);
                boolean bl = isdelegate = provider.getClass() == delegate.getClass();
                if (!isdelegate && !securityProviderInfo.isUsed() && !securityProviderInfo.isIsdefault()) continue;
                if (isdelegate && !securityProviderInfo.isUsed()) {
                    log.warn("\u8c03\u7528\u7684Provider[" + delegate.getClass() + "]\uff0c[" + securityProviderInfo + "]\u88ab\u8bbe\u7f6e\u4e3a\u672a\u4f7f\u7528\u7684\u670d\u52a1\u63d0\u4f9b\u8005\u3002");
                }
                if (isdelegate) {
                    try {
                        method = provider.getClass().getMethod(method.getName(), method.getParameterTypes());
                        if (proxy == null) {
                            obj = method.invoke(provider, args);
                            continue;
                        }
                        obj = method.invoke(provider, args);
                    }
                    catch (InvocationTargetException e) {
                        throwable = e.getTargetException();
                        log.error("\u8c03\u7528\u670d\u52a1\u63d0\u4f9b\u8005[" + securityProviderInfo + "]\u4e2d\u65b9\u6cd5[" + method + "]\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
                    }
                    catch (Exception e) {
                        throwable = e;
                        log.error("\u8c03\u7528\u670d\u52a1\u63d0\u4f9b\u8005[" + securityProviderInfo + "]\u4e2d\u65b9\u6cd5[" + method + "]\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                try {
                    method = provider.getClass().getMethod(method.getName(), method.getParameterTypes());
                    method.invoke(provider, args);
                    continue;
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65\u8c03\u7528\u670d\u52a1\u63d0\u4f9b\u8005[" + securityProviderInfo + "]\u4e2d\u65b9\u6cd5[" + method + "]\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
                }
            }
            if (throwable != null) {
                throw throwable;
            }
            if (interceptor != null) {
                interceptor.after(method, args);
            }
            Object object = obj;
            return object;
        }
        catch (InvocationTargetException e) {
            if (interceptor != null) {
                try {
                    interceptor.afterThrowing(method, args, e.getTargetException());
                }
                catch (Exception ei) {
                    ei.printStackTrace();
                }
            }
            throw e.getTargetException();
        }
        catch (Throwable t) {
            try {
                t.printStackTrace();
                if (interceptor != null) {
                    interceptor.afterThrowing(method, args, t);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            throw t;
        }
        finally {
            try {
                if (interceptor != null) {
                    interceptor.afterFinally(method, args);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            interceptor = null;
        }
    }

    public static <T> T getBeanInstance(Class<T> rettype, Class beanType, MethodInterceptor proxy) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(beanType);
        enhancer.setCallbacks(new Callback[]{proxy, NoOp.INSTANCE});
        enhancer.setCallbackFilter((CallbackFilter)filter);
        return (T)enhancer.create();
    }

    public static <T> T getBeanInstance(Class<T> rettype, MethodInterceptor proxy) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(rettype);
        enhancer.setCallbacks(new Callback[]{proxy, NoOp.INSTANCE});
        enhancer.setCallbackFilter((CallbackFilter)filter);
        return (T)enhancer.create();
    }

    public static <T> T getBeanInstance(String rettype, MethodInterceptor proxy) {
        Enhancer enhancer = new Enhancer();
        try {
            enhancer.setSuperclass(Class.forName(rettype));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        enhancer.setCallbacks(new Callback[]{proxy, NoOp.INSTANCE});
        enhancer.setCallbackFilter((CallbackFilter)filter);
        return (T)enhancer.create();
    }

    static {
        lock = new Object();
        filter = new AopProxyFilter();
    }
}

