/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.remote.http;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.util.Args;
import org.apache.http.util.LangUtils;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public final class HttpHost
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -7529410654042457626L;
    private String origineAddress;
    protected String hostAddress;
    protected Map<String, Object> attributes;
    protected String routing;

    public String getHostAddress() {
        return this.hostAddress;
    }

    private void initAddress() {
        this.origineAddress = this.hostAddress;
        String[] infos = this.hostAddress.split("\\|");
        if (infos.length == 2) {
            this.hostAddress = infos[0];
            this.routing = infos[1];
        } else {
            this.hostAddress = infos[0];
        }
    }

    public HttpHost(String hostname) {
        this.hostAddress = !hostname.startsWith("http://") && !hostname.startsWith("https://") ? "http://" + hostname : hostname;
        this.initAddress();
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public String getOrigineAddress() {
        return this.origineAddress;
    }

    public HttpHost(HttpHost httphost) {
        Args.notNull((Object)httphost, (String)"HTTP host");
        this.hostAddress = httphost.hostAddress;
        this.attributes = httphost.attributes;
        this.routing = httphost.routing;
        this.origineAddress = httphost.origineAddress;
    }

    public String toString() {
        return this.origineAddress;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HttpHost) {
            HttpHost that = (HttpHost)obj;
            return this.hostAddress.equals(that.hostAddress);
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = LangUtils.hashCode((int)hash, (Object)this.hostAddress);
        return hash;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void addAttribute(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        if (this.attributes != null) {
            return this.attributes.get(key);
        }
        return null;
    }

    public String getRouting() {
        return this.routing;
    }
}

