/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.remote.http;

import java.io.IOException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.protocol.HttpContext;
import org.frameworkset.spi.remote.http.ClientConfiguration;
import org.frameworkset.spi.remote.http.CustomHttpRequestRetryHandler;
import org.frameworkset.spi.remote.http.DefaultHttpRequestRetryHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestRetryHandlerHelper
implements HttpRequestRetryHandler {
    private static Logger logger = LoggerFactory.getLogger(DefaultHttpRequestRetryHandler.class);
    private CustomHttpRequestRetryHandler httpRequestRetryHandler;
    private ClientConfiguration configuration;

    public HttpRequestRetryHandlerHelper(CustomHttpRequestRetryHandler httpRequestRetryHandler, ClientConfiguration configuration) {
        this.httpRequestRetryHandler = httpRequestRetryHandler;
        this.configuration = configuration;
    }

    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        if (executionCount > this.configuration.getRetryTime()) {
            logger.warn("Maximum tries[" + this.configuration.getRetryTime() + "] reached for client http pool ");
            return false;
        }
        if (this.httpRequestRetryHandler.retryRequest(exception, executionCount, context, this.configuration)) {
            if (this.configuration.getRetryInterval() > 0L) {
                try {
                    Thread.sleep(this.configuration.getRetryInterval());
                }
                catch (InterruptedException e1) {
                    return false;
                }
            }
            logger.warn(exception.getClass().getName() + " on " + executionCount + " call");
            return true;
        }
        return false;
    }
}

