/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.remote.http.proxy.route;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.frameworkset.spi.remote.http.proxy.HttpAddress;
import org.frameworkset.spi.remote.http.proxy.HttpServiceHosts;
import org.frameworkset.spi.remote.http.proxy.route.RoutingGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingFilter {
    private static Logger logger = LoggerFactory.getLogger(RoutingFilter.class);
    private Map<String, RoutingGroup> routingGroupMap = new HashMap<String, RoutingGroup>();
    private final RoutingGroup currentRoutingGroup;
    private String currentRouting;
    private List<HttpAddress> addressList;
    private HttpServiceHosts httpServiceHosts;

    public RoutingFilter(HttpServiceHosts httpServiceHosts, List<HttpAddress> addressList, String currentRouting) {
        this.currentRouting = currentRouting;
        this.addressList = addressList;
        this.httpServiceHosts = httpServiceHosts;
        this.currentRoutingGroup = new RoutingGroup(httpServiceHosts);
        this.grouped(addressList, currentRouting);
    }

    private void grouped(List<HttpAddress> addressList, String currentRouting) {
        if (addressList == null || addressList.size() == 0) {
            return;
        }
        HttpAddress httpAddress = null;
        if (logger.isDebugEnabled()) {
            logger.debug("Grouped http address by routing rule.currentRouting is {}", (Object)currentRouting);
        }
        ArrayList<HttpAddress> commonGroup = new ArrayList<HttpAddress>();
        for (int i = 0; i < addressList.size(); ++i) {
            httpAddress = addressList.get(i);
            if (httpAddress.getRouting() == null || httpAddress.getRouting().equals("")) {
                commonGroup.add(httpAddress);
                continue;
            }
            if (httpAddress.getRouting().equals(currentRouting)) {
                this.currentRoutingGroup.addHttpAddress(httpAddress);
                continue;
            }
            RoutingGroup routingGroup = this.routingGroupMap.get(httpAddress.getRouting());
            if (routingGroup == null) {
                routingGroup = new RoutingGroup(this.httpServiceHosts);
                this.routingGroupMap.put(httpAddress.getRouting(), routingGroup);
            }
            routingGroup.addHttpAddress(httpAddress);
        }
        this.currentRoutingGroup.after(commonGroup);
        if (logger.isDebugEnabled()) {
            logger.debug("Current RoutingGroup {} http address {}.", (Object)currentRouting, (Object)this.currentRoutingGroup.toString());
        }
        for (Map.Entry<String, RoutingGroup> entry : this.routingGroupMap.entrySet()) {
            entry.getValue().after(commonGroup);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("RoutingGroup {} http address {}.", (Object)entry.getKey(), (Object)entry.getValue().toString());
        }
    }

    public HttpAddress get() {
        HttpAddress httpAddress;
        block1: {
            Map.Entry<String, RoutingGroup> entry;
            httpAddress = this.currentRoutingGroup.get();
            if (httpAddress != null) break block1;
            Iterator<Map.Entry<String, RoutingGroup>> iterator = this.routingGroupMap.entrySet().iterator();
            while (iterator.hasNext() && (httpAddress = (entry = iterator.next()).getValue().get()) == null) {
            }
        }
        return httpAddress;
    }

    public String toString() {
        if (this.addressList != null) {
            return this.addressList.toString();
        }
        return "[]";
    }

    public HttpAddress getOkOrFailed() {
        HttpAddress httpAddress;
        block1: {
            Map.Entry<String, RoutingGroup> entry;
            httpAddress = this.currentRoutingGroup.get();
            if (httpAddress != null) break block1;
            Iterator<Map.Entry<String, RoutingGroup>> iterator = this.routingGroupMap.entrySet().iterator();
            while (iterator.hasNext() && (httpAddress = (entry = iterator.next()).getValue().getOkOrFailed()) == null) {
            }
        }
        return httpAddress;
    }

    public static boolean access(String[] accessRoutings, HttpAddress httpHost) {
        if (accessRoutings == null || accessRoutings.length == 0) {
            return true;
        }
        String accessRouting = httpHost.getRouting();
        if (accessRouting == null) {
            return true;
        }
        for (int i = 0; i < accessRoutings.length; ++i) {
            if (!accessRouting.equals(accessRoutings[i])) continue;
            return true;
        }
        return false;
    }

    public RoutingGroup getRoutingGroup(String routing) {
        return this.routingGroupMap.get(routing);
    }

    public int size() {
        return this.addressList.size();
    }
}

