/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.remote.http.proxy;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpAddress {
    private String address;
    private static Logger logger = LoggerFactory.getLogger(HttpAddress.class);
    private String originAddress;
    private String healthPath;
    private transient Thread healthCheck;
    private String routing;
    private Map<String, Object> attributes;
    private volatile int status = 0;

    public void setOriginAddress(String originAddress) {
        this.originAddress = originAddress;
    }

    public String getOriginAddress() {
        return this.originAddress;
    }

    public HttpAddress() {
    }

    public String getHealthPath() {
        return this.healthPath;
    }

    public void setHealthPath(String healthPath) {
        this.healthPath = healthPath;
    }

    private void initAddress() {
        String[] infos = this.originAddress.split("\\|");
        if (infos.length == 2) {
            this.address = infos[0];
            this.routing = infos[1];
        } else {
            this.address = infos[0];
        }
    }

    public HttpAddress(String address) {
        if (!address.startsWith("http://") && !address.startsWith("https://")) {
            address = "http://" + address;
        }
        this.originAddress = address;
        this.initAddress();
        this.healthPath = this.getPath(this.address, "/");
    }

    public HttpAddress(String address, String healthPath) {
        if (!address.startsWith("http://") && !address.startsWith("https://")) {
            address = "http://" + address;
        }
        this.originAddress = address;
        this.initAddress();
        if (healthPath != null) {
            this.healthPath = this.getPath(this.address, healthPath.trim());
        }
    }

    public HttpAddress(String originAddress, String address, String routing, String healthPath) {
        this.originAddress = originAddress;
        this.address = address;
        this.routing = routing;
        if (healthPath != null) {
            this.healthPath = this.getPath(this.address, healthPath.trim());
        }
    }

    private String getPath(String host, String path) {
        String url = path.equals("") || path.startsWith("/") ? host + path : host + "/" + path;
        return url;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
        this.healthPath = this.getPath(address, "/");
    }

    public int getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover() {
        if (this.status == 1) {
            HttpAddress httpAddress = this;
            synchronized (httpAddress) {
                if (this.status == 1) {
                    this.status = 0;
                    logger.info("Recover failed node {} to normal node.", (Object)this.originAddress);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(int status) {
        Object object = this;
        synchronized (object) {
            if (status == 0) {
                this.status = status;
                return;
            }
            if (this.status == 2) {
                return;
            }
            this.status = status;
        }
        if (status == 1 && this.healthCheck != null) {
            object = this.healthCheck;
            synchronized (object) {
                this.healthCheck.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onlySetStatus(int status) {
        HttpAddress httpAddress = this;
        synchronized (httpAddress) {
            if (status == 0) {
                this.status = status;
            } else if (this.status != 2) {
                this.status = status;
            }
        }
    }

    public String toString() {
        return this.originAddress + "|status=" + this.status;
    }

    public boolean ok() {
        return this.status == 0;
    }

    public boolean okOrFailed() {
        return this.status == 0 || this.status == 1;
    }

    public boolean failedCheck() {
        return this.status == 1;
    }

    public void setHealthCheck(Thread healthCheck) {
        this.healthCheck = healthCheck;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof HttpAddress) {
            String other = ((HttpAddress)obj).getAddress();
            return other != null && other.equals(this.getAddress());
        }
        return false;
    }

    public String getRouting() {
        return this.routing;
    }

    public void setRouting(String routing) {
        this.routing = routing;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public void addAttribute(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        if (this.attributes != null) {
            return this.attributes.get(key);
        }
        return null;
    }
}

