/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.remote.http;

import com.frameworkset.util.SimpleStringUtil;
import com.frameworkset.util.ValueCastUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Consts;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;
import org.apache.http.message.BasicHeader;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.frameworkset.spi.BaseApplicationContext;
import org.frameworkset.spi.BeanNameAware;
import org.frameworkset.spi.DefaultApplicationContext;
import org.frameworkset.spi.InitializingBean;
import org.frameworkset.spi.SPIException;
import org.frameworkset.spi.assemble.GetProperties;
import org.frameworkset.spi.assemble.MapGetProperties;
import org.frameworkset.spi.assemble.PropertiesContainer;
import org.frameworkset.spi.remote.http.ConfigHttpRuntimeException;
import org.frameworkset.spi.remote.http.ConnectionResetHttpRequestRetryHandler;
import org.frameworkset.spi.remote.http.CustomHttpRequestRetryHandler;
import org.frameworkset.spi.remote.http.DefaultHttpRequestRetryHandler;
import org.frameworkset.spi.remote.http.HealthCheckGetProperties;
import org.frameworkset.spi.remote.http.HttpConnectionKeepAliveStrategy;
import org.frameworkset.spi.remote.http.HttpRequestRetryHandlerHelper;
import org.frameworkset.spi.remote.http.HttpResourceStartResult;
import org.frameworkset.spi.remote.http.callback.HttpClientBuilderCallback;
import org.frameworkset.spi.remote.http.kerberos.BaseRequestKerberosUrlUtils;
import org.frameworkset.spi.remote.http.kerberos.KerberosConfig;
import org.frameworkset.spi.remote.http.kerberos.KerberosHelper;
import org.frameworkset.spi.remote.http.kerberos.RequestKerberosUrlUtilsJaasLoginConfig;
import org.frameworkset.spi.remote.http.kerberos.RequestKerberosUrlUtilsParams;
import org.frameworkset.spi.remote.http.kerberos.serverrealm.ServerRealmRequestKerberosUrlUtils;
import org.frameworkset.spi.remote.http.proxy.ExceptionWare;
import org.frameworkset.spi.remote.http.proxy.HttpHostDiscover;
import org.frameworkset.spi.remote.http.proxy.HttpServiceHosts;
import org.frameworkset.spi.remote.http.ssl.SSLHelper;
import org.frameworkset.util.ClassUtil;
import org.frameworkset.util.ResourceStartResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConfiguration
implements InitializingBean,
BeanNameAware {
    public static final ContentType TEXT_PLAIN_UTF_8 = ContentType.create((String)"text/plain", (Charset)Consts.UTF_8);
    public static final ContentType TEXT_HTML_UTF_8 = ContentType.create((String)"text/html", (Charset)Consts.UTF_8);
    private static final int TIMEOUT_CONNECTION = 20000;
    private static final int TIMEOUT_SOCKET = 20000;
    private static final int DEFAULT_validateAfterInactivity = -1;
    public static final String http_authAccount = "http.authAccount";
    public static final String http_authPassword = "http.authPassword";
    public static final String http_hosts = "http.hosts";
    public static final String http_health = "http.health";
    public static final String http_discover_service = "http.discoverService";
    public static final String http_exception_ware = "http.exceptionWare";
    public static final String http_fail_all_continue = "http.failAllContinue";
    public static final String http_apiKeyId = "http.apiKeyId";
    public static final String http_apiKeySecret = "http.apiKeySecret";
    public static final String http_healthCheck_prex = "__healthCheck_";
    private static final int RETRY_TIME = 3;
    private boolean automaticRetriesDisabled = false;
    private static final DefaultHttpRequestRetryHandler defaultHttpRequestRetryHandler = new ConnectionResetHttpRequestRetryHandler();
    private static final Logger logger = LoggerFactory.getLogger(ClientConfiguration.class);
    private static RequestConfig defaultRequestConfig;
    private static final Map<String, ClientConfiguration> clientConfigs;
    private static BaseApplicationContext context;
    private static boolean emptyContext;
    private static ClientConfiguration defaultClientConfiguration;
    private transient CloseableHttpClient httpclient;
    private transient RequestConfig requestConfig;
    private int timeoutConnection = 20000;
    private int timeoutSocket;
    private int connectionRequestTimeout = 20000;
    private int retryTime = 3;
    private int maxLineLength = 2000;
    private int maxHeaderCount = 200;
    private int maxTotal = 200;
    private int defaultMaxPerRoute = 10;
    private long retryInterval = -1L;
    private Boolean soKeepAlive = false;
    private Boolean soReuseAddress = false;
    private String hostnameVerifierString;
    private GetProperties contextProperties;
    private String authAccount;
    private String authPassword;
    private String apiKeyId;
    private String apiKeySecret;
    private KerberosConfig kerberosConfig;
    private BaseRequestKerberosUrlUtils requestKerberosUrlUtils;
    private String encodedAuthCharset = "US-ASCII";
    private String encodedapiKeySecretCharset = "UTF-8";
    private boolean backoffAuth = false;
    private Object httpClientBuilderCallback;
    private Object httpRequestInterceptors;
    private final int maxIdleTime = -1;
    private HttpServiceHosts httpServiceHosts;
    private int validateAfterInactivity = -1;
    private boolean staleConnectionCheckEnabled = false;
    private String customHttpRequestRetryHandler;
    private int timeToLive = 3600000;
    private String keystore;
    private String keystoreAlias;
    private String keyPassword;
    private String truststore;
    private String trustAlias;
    private String trustPassword;
    private String pemCert;
    private String pemtrustedCA;
    private String pemKey;
    private String pemkeyPassword;
    private String supportedProtocols;
    private String[] _supportedProtocols;
    private transient HostnameVerifier hostnameVerifier;
    private final String[] defaultSupportedProtocols = new String[]{"TLSv1.2", "TLSv1.1", "TLSv1"};
    private long keepAlive = 3600000L;
    private String beanName;
    private boolean evictExpiredConnections = true;
    private boolean closed = false;

    public void setRequestKerberosUrlUtils(BaseRequestKerberosUrlUtils requestKerberosUrlUtils) {
        this.requestKerberosUrlUtils = requestKerberosUrlUtils;
    }

    public String getApiKeyId() {
        return this.apiKeyId;
    }

    public BaseRequestKerberosUrlUtils getRequestKerberosUrlUtils() {
        return this.requestKerberosUrlUtils;
    }

    public void setApiKeyId(String apiKeyId) {
        this.apiKeyId = apiKeyId;
    }

    public String getApiKeySecret() {
        return this.apiKeySecret;
    }

    public void setApiKeySecret(String apiKeySecret) {
        this.apiKeySecret = apiKeySecret;
    }

    public String getEncodedAuthCharset() {
        return this.encodedAuthCharset;
    }

    public void setKerberosConfig(KerberosConfig kerberosConfig) {
        this.kerberosConfig = kerberosConfig;
    }

    public KerberosConfig getKerberosConfig() {
        return this.kerberosConfig;
    }

    public void setEncodedAuthCharset(String encodedAuthCharset) {
        this.encodedAuthCharset = encodedAuthCharset;
    }

    public Object getHttpClientBuilderCallback() {
        return this.httpClientBuilderCallback;
    }

    public void setHttpClientBuilderCallback(Object httpClientBuilderCallback) {
        this.httpClientBuilderCallback = httpClientBuilderCallback;
    }

    public Object getHttpRequestInterceptors() {
        return this.httpRequestInterceptors;
    }

    public void setHttpRequestInterceptors(Object httpRequestInterceptors) {
        this.httpRequestInterceptors = httpRequestInterceptors;
    }

    public String getAuthAccount() {
        return this.authAccount;
    }

    public void setAuthAccount(String authAccount) {
        this.authAccount = authAccount;
    }

    public String getAuthPassword() {
        return this.authPassword;
    }

    public void setAuthPassword(String authPassword) {
        this.authPassword = authPassword;
    }

    public HttpServiceHosts getHttpServiceHosts() {
        return this.httpServiceHosts;
    }

    public void setHttpServiceHosts(HttpServiceHosts httpServiceHosts) {
        this.httpServiceHosts = httpServiceHosts;
    }

    public boolean isEvictExpiredConnections() {
        return this.evictExpiredConnections;
    }

    public void setEvictExpiredConnections(boolean evictExpiredConnections) {
        this.evictExpiredConnections = evictExpiredConnections;
    }

    public String getBeanName() {
        return this.beanName;
    }

    private static void loadClientConfiguration() {
        if (context == null) {
            context = DefaultApplicationContext.getApplicationContext((String)"conf/httpclient.xml");
            emptyContext = context.isEmptyContext();
        }
    }

    public static RequestConfig getDefaultRequestConfig() {
        return defaultRequestConfig;
    }

    public static HttpClient getDefaultHttpclient() {
        ClientConfiguration.loadClientConfiguration();
        return ClientConfiguration.getDefaultClientConfiguration(null)._getHttpclient();
    }

    public static ClientConfiguration getDefaultClientConfiguration() {
        return ClientConfiguration.getDefaultClientConfiguration(null);
    }

    public static ClientConfiguration getDefaultClientConfiguration(ResourceStartResult resourceStartResult) {
        ClientConfiguration.loadClientConfiguration();
        if (defaultClientConfiguration != null) {
            return defaultClientConfiguration;
        }
        if (defaultClientConfiguration == null) {
            try {
                defaultClientConfiguration = ClientConfiguration.makeDefualtClientConfiguration(resourceStartResult, "default");
            }
            catch (Exception e) {
                throw new ConfigHttpRuntimeException("Get DefaultClientConfiguration[default] failed:", e);
            }
        }
        return defaultClientConfiguration;
    }

    private static ClientConfiguration _getDefaultClientConfiguration(ResourceStartResult resourceStartResult, String healthPoolname, GetProperties context) {
        if (healthPoolname != null) {
            try {
                return ClientConfiguration.makeDefualtClientConfiguration(resourceStartResult, healthPoolname, "default", context);
            }
            catch (Exception e) {
                throw new ConfigHttpRuntimeException("Get Default healthcheck ClientConfiguration[" + healthPoolname + "] failed:", e);
            }
        }
        if (defaultClientConfiguration != null) {
            return defaultClientConfiguration;
        }
        try {
            defaultClientConfiguration = ClientConfiguration.makeDefualtClientConfiguration(resourceStartResult, healthPoolname, "default", context);
            return defaultClientConfiguration;
        }
        catch (Exception e) {
            throw new ConfigHttpRuntimeException("Get DefaultClientConfiguration[default] failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClientConfiguration makeDefualtClientConfiguration(ResourceStartResult resourceStartResult, String name) throws Exception {
        ClientConfiguration clientConfiguration = clientConfigs.get(name);
        if (clientConfiguration != null) {
            return clientConfiguration;
        }
        Class<ClientConfiguration> clazz = ClientConfiguration.class;
        synchronized (ClientConfiguration.class) {
            block15: {
                clientConfiguration = clientConfigs.get(name);
                if (clientConfiguration != null) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return clientConfiguration;
                }
                if (!emptyContext) {
                    try {
                        clientConfiguration = (ClientConfiguration)context.getTBeanObject(name, ClientConfiguration.class);
                    }
                    catch (SPIException e) {
                        if (!logger.isWarnEnabled() || name.startsWith(http_healthCheck_prex)) break block15;
                        logger.warn("Make ClientConfiguration [" + name + "] failed,an internal http pool will been constructed:" + e.getMessage());
                    }
                }
            }
            if (clientConfiguration == null) {
                if (!name.startsWith(http_healthCheck_prex)) {
                    clientConfiguration = new ClientConfiguration();
                    clientConfiguration.setTimeoutConnection(50000);
                    clientConfiguration.setTimeoutSocket(0);
                    clientConfiguration.setConnectionRequestTimeout(50000);
                    clientConfiguration.setRetryTime(-1);
                    clientConfiguration.setRetryInterval(-1L);
                    clientConfiguration.setTimeToLive(3600000);
                    clientConfiguration.setEvictExpiredConnections(true);
                    clientConfiguration.setMaxLineLength(Integer.MAX_VALUE);
                    clientConfiguration.setMaxHeaderCount(Integer.MAX_VALUE);
                    clientConfiguration.setMaxTotal(500);
                    clientConfiguration.setAutomaticRetriesDisabled(true);
                    clientConfiguration.setDefaultMaxPerRoute(100);
                    clientConfiguration.setStaleConnectionCheckEnabled(false);
                    clientConfiguration.setValidateAfterInactivity(-1);
                    clientConfiguration.setCustomHttpRequestRetryHandler(null);
                    clientConfiguration.setBeanName(name);
                    clientConfiguration.afterPropertiesSet();
                    clientConfigs.put(name, clientConfiguration);
                    if (resourceStartResult != null) {
                        resourceStartResult.addResourceStartResult(name);
                    }
                    if (logger.isInfoEnabled()) {
                        logger.info("Make http pool[{}] use default config completed!", (Object)name);
                    }
                } else {
                    clientConfiguration = new ClientConfiguration();
                    clientConfiguration.setTimeoutConnection(5000);
                    clientConfiguration.setTimeoutSocket(0);
                    clientConfiguration.setConnectionRequestTimeout(5000);
                    clientConfiguration.setTimeToLive(3600000);
                    clientConfiguration.setEvictExpiredConnections(true);
                    clientConfiguration.setRetryTime(3);
                    clientConfiguration.setRetryInterval(-1L);
                    clientConfiguration.setMaxLineLength(Integer.MAX_VALUE);
                    clientConfiguration.setMaxHeaderCount(Integer.MAX_VALUE);
                    clientConfiguration.setMaxTotal(500);
                    clientConfiguration.setDefaultMaxPerRoute(50);
                    clientConfiguration.setStaleConnectionCheckEnabled(false);
                    clientConfiguration.setValidateAfterInactivity(-1);
                    clientConfiguration.setCustomHttpRequestRetryHandler(null);
                    clientConfiguration.setBeanName(name);
                    clientConfiguration.afterPropertiesSet();
                    clientConfigs.put(name, clientConfiguration);
                    if (resourceStartResult != null) {
                        resourceStartResult.addResourceStartResult(name);
                    }
                    if (logger.isInfoEnabled()) {
                        logger.info("Make http pool[{}] use default config completed!", (Object)name);
                    }
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return clientConfiguration;
        }
    }

    private static long _getLongValue(String poolName, String propertyName, GetProperties context, long defaultValue) throws Exception {
        Object _value = null;
        if (poolName.equals("default")) {
            _value = context.getExternalObjectProperty(propertyName);
            if (_value == null) {
                _value = context.getExternalObjectProperty(poolName + "." + propertyName);
            }
        } else {
            _value = context.getExternalObjectProperty(poolName + "." + propertyName);
        }
        if (_value == null) {
            return defaultValue;
        }
        return ValueCastUtil.toLong((Object)_value, (long)defaultValue);
    }

    private static boolean _getBooleanValue(String poolName, String propertyName, GetProperties context, boolean defaultValue) throws Exception {
        Object _value = null;
        if (poolName.equals("default")) {
            _value = context.getExternalObjectProperty(propertyName);
            if (_value == null) {
                _value = context.getExternalObjectProperty(poolName + "." + propertyName);
            }
        } else {
            _value = context.getExternalObjectProperty(poolName + "." + propertyName);
        }
        if (_value == null) {
            return defaultValue;
        }
        return ValueCastUtil.toBoolean((Object)_value, (boolean)defaultValue);
    }

    private static int _getIntValue(String poolName, String propertyName, GetProperties context, int defaultValue) throws Exception {
        Object _value = null;
        if (poolName.equals("default")) {
            _value = context.getExternalObjectProperty(propertyName);
            if (_value == null) {
                _value = context.getExternalObjectProperty(poolName + "." + propertyName);
            }
        } else {
            _value = context.getExternalObjectProperty(poolName + "." + propertyName);
        }
        return ValueCastUtil.toInt((Object)_value, (int)defaultValue);
    }

    public static String _getStringValue(String poolName, String propertyName, GetProperties context, String defaultValue) throws Exception {
        String _value = null;
        _value = poolName.equals("default") ? context.getExternalPropertyWithNS(poolName, propertyName) : context.getExternalPropertyWithNS(poolName, poolName + "." + propertyName);
        return ValueCastUtil.toString((Object)_value, (String)defaultValue);
    }

    public static Map<String, Object> _getValuesWithPrex(String poolName, String propertyNamePrex, GetProperties context) throws Exception {
        Map _value = null;
        if (poolName.equals("default")) {
            _value = context.getExternalProperties(poolName, propertyNamePrex, true);
            if (_value == null) {
                _value = context.getExternalProperties(poolName, poolName + "." + propertyNamePrex, true);
            }
        } else {
            _value = context.getExternalProperties(poolName, poolName + "." + propertyNamePrex, true);
        }
        return _value;
    }

    private static Object _getObjectValue(String poolName, String propertyName, GetProperties context, Object defaultValue) throws Exception {
        Object _value = null;
        _value = poolName.equals("default") ? context.getExternalObjectPropertyWithNS(poolName, propertyName) : context.getExternalObjectPropertyWithNS(poolName, poolName + "." + propertyName);
        if (_value == null) {
            return defaultValue;
        }
        return _value;
    }

    private static HostnameVerifier _getHostnameVerifier(String hostnameVerifier) throws Exception {
        if (hostnameVerifier == null) {
            return null;
        }
        if (hostnameVerifier.equals("defualt")) {
            return SSLConnectionSocketFactory.getDefaultHostnameVerifier();
        }
        return SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
    }

    public static ResourceStartResult startHttpPoolsFromApolloAwaredChange(String namespaces) {
        String apolloAwaredChangeListener = "org.frameworkset.apollo.HttpProxyConfigChangeListener";
        try {
            Class<?> clazz = Class.forName(apolloAwaredChangeListener);
        }
        catch (ClassNotFoundException e) {
            StringBuilder msg = new StringBuilder();
            msg.append("Start HttpPools From Apollo by AwaredChange failed: Please add compile dependency to build.gradle in gralde project: \r\ncompile \"com.bbossgroups.plugins:bboss-plugin-apollo:6.3.2\"").append(" \r\nor Add compile dependency to pom.xml in maven project: \r\n    ").append("    <dependency>\n").append("            <groupId>com.bbossgroups.plugins</groupId>\n").append("            <artifactId>bboss-plugin-apollo</artifactId>\n").append("            <version>6.3.2</version>\n").append("        </dependency>");
            logger.error(msg.toString(), (Throwable)e);
            throw new IllegalArgumentException(msg.toString(), e);
        }
        return ClientConfiguration.startHttpPoolsFromApollo(namespaces, apolloAwaredChangeListener);
    }

    public static ResourceStartResult startHttpPoolsFromApollo(String namespaces) {
        return ClientConfiguration.startHttpPoolsFromApollo(namespaces, null);
    }

    public static ResourceStartResult startHttpPoolsFromApollo(String namespaces, String configChangeListener) {
        HttpResourceStartResult resourceStartResult;
        block11: {
            resourceStartResult = new HttpResourceStartResult();
            if (namespaces == null || namespaces.equals("")) {
                if (logger.isWarnEnabled()) {
                    StringBuilder message = new StringBuilder();
                    message.append("Ignore start HttpPools from Apollo: namespaces is empty!");
                    logger.warn(message.toString());
                }
                return resourceStartResult;
            }
            PropertiesContainer propertiesContainer = new PropertiesContainer();
            propertiesContainer.addConfigPropertiesFromApollo(namespaces, configChangeListener);
            propertiesContainer.afterLoaded((GetProperties)propertiesContainer);
            String poolNames = propertiesContainer.getProperty("http.poolNames");
            if (poolNames == null) {
                try {
                    ClientConfiguration.makeDefualtClientConfiguration(resourceStartResult, null, "default", (GetProperties)propertiesContainer);
                    String health = ClientConfiguration._getStringValue("default", http_health, (GetProperties)propertiesContainer, null);
                    if (health != null && !health.equals("")) {
                        ClientConfiguration.makeDefualtClientConfiguration(resourceStartResult, ClientConfiguration.getHealthPoolName(null), "default", (GetProperties)propertiesContainer);
                    }
                }
                catch (Exception e) {
                    if (!logger.isErrorEnabled()) break block11;
                    StringBuilder message = new StringBuilder();
                    message.append("Start HttpPools from Apollo[").append(namespaces).append("] failed:");
                    logger.error(message.toString(), (Throwable)e);
                }
            } else {
                String[] poolNames_;
                for (String poolName : poolNames_ = poolNames.split(",")) {
                    if ((poolName = poolName.trim()).equals("")) {
                        poolName = "default";
                    }
                    try {
                        ClientConfiguration.makeDefualtClientConfiguration(resourceStartResult, null, poolName, (GetProperties)propertiesContainer);
                        String health = ClientConfiguration._getStringValue(poolName, http_health, (GetProperties)propertiesContainer, null);
                        if (health == null || health.equals("")) continue;
                        ClientConfiguration.makeDefualtClientConfiguration(resourceStartResult, ClientConfiguration.getHealthPoolName(poolName), poolName, (GetProperties)propertiesContainer);
                    }
                    catch (Exception e) {
                        if (!logger.isErrorEnabled()) continue;
                        StringBuilder message = new StringBuilder();
                        message.append("Start HttpPools from Apollo[").append(namespaces).append("] failed:");
                        logger.error(message.toString(), (Throwable)e);
                    }
                }
            }
        }
        return resourceStartResult;
    }

    public static ResourceStartResult startHttpPoolsFromNacosAwaredChange(String namespace, String serverAddr, String dataId, String group, long timeOut, Map<String, String> pros) {
        String apolloAwaredChangeListener = "org.frameworkset.nacos.HttpProxyConfigChangeListener";
        try {
            Class<?> clazz = Class.forName(apolloAwaredChangeListener);
        }
        catch (ClassNotFoundException e) {
            StringBuilder msg = new StringBuilder();
            msg.append("Start HttpPools From Apollo by AwaredChange failed: Please add compile dependency to build.gradle in gralde project: \r\ncompile \"com.bbossgroups.plugins:bboss-plugin-nacos:6.3.2\"").append(" \r\nor Add compile dependency to pom.xml in maven project: \r\n    ").append("    <dependency>\n").append("            <groupId>com.bbossgroups.plugins</groupId>\n").append("            <artifactId>bboss-plugin-nacos</artifactId>\n").append("            <version>6.3.2</version>\n").append("        </dependency>");
            logger.error(msg.toString(), (Throwable)e);
            throw new IllegalArgumentException(msg.toString(), e);
        }
        return ClientConfiguration.startHttpPoolsFromNacos(namespace, serverAddr, dataId, group, timeOut, apolloAwaredChangeListener, pros);
    }

    public static ResourceStartResult startHttpPoolsFromNacos(String namespace, String serverAddr, String dataId, String group, long timeOut, Map<String, String> pros) {
        return ClientConfiguration.startHttpPoolsFromNacos(namespace, serverAddr, dataId, group, timeOut, null, pros);
    }

    public static ResourceStartResult startHttpPoolsFromNacos(String namespace, String serverAddr, String dataId, String group, long timeOut, String configChangeListener, Map<String, String> pros) {
        HttpResourceStartResult resourceStartResult;
        block9: {
            resourceStartResult = new HttpResourceStartResult();
            PropertiesContainer propertiesContainer = new PropertiesContainer();
            propertiesContainer.addConfigPropertiesFromNacos(namespace, serverAddr, dataId, group, timeOut, configChangeListener, pros);
            propertiesContainer.afterLoaded((GetProperties)propertiesContainer);
            String poolNames = propertiesContainer.getProperty("http.poolNames");
            if (poolNames == null) {
                try {
                    ClientConfiguration.makeDefualtClientConfiguration(resourceStartResult, null, "default", (GetProperties)propertiesContainer);
                    String health = ClientConfiguration._getStringValue("default", http_health, (GetProperties)propertiesContainer, null);
                    if (health != null && !health.equals("")) {
                        ClientConfiguration.makeDefualtClientConfiguration(resourceStartResult, ClientConfiguration.getHealthPoolName(null), "default", (GetProperties)propertiesContainer);
                    }
                }
                catch (Exception e) {
                    if (!logger.isErrorEnabled()) break block9;
                    StringBuilder message = new StringBuilder();
                    message.append("Start HttpPools from Nacos[namespace=").append(namespace).append(",serverAddr=").append(serverAddr).append(",dataId=").append(dataId).append(",group=").append(group).append(",timeOut=").append(timeOut).append(",configChangeListener=").append(configChangeListener).append(",pros=").append(pros != null ? SimpleStringUtil.object2json(pros) : "").append("] failed:");
                    logger.error(message.toString(), (Throwable)e);
                }
            } else {
                String[] poolNames_;
                for (String poolName : poolNames_ = poolNames.split(",")) {
                    if ((poolName = poolName.trim()).equals("")) {
                        poolName = "default";
                    }
                    try {
                        ClientConfiguration.makeDefualtClientConfiguration(resourceStartResult, null, poolName, (GetProperties)propertiesContainer);
                        String health = ClientConfiguration._getStringValue(poolName, http_health, (GetProperties)propertiesContainer, null);
                        if (health == null || health.equals("")) continue;
                        ClientConfiguration.makeDefualtClientConfiguration(resourceStartResult, ClientConfiguration.getHealthPoolName(poolName), poolName, (GetProperties)propertiesContainer);
                    }
                    catch (Exception e) {
                        if (!logger.isErrorEnabled()) continue;
                        StringBuilder message = new StringBuilder();
                        message.append("Start HttpPools from Nacos[namespace=").append(namespace).append(",serverAddr=").append(serverAddr).append(",dataId=").append(dataId).append(",group=").append(group).append(",timeOut=").append(timeOut).append(",configChangeListener=").append(configChangeListener).append(",pros=").append(pros != null ? SimpleStringUtil.object2json(pros) : "").append("] failed:");
                        logger.error(message.toString(), (Throwable)e);
                    }
                }
            }
        }
        return resourceStartResult;
    }

    public static ResourceStartResult startHttpPools(String configFile) {
        HttpResourceStartResult resourceStartResult;
        block11: {
            resourceStartResult = new HttpResourceStartResult();
            if (configFile == null || configFile.equals("")) {
                if (logger.isWarnEnabled()) {
                    StringBuilder message = new StringBuilder();
                    message.append("Ignore start HttpPools from configfile[").append(configFile).append("]: configFile path is empty!");
                    logger.warn(message.toString());
                }
                return resourceStartResult;
            }
            PropertiesContainer propertiesContainer = new PropertiesContainer();
            propertiesContainer.addConfigPropertiesFile(configFile);
            String poolNames = propertiesContainer.getProperty("http.poolNames");
            if (poolNames == null) {
                try {
                    ClientConfiguration.makeDefualtClientConfiguration(resourceStartResult, null, "default", (GetProperties)propertiesContainer);
                    String health = ClientConfiguration._getStringValue("default", http_health, (GetProperties)propertiesContainer, null);
                    if (health != null && !health.equals("")) {
                        ClientConfiguration.makeDefualtClientConfiguration(resourceStartResult, ClientConfiguration.getHealthPoolName("default"), "default", (GetProperties)propertiesContainer);
                    }
                }
                catch (Exception e) {
                    if (!logger.isErrorEnabled()) break block11;
                    StringBuilder message = new StringBuilder();
                    message.append("Start HttpPools from configfile[").append(configFile).append("] failed:");
                    logger.error(message.toString(), (Throwable)e);
                }
            } else {
                String[] poolNames_;
                for (String poolName : poolNames_ = poolNames.split(",")) {
                    if ((poolName = poolName.trim()).equals("")) {
                        poolName = "default";
                    }
                    try {
                        ClientConfiguration.makeDefualtClientConfiguration(resourceStartResult, null, poolName, (GetProperties)propertiesContainer);
                        String health = ClientConfiguration._getStringValue(poolName, http_health, (GetProperties)propertiesContainer, null);
                        if (health == null || health.equals("")) continue;
                        ClientConfiguration.makeDefualtClientConfiguration(resourceStartResult, ClientConfiguration.getHealthPoolName(poolName), poolName, (GetProperties)propertiesContainer);
                    }
                    catch (Exception e) {
                        if (!logger.isErrorEnabled()) continue;
                        StringBuilder message = new StringBuilder();
                        message.append("Start HttpPools from configfile[").append(configFile).append("] failed:");
                        logger.error(message.toString(), (Throwable)e);
                    }
                }
            }
        }
        return resourceStartResult;
    }

    public static ResourceStartResult startHttpPools(Map<String, Object> configs) {
        HttpResourceStartResult resourceStartResult;
        block11: {
            resourceStartResult = new HttpResourceStartResult();
            if (configs == null || configs.size() == 0) {
                if (logger.isWarnEnabled()) {
                    StringBuilder message = new StringBuilder();
                    message.append("Ignore start HttpPools from configs: configs is null or empty!");
                    logger.warn(message.toString());
                }
                return resourceStartResult;
            }
            MapGetProperties propertiesContainer = new MapGetProperties(configs);
            String poolNames = propertiesContainer.getExternalProperty("http.poolNames");
            if (poolNames == null) {
                try {
                    ClientConfiguration.makeDefualtClientConfiguration(resourceStartResult, null, "default", (GetProperties)propertiesContainer);
                    String health = ClientConfiguration._getStringValue("default", http_health, (GetProperties)propertiesContainer, null);
                    if (health != null && !health.equals("")) {
                        ClientConfiguration.makeDefualtClientConfiguration(resourceStartResult, ClientConfiguration.getHealthPoolName("default"), "default", (GetProperties)propertiesContainer);
                    }
                }
                catch (Exception e) {
                    if (!logger.isErrorEnabled()) break block11;
                    StringBuilder message = new StringBuilder();
                    message.append("Start HttpPool[default] from configs failed:");
                    logger.error(message.toString(), (Throwable)e);
                }
            } else {
                String[] poolNames_;
                for (String poolName : poolNames_ = poolNames.split(",")) {
                    if ((poolName = poolName.trim()).equals("")) {
                        poolName = "default";
                    }
                    try {
                        ClientConfiguration.makeDefualtClientConfiguration(resourceStartResult, null, poolName, (GetProperties)propertiesContainer);
                        String health = ClientConfiguration._getStringValue(poolName, http_health, (GetProperties)propertiesContainer, null);
                        if (health == null || health.equals("")) continue;
                        ClientConfiguration.makeDefualtClientConfiguration(resourceStartResult, ClientConfiguration.getHealthPoolName(poolName), poolName, (GetProperties)propertiesContainer);
                    }
                    catch (Exception e) {
                        if (!logger.isErrorEnabled()) continue;
                        StringBuilder message = new StringBuilder();
                        message.append("Start HttpPool[").append(poolName).append("] from configs failed:");
                        logger.error(message.toString(), (Throwable)e);
                    }
                }
            }
        }
        return resourceStartResult;
    }

    static ClientConfiguration _get(String healthPoolname, String name) {
        ClientConfiguration clientConfiguration = null;
        clientConfiguration = healthPoolname != null ? clientConfigs.get(healthPoolname) : clientConfigs.get(name);
        return clientConfiguration;
    }

    static String rname(String healthPoolname, String name) {
        if (healthPoolname != null) {
            return healthPoolname;
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ClientConfiguration makeDefualtClientConfiguration(ResourceStartResult resourceStartResult, String healthPoolname, String name, GetProperties context) throws Exception {
        ClientConfiguration clientConfiguration = ClientConfiguration._get(healthPoolname, name);
        if (clientConfiguration != null) {
            if (logger.isInfoEnabled()) {
                logger.info("Ignore MakeDefualtClientConfiguration and return existed Http Pool[{}].", (Object)ClientConfiguration.rname(healthPoolname, name));
            }
            return clientConfiguration;
        }
        Class<ClientConfiguration> clazz = ClientConfiguration.class;
        synchronized (ClientConfiguration.class) {
            HttpServiceHosts httpServiceHosts;
            StringBuilder log;
            block54: {
                String apiKeyId;
                clientConfiguration = ClientConfiguration._get(healthPoolname, name);
                if (clientConfiguration != null) {
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return clientConfiguration;
                }
                if (healthPoolname != null && !(context instanceof HealthCheckGetProperties)) {
                    context = new HealthCheckGetProperties(context);
                }
                clientConfiguration = new ClientConfiguration();
                clientConfiguration.setContextProperties(context);
                log = new StringBuilder();
                String authAccount = ClientConfiguration._getStringValue(name, http_authAccount, context, null);
                if (authAccount != null && !authAccount.equals("")) {
                    clientConfiguration.setAuthAccount(authAccount);
                }
                log.append("http.authAccount=").append(authAccount);
                String authPassword = ClientConfiguration._getStringValue(name, http_authPassword, context, null);
                if (authPassword != null && !authPassword.equals("")) {
                    clientConfiguration.setAuthPassword(authPassword);
                    if (PropertiesContainer.showPassword) {
                        log.append(",http.authPassword=").append(authPassword);
                    } else {
                        log.append(",http.authPassword=******");
                    }
                }
                if ((apiKeyId = ClientConfiguration._getStringValue(name, http_apiKeyId, context, null)) != null && !apiKeyId.equals("")) {
                    clientConfiguration.setApiKeyId(apiKeyId);
                }
                log.append(",http.apiKeyId=").append(apiKeyId);
                String apiKeySecret = ClientConfiguration._getStringValue(name, http_apiKeySecret, context, null);
                if (apiKeySecret != null && !apiKeySecret.equals("")) {
                    clientConfiguration.setApiKeySecret(apiKeySecret);
                    if (PropertiesContainer.showPassword) {
                        log.append(",http.apiKeySecret=").append(apiKeySecret);
                    } else {
                        log.append(",http.apiKeySecret=******");
                    }
                }
                if (healthPoolname == null) {
                    KerberosConfig kerberosConfig = KerberosHelper.buildKerberosConfig(name, context, healthPoolname, log);
                    if (kerberosConfig != null) {
                        clientConfiguration.setKerberosConfig(kerberosConfig);
                    }
                } else {
                    ClientConfiguration tmp = clientConfigs.get(name);
                    clientConfiguration.setKerberosConfig(tmp.getKerberosConfig());
                }
                String encodedAuthCharset = ClientConfiguration._getStringValue(name, "http.encodedAuthCharset", context, "US-ASCII");
                if (encodedAuthCharset != null && !encodedAuthCharset.equals("")) {
                    clientConfiguration.setEncodedAuthCharset(encodedAuthCharset);
                }
                log.append(",http.encodedAuthCharset=").append(encodedAuthCharset);
                int timeoutConnection = ClientConfiguration._getIntValue(name, "http.timeoutConnection", context, 50000);
                log.append(",http.timeoutConnection=").append(timeoutConnection);
                clientConfiguration.setTimeoutConnection(timeoutConnection);
                int timeoutSocket = ClientConfiguration._getIntValue(name, "http.timeoutSocket", context, 0);
                log.append(",http.timeoutSocket=").append(timeoutSocket);
                clientConfiguration.setTimeoutSocket(timeoutSocket);
                int connectionRequestTimeout = ClientConfiguration._getIntValue(name, "http.connectionRequestTimeout", context, 50000);
                log.append(",http.connectionRequestTimeout=").append(connectionRequestTimeout);
                clientConfiguration.setConnectionRequestTimeout(connectionRequestTimeout);
                int retryTime = ClientConfiguration._getIntValue(name, "http.retryTime", context, -1);
                log.append(",http.retryTime=").append(retryTime);
                clientConfiguration.setRetryTime(retryTime);
                boolean automaticRetriesDisabled = ClientConfiguration._getBooleanValue(name, "http.automaticRetriesDisabled", context, false);
                log.append(",http.automaticRetriesDisabled=").append(automaticRetriesDisabled);
                clientConfiguration.setAutomaticRetriesDisabled(automaticRetriesDisabled);
                boolean backoffAuth = ClientConfiguration._getBooleanValue(name, "http.backoffAuth", context, false);
                log.append(",http.backoffAuth=").append(backoffAuth);
                clientConfiguration.setBackoffAuth(backoffAuth);
                long retryInterval = ClientConfiguration._getLongValue(name, "http.retryInterval", context, -1L);
                log.append(",http.retryInterval=").append(retryInterval);
                clientConfiguration.setRetryInterval(retryInterval);
                int maxLineLength = ClientConfiguration._getIntValue(name, "http.maxLineLength", context, -1);
                log.append(",http.maxLineLength=").append(maxLineLength);
                clientConfiguration.setMaxLineLength(maxLineLength);
                int maxHeaderCount = ClientConfiguration._getIntValue(name, "http.maxHeaderCount", context, 500);
                log.append(",http.maxHeaderCount=").append(maxHeaderCount);
                clientConfiguration.setMaxHeaderCount(maxHeaderCount);
                int maxTotal = ClientConfiguration._getIntValue(name, "http.maxTotal", context, 1000);
                log.append(",http.maxTotal=").append(maxTotal);
                clientConfiguration.setMaxTotal(maxTotal);
                boolean soReuseAddress = ClientConfiguration._getBooleanValue(name, "http.soReuseAddress", context, false);
                log.append(",http.soReuseAddress=").append(soReuseAddress);
                clientConfiguration.setSoReuseAddress(soReuseAddress);
                boolean soKeepAlive = ClientConfiguration._getBooleanValue(name, "http.soKeepAlive", context, false);
                log.append(",http.soKeepAlive=").append(soKeepAlive);
                clientConfiguration.setSoKeepAlive(soKeepAlive);
                int timeToLive = ClientConfiguration._getIntValue(name, "http.timeToLive", context, 3600000);
                log.append(",http.timeToLive=").append(timeToLive);
                clientConfiguration.setTimeToLive(timeToLive);
                int keepAlive = ClientConfiguration._getIntValue(name, "http.keepAlive", context, 3600000);
                log.append(",http.keepAlive=").append(keepAlive);
                clientConfiguration.setKeepAlive(keepAlive);
                int defaultMaxPerRoute = ClientConfiguration._getIntValue(name, "http.defaultMaxPerRoute", context, 200);
                log.append(",http.defaultMaxPerRoute=").append(defaultMaxPerRoute);
                clientConfiguration.setDefaultMaxPerRoute(defaultMaxPerRoute);
                int validateAfterInactivity = ClientConfiguration._getIntValue(name, "http.validateAfterInactivity", context, -1);
                log.append(",http.validateAfterInactivity=").append(validateAfterInactivity);
                clientConfiguration.setValidateAfterInactivity(validateAfterInactivity);
                boolean staleConnectionCheckEnabled = ClientConfiguration._getBooleanValue(name, "http.staleConnectionCheckEnabled", context, false);
                log.append(",http.staleConnectionCheckEnabled=").append(staleConnectionCheckEnabled);
                clientConfiguration.setStaleConnectionCheckEnabled(staleConnectionCheckEnabled);
                String customHttpRequestRetryHandler = ClientConfiguration._getStringValue(name, "http.customHttpRequestRetryHandler", context, null);
                log.append(",http.customHttpRequestRetryHandler=").append(customHttpRequestRetryHandler);
                clientConfiguration.setCustomHttpRequestRetryHandler(customHttpRequestRetryHandler);
                String keystore = ClientConfiguration._getStringValue(name, "http.keystore", context, null);
                log.append(",http.keystore=").append(keystore);
                clientConfiguration.setKeystore(keystore);
                String keystoreAlias = ClientConfiguration._getStringValue(name, "http.keystoreAlias", context, null);
                log.append(",http.keystoreAlias=").append(keystoreAlias);
                clientConfiguration.setKeystoreAlias(keystoreAlias);
                String keyPassword = ClientConfiguration._getStringValue(name, "http.keyPassword", context, null);
                log.append(",http.keyPassword=").append(keyPassword);
                clientConfiguration.setKeyPassword(keyPassword);
                String truststore = ClientConfiguration._getStringValue(name, "http.truststore", context, null);
                log.append(",http.truststore=").append(truststore);
                clientConfiguration.setTruststore(truststore);
                String truststoreAlias = ClientConfiguration._getStringValue(name, "http.truststoreAlias", context, null);
                log.append(",http.truststoreAlias=").append(truststoreAlias);
                clientConfiguration.setTrustAlias(truststoreAlias);
                String trustPassword = ClientConfiguration._getStringValue(name, "http.trustPassword", context, null);
                log.append(",http.trustPassword=").append(trustPassword);
                clientConfiguration.setTrustPassword(trustPassword);
                String pemCert = ClientConfiguration._getStringValue(name, "http.pemCert", context, null);
                log.append(",http.pemCert=").append(pemCert);
                clientConfiguration.setPemCert(pemCert);
                String pemtrustedCA = ClientConfiguration._getStringValue(name, "http.pemtrustedCA", context, null);
                log.append(",http.pemtrustedCA=").append(pemtrustedCA);
                clientConfiguration.setPemtrustedCA(pemtrustedCA);
                String pemKey = ClientConfiguration._getStringValue(name, "http.pemKey", context, null);
                log.append(",http.pemKey=").append(pemKey);
                clientConfiguration.setPemKey(pemKey);
                String pemkeyPassword = ClientConfiguration._getStringValue(name, "http.pemkeyPassword", context, null);
                log.append(",http.pemkeyPassword=").append(pemkeyPassword);
                clientConfiguration.setPemkeyPassword(pemkeyPassword);
                String hostnameVerifier = ClientConfiguration._getStringValue(name, "http.hostnameVerifier", context, null);
                log.append(",http.hostnameVerifier=").append(hostnameVerifier);
                clientConfiguration.setHostnameVerifierString(hostnameVerifier);
                clientConfiguration.setHostnameVerifier(ClientConfiguration._getHostnameVerifier(hostnameVerifier));
                String supportedProtocols = ClientConfiguration._getStringValue(name, "http.supportedProtocols", context, "TLSv1.2,TLSv1.1,TLSv1");
                log.append(",http.supportedProtocols=").append(supportedProtocols);
                Object httpClientBuilderCallback = ClientConfiguration._getObjectValue(name, "http.httpClientBuilderCallback", context, null);
                log.append(",http.httpClientBuilderCallback=").append(httpClientBuilderCallback);
                if (httpClientBuilderCallback != null) {
                    clientConfiguration.setHttpClientBuilderCallback(httpClientBuilderCallback);
                }
                Object httpRequestInterceptors = ClientConfiguration._getObjectValue(name, "http.httpRequestInterceptors", context, null);
                log.append(",http.httpRequestInterceptors=").append(httpRequestInterceptors);
                if (httpRequestInterceptors != null) {
                    clientConfiguration.setHttpRequestInterceptors(httpRequestInterceptors);
                }
                clientConfiguration.setSupportedProtocols(supportedProtocols);
                boolean evictExpiredConnections = ClientConfiguration._getBooleanValue(name, "http.evictExpiredConnections", context, true);
                clientConfiguration.setEvictExpiredConnections(evictExpiredConnections);
                log.append(",http.evictExpiredConnections=").append(evictExpiredConnections);
                clientConfiguration.setBeanName(ClientConfiguration.rname(healthPoolname, name));
                httpServiceHosts = null;
                if (healthPoolname == null) {
                    block53: {
                        block52: {
                            Object exceptionWare;
                            httpServiceHosts = new HttpServiceHosts();
                            httpServiceHosts.setClientConfiguration(clientConfiguration);
                            String routing = ClientConfiguration._getStringValue(name, "http.routing", context, null);
                            log.append(",http.routing=").append(routing);
                            httpServiceHosts.setRouting(routing);
                            String health = ClientConfiguration._getStringValue(name, http_health, context, null);
                            log.append(",http.health=").append(health);
                            httpServiceHosts.setHealth(health);
                            Object discoverService = ClientConfiguration._getObjectValue(name, http_discover_service, context, null);
                            log.append(",http.discoverService=").append(discoverService);
                            if (discoverService != null) {
                                if (discoverService instanceof String) {
                                    httpServiceHosts.setDiscoverService((String)discoverService);
                                } else if (discoverService instanceof HttpHostDiscover) {
                                    httpServiceHosts.setHostDiscover((HttpHostDiscover)discoverService);
                                }
                            }
                            if ((exceptionWare = ClientConfiguration._getObjectValue(name, http_exception_ware, context, null)) != null) {
                                if (exceptionWare instanceof String) {
                                    httpServiceHosts.setExceptionWare((String)exceptionWare);
                                    log.append(",http.exceptionWare=").append(exceptionWare);
                                } else if (exceptionWare instanceof ExceptionWare) {
                                    httpServiceHosts.setExceptionWareBean((ExceptionWare)exceptionWare);
                                    log.append(",http.exceptionWare=").append(exceptionWare.getClass().getCanonicalName());
                                }
                            }
                            String hosts = ClientConfiguration._getStringValue(name, http_hosts, context, null);
                            log.append(",http.hosts=").append(hosts);
                            httpServiceHosts.setHosts(hosts);
                            String failAllContinue_ = ClientConfiguration._getStringValue(name, http_fail_all_continue, context, "true");
                            log.append(",http.failAllContinue=").append(failAllContinue_);
                            if (failAllContinue_ != null) {
                                try {
                                    httpServiceHosts.setFailAllContinue(Boolean.parseBoolean(failAllContinue_));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            String healthCheckInterval_ = ClientConfiguration._getStringValue(name, "http.healthCheckInterval", context, null);
                            log.append(",http.healthCheckInterval=").append(healthCheckInterval_);
                            if (healthCheckInterval_ == null) {
                                httpServiceHosts.setHealthCheckInterval(3000L);
                            } else {
                                try {
                                    httpServiceHosts.setHealthCheckInterval(Long.parseLong(healthCheckInterval_));
                                }
                                catch (Exception e) {
                                    if (!logger.isErrorEnabled()) break block52;
                                    logger.error("Parse Long healthCheckInterval parameter failed:" + healthCheckInterval_, (Throwable)e);
                                }
                            }
                        }
                        String discoverServiceInterval_ = ClientConfiguration._getStringValue(name, "http.discoverServiceInterval", context, null);
                        log.append(",http.discoverServiceInterval=").append(discoverServiceInterval_);
                        if (discoverServiceInterval_ == null) {
                            httpServiceHosts.setDiscoverServiceInterval(10000L);
                        } else {
                            try {
                                httpServiceHosts.setDiscoverServiceInterval(Long.parseLong(discoverServiceInterval_));
                            }
                            catch (Exception e) {
                                if (!logger.isErrorEnabled()) break block53;
                                logger.error("Parse Long discoverServiceInterval parameter failed:" + discoverServiceInterval_, (Throwable)e);
                            }
                        }
                    }
                    String handleNullOrEmptyHostsByDiscovery_ = ClientConfiguration._getStringValue(name, "http.handleNullOrEmptyHostsByDiscovery", context, null);
                    log.append(",http.handleNullOrEmptyHostsByDiscovery=").append(handleNullOrEmptyHostsByDiscovery_);
                    if (handleNullOrEmptyHostsByDiscovery_ == null) {
                        httpServiceHosts.setHandleNullOrEmptyHostsByDiscovery(false);
                    } else {
                        try {
                            httpServiceHosts.setHandleNullOrEmptyHostsByDiscovery(Boolean.parseBoolean(handleNullOrEmptyHostsByDiscovery_));
                        }
                        catch (Exception e) {
                            if (!logger.isErrorEnabled()) break block54;
                            logger.error("Parse Boolean handleNullOrEmptyHostsByDiscovery_ parameter failed:" + handleNullOrEmptyHostsByDiscovery_, (Throwable)e);
                        }
                    }
                }
            }
            if (healthPoolname == null && httpServiceHosts != null) {
                httpServiceHosts.toString(log);
                clientConfiguration.httpServiceHosts = httpServiceHosts;
            }
            if (logger.isInfoEnabled()) {
                logger.info("Http Pool[{}] config:{}", (Object)ClientConfiguration.rname(healthPoolname, name), (Object)log.toString());
            }
            if (healthPoolname != null) {
                ClientConfiguration tmp = clientConfigs.get(name);
                clientConfiguration.setRequestKerberosUrlUtils(tmp.getRequestKerberosUrlUtils());
            }
            try {
                clientConfiguration.afterPropertiesSet();
                if (healthPoolname == null) {
                    httpServiceHosts.after(name, context);
                }
            }
            catch (Exception e) {
                clientConfiguration.close(true);
                throw e;
            }
            clientConfigs.put(ClientConfiguration.rname(healthPoolname, name), clientConfiguration);
            if (resourceStartResult != null) {
                resourceStartResult.addResourceStartResult(ClientConfiguration.rname(healthPoolname, name));
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return clientConfiguration;
        }
    }

    public static ResourceStartResult bootClientConfiguations(String[] serverNames, GetProperties context) {
        HttpResourceStartResult resourceStartResult = new HttpResourceStartResult();
        for (String serverName : serverNames) {
            ClientConfiguration.configClientConfiguation(resourceStartResult, null, serverName, context);
        }
        return resourceStartResult;
    }

    public static ClientConfiguration stopHttpClient(String poolName) {
        ClientConfiguration healthclientConfiguration;
        if (poolName == null) {
            poolName = "default";
        }
        logger.info("Stop HttpClient[{}] client begin......", (Object)poolName);
        String healthPool = ClientConfiguration.getHealthPoolName(poolName);
        boolean r = false;
        ClientConfiguration clientConfiguration = ClientConfiguration.getClientConfigurationAndRemove(poolName);
        if (clientConfiguration != null) {
            clientConfiguration.close();
        }
        if ((healthclientConfiguration = ClientConfiguration.getClientConfigurationAndRemove(healthPool)) != null) {
            healthclientConfiguration.close();
        }
        if (poolName.equals("default")) {
            defaultClientConfiguration = null;
        }
        logger.info("Stop HttpClient[{}] client complete.", (Object)poolName);
        return clientConfiguration;
    }

    public synchronized void close() {
        this.close(false);
    }

    public synchronized void close(boolean fromException) {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.requestKerberosUrlUtils != null) {
            this.requestKerberosUrlUtils.close();
        }
        if (this.httpServiceHosts != null) {
            this.httpServiceHosts.close();
            this.httpServiceHosts = null;
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.httpclient != null) {
            try {
                this.httpclient.close();
                this.httpclient = null;
            }
            catch (IOException e) {
                logger.warn("stop http pool " + this.getBeanName() + " failed:", (Throwable)e);
            }
        }
        if (!fromException) {
            logger.info("Http pool " + this.getBeanName() + " stopped.");
        } else {
            logger.info("Http pool " + this.getBeanName() + " terminated abnormally!");
        }
    }

    public static ResourceStartResult bootHealthCheckClientConfiguations(String[] serverNames, GetProperties context) {
        HttpResourceStartResult resourceStartResult = new HttpResourceStartResult();
        HealthCheckGetProperties healthCheckGetProperties = new HealthCheckGetProperties(context);
        for (String serverName : serverNames) {
            ClientConfiguration.configClientConfiguation(resourceStartResult, ClientConfiguration.getHealthPoolName(serverName), serverName, healthCheckGetProperties);
        }
        return resourceStartResult;
    }

    private static ClientConfiguration configClientConfiguation(ResourceStartResult resourceStartResult, String healthPoolname, String poolname, GetProperties context) {
        if (poolname == null || poolname.equals("default")) {
            return ClientConfiguration._getDefaultClientConfiguration(resourceStartResult, healthPoolname, context);
        }
        try {
            return ClientConfiguration.makeDefualtClientConfiguration(resourceStartResult, healthPoolname, poolname, context);
        }
        catch (Exception e) {
            throw new ConfigHttpRuntimeException("Build ClientConfiguration [" + healthPoolname + poolname + "] failed:", e);
        }
    }

    public static String getHealthPoolName(String httpPool) {
        String healthPool = httpPool != null ? http_healthCheck_prex + httpPool : "__healthCheck_default";
        return healthPool;
    }

    public static ClientConfiguration getClientConfigurationAndRemove(String poolname) {
        if (poolname == null) {
            poolname = "default";
        }
        return clientConfigs.remove(poolname);
    }

    public static ClientConfiguration getClientConfigurationOnly(String poolname) {
        if (poolname == null) {
            poolname = "default";
        }
        return clientConfigs.get(poolname);
    }

    public static ClientConfiguration getClientConfiguration(String poolname) {
        ClientConfiguration.loadClientConfiguration();
        if (poolname == null) {
            return ClientConfiguration.getDefaultClientConfiguration(null);
        }
        try {
            return ClientConfiguration.makeDefualtClientConfiguration(null, poolname);
        }
        catch (Exception e) {
            throw new ConfigHttpRuntimeException("makeDefualtClientConfiguration [" + poolname + "] failed:", e);
        }
    }

    public String getKeystore() {
        return this.keystore;
    }

    public void setKeystore(String keystore) {
        this.keystore = keystore;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public String getSupportedProtocols() {
        return this.supportedProtocols;
    }

    public void setSupportedProtocols(String supportedProtocols) {
        this.supportedProtocols = supportedProtocols;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public Boolean getSoKeepAlive() {
        return this.soKeepAlive;
    }

    public void setSoKeepAlive(Boolean soKeepAlive) {
        this.soKeepAlive = soKeepAlive;
    }

    public Boolean getSoReuseAddress() {
        return this.soReuseAddress;
    }

    public void setSoReuseAddress(Boolean soReuseAddress) {
        this.soReuseAddress = soReuseAddress;
    }

    public int getValidateAfterInactivity() {
        return this.validateAfterInactivity;
    }

    public void setValidateAfterInactivity(int validateAfterInactivity) {
        this.validateAfterInactivity = validateAfterInactivity;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
    }

    public int getTimeoutConnection() {
        return this.timeoutConnection;
    }

    public void setTimeoutConnection(int timeoutConnection) {
        this.timeoutConnection = timeoutConnection;
    }

    public int getTimeoutSocket() {
        return this.timeoutSocket;
    }

    public void setTimeoutSocket(int timeoutSocket) {
        this.timeoutSocket = timeoutSocket;
    }

    public int getRetryTime() {
        return this.retryTime;
    }

    public void setRetryTime(int retryTime) {
        this.retryTime = retryTime;
    }

    private SSLConnectionSocketFactory buildSSLConnectionSocketFactory() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException, UnrecoverableKeyException {
        Object hostnameVerifier;
        if (this.pemCert != null && !this.pemCert.equals("")) {
            Certificate trustedCa;
            if (!this.pemCert.endsWith(".crt")) {
                SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(SSLHelper.initSSLConfig("TLS", this.pemKey, this.pemkeyPassword, this.pemCert, this.pemtrustedCA), this._supportedProtocols, null, this.hostnameVerifier);
                return sslsf;
            }
            Path caCertificatePath = Paths.get(this.pemCert, new String[0]);
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            try (InputStream is = Files.newInputStream(caCertificatePath, new OpenOption[0]);){
                trustedCa = factory.generateCertificate(is);
            }
            KeyStore trustStore = KeyStore.getInstance("pkcs12");
            trustStore.load(null, null);
            trustStore.setCertificateEntry("ca", trustedCa);
            SSLContextBuilder sslContextBuilder = SSLContexts.custom().loadTrustMaterial(trustStore, null);
            return new SSLConnectionSocketFactory(sslContextBuilder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        if (this.keystore == null || this.keystore.equals("")) {
            if (this.truststore == null || this.truststore.equals("")) {
                SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
                sslContextBuilder.loadTrustMaterial(null, new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        return true;
                    }
                });
                return new SSLConnectionSocketFactory(sslContextBuilder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            }
            Path trustStorePath = Paths.get(this.truststore, new String[0]);
            KeyStore keyTruststore = KeyStore.getInstance(this.truststore.endsWith("p12") ? "pkcs12" : "JKS");
            try (InputStream is = Files.newInputStream(trustStorePath, new OpenOption[0]);){
                keyTruststore.load(is, this.trustPassword == null || this.trustPassword.length() == 0 ? null : this.trustPassword.toCharArray());
            }
            SSLContextBuilder sslBuilder = SSLContexts.custom().loadTrustMaterial(keyTruststore, null);
            return new SSLConnectionSocketFactory(sslBuilder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        Object object = hostnameVerifier = this.hostnameVerifier != null ? this.hostnameVerifier : NoopHostnameVerifier.INSTANCE;
        if (this.truststore == null || this.truststore.equals("")) {
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(SSLHelper.initSSLConfig(this.keystore, this.keyPassword), this._supportedProtocols, null, (HostnameVerifier)hostnameVerifier);
            return sslsf;
        }
        if (!this.truststore.endsWith(".p12")) {
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(SSLHelper.initSSLConfig("TLS", this.keystore, "JKS", this.keyPassword, this.keystoreAlias, this.truststore, "JKS", this.trustPassword, this.trustAlias), this._supportedProtocols, null, (HostnameVerifier)hostnameVerifier);
            return sslsf;
        }
        Path trustStorePath = Paths.get(this.truststore, new String[0]);
        Path keyStorePath = Paths.get(this.keystore, new String[0]);
        KeyStore trustStore = KeyStore.getInstance("pkcs12");
        KeyStore keyStore = KeyStore.getInstance("pkcs12");
        try (InputStream is = Files.newInputStream(trustStorePath, new OpenOption[0]);){
            trustStore.load(is, this.trustPassword == null || this.trustPassword.length() == 0 ? null : this.trustPassword.toCharArray());
        }
        is = Files.newInputStream(keyStorePath, new OpenOption[0]);
        try {
            keyStore.load(is, this.keyPassword == null || this.keyPassword.length() == 0 ? null : this.keyPassword.toCharArray());
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        SSLContextBuilder sslBuilder = SSLContexts.custom().loadTrustMaterial(trustStore, null).loadKeyMaterial(keyStore, this.keyPassword == null || this.keyPassword.length() == 0 ? null : this.keyPassword.toCharArray());
        return new SSLConnectionSocketFactory(sslBuilder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
    }

    public final CloseableHttpClient getHttpClient() throws Exception {
        if (this.httpclient != null) {
            return this.httpclient;
        }
        SSLConnectionSocketFactory SSLConnectionSocketFactory2 = this.buildSSLConnectionSocketFactory();
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)SSLConnectionSocketFactory2).build();
        SystemDefaultDnsResolver dnsResolver = new SystemDefaultDnsResolver(){

            public InetAddress[] resolve(String host) throws UnknownHostException {
                if (host.equalsIgnoreCase("localhost")) {
                    return new InetAddress[]{InetAddress.getByAddress(new byte[]{127, 0, 0, 1})};
                }
                return super.resolve(host);
            }
        };
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry, null, null, (DnsResolver)dnsResolver, (long)this.timeToLive, TimeUnit.MILLISECONDS);
        SocketConfig socketConfig = SocketConfig.custom().setTcpNoDelay(true).setSoTimeout(this.timeoutSocket).setSoKeepAlive(this.soKeepAlive.booleanValue()).setSoReuseAddress(this.soReuseAddress.booleanValue()).build();
        connManager.setDefaultSocketConfig(socketConfig);
        connManager.setValidateAfterInactivity(this.validateAfterInactivity);
        connManager.setMaxTotal(this.maxTotal);
        connManager.setDefaultMaxPerRoute(this.defaultMaxPerRoute);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.timeoutConnection).setConnectionRequestTimeout(this.connectionRequestTimeout).setSocketTimeout(this.timeoutSocket).setStaleConnectionCheckEnabled(this.staleConnectionCheckEnabled).build();
        HttpClientBuilder builder = HttpClients.custom();
        if (this.kerberosConfig != null) {
            if (this.requestKerberosUrlUtils == null) {
                this.requestKerberosUrlUtils = SimpleStringUtil.isNotEmpty((String)this.kerberosConfig.getServerRealmPath()) || SimpleStringUtil.isNotEmpty((String)this.kerberosConfig.getServerRealm()) ? new ServerRealmRequestKerberosUrlUtils(this.kerberosConfig, this) : (this.kerberosConfig.getConfigMode() == 1 ? new RequestKerberosUrlUtilsParams(this.kerberosConfig, this) : new RequestKerberosUrlUtilsJaasLoginConfig(this.kerberosConfig, this));
            }
            this.requestKerberosUrlUtils.buildSpengoHttpClient(builder);
        } else {
            this.initCredentialsProvider(builder);
        }
        if (this.evictExpiredConnections) {
            builder.evictExpiredConnections();
        }
        if (this.keepAlive > 0L) {
            HttpConnectionKeepAliveStrategy httpConnectionKeepAliveStrategy = new HttpConnectionKeepAliveStrategy(this.keepAlive);
            builder.setConnectionManager((HttpClientConnectionManager)connManager).setDefaultRequestConfig(requestConfig).setKeepAliveStrategy((ConnectionKeepAliveStrategy)httpConnectionKeepAliveStrategy);
        } else {
            builder.setConnectionManager((HttpClientConnectionManager)connManager).setDefaultRequestConfig(requestConfig);
        }
        this.buildRetryHandler(builder);
        this.customizeHttpBuilder(builder);
        this.httpclient = builder.build();
        if (this.beanName.equals("default")) {
            defaultRequestConfig = requestConfig;
        }
        clientConfigs.put(this.beanName, this);
        return this.httpclient;
    }

    public void afterStart() {
        if (this.requestKerberosUrlUtils != null) {
            this.requestKerberosUrlUtils.afterStart();
        }
    }

    private void customizeHttpBuilder(HttpClientBuilder builder) throws Exception {
        HttpClientBuilderCallback _httpClientBuilderCallback = null;
        if (this.getHttpClientBuilderCallback() != null) {
            if (this.httpClientBuilderCallback instanceof String) {
                _httpClientBuilderCallback = (HttpClientBuilderCallback)Class.forName((String)this.httpClientBuilderCallback).newInstance();
            } else if (this.httpClientBuilderCallback instanceof HttpClientBuilderCallback) {
                _httpClientBuilderCallback = (HttpClientBuilderCallback)this.httpClientBuilderCallback;
            }
            _httpClientBuilderCallback.customizeHttpClient(builder, this);
        }
        if (SimpleStringUtil.isNotEmpty((Object)this.getHttpRequestInterceptors())) {
            final String[] tmp = ((String)this.getHttpRequestInterceptors()).split(",");
            HttpClientBuilderCallback httpClientBuilderCallback = new HttpClientBuilderCallback(){

                @Override
                public HttpClientBuilder customizeHttpClient(HttpClientBuilder builder, ClientConfiguration clientConfiguration) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
                    for (String i : tmp) {
                        HttpRequestInterceptor httpRequestInterceptor = (HttpRequestInterceptor)Class.forName(i).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        builder.addInterceptorLast(httpRequestInterceptor);
                    }
                    return builder;
                }
            };
            httpClientBuilderCallback.customizeHttpClient(builder, this);
        }
        if (this.requestKerberosUrlUtils != null) {
            this.requestKerberosUrlUtils.customizeHttpClient(builder, this);
        }
    }

    private void initCredentialsProvider(HttpClientBuilder builder) {
        if (this.getAuthAccount() != null) {
            if (!this.isBackoffAuth()) {
                CredentialsProvider credentialsProvider = null;
                ClassUtil.ClassInfo classInfo = ClassUtil.getClassInfo(builder.getClass());
                credentialsProvider = (CredentialsProvider)classInfo.getPropertyValue((Object)builder, "credentialsProvider");
                if (credentialsProvider == null) {
                    credentialsProvider = new BasicCredentialsProvider();
                    credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.getAuthAccount(), this.getAuthPassword()));
                    builder.setDefaultCredentialsProvider(credentialsProvider);
                }
            } else {
                BasicHeader header = new BasicHeader("Authorization", ClientConfiguration.getHeader(this.encodedAuthCharset, this.getAuthAccount(), this.getAuthPassword()));
                ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
                headers.add(header);
                builder.setDefaultHeaders(headers);
            }
        } else if (SimpleStringUtil.isNotEmpty((String)this.getApiKeyId())) {
            String apiKeyAuth = ClientConfiguration.getAPIHeader(this.encodedAuthCharset, this.apiKeyId, this.apiKeySecret);
            BasicHeader header = new BasicHeader("Authorization", apiKeyAuth);
            ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
            headers.add(header);
            builder.setDefaultHeaders(headers);
        }
    }

    public static String getHeader(String encodedAuthCharset, String user, String password) {
        String auth = user + ":" + password;
        if (encodedAuthCharset != null && !encodedAuthCharset.equals("")) {
            byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(Charset.forName(encodedAuthCharset)));
            return "Basic " + new String(encodedAuth);
        }
        byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes());
        return "Basic " + new String(encodedAuth);
    }

    public static String getAPIHeader(String encodedAuthCharset, String apiKeyId, String apiKeySecret) {
        if (SimpleStringUtil.isNotEmpty((String)apiKeySecret)) {
            String auth = apiKeyId + ":" + apiKeySecret;
            if (encodedAuthCharset != null && !encodedAuthCharset.equals("")) {
                byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(Charset.forName(encodedAuthCharset)));
                return "ApiKey " + new String(encodedAuth);
            }
            byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.UTF_8));
            return "ApiKey " + new String(encodedAuth);
        }
        return "Bearer " + apiKeyId;
    }

    private void buildRetryHandler(HttpClientBuilder builder) {
        if (this.automaticRetriesDisabled) {
            builder.disableAutomaticRetries();
        } else {
            CustomHttpRequestRetryHandler customHttpRequestRetryHandler = null;
            if (this.customHttpRequestRetryHandler != null && !this.customHttpRequestRetryHandler.trim().equals("")) {
                try {
                    customHttpRequestRetryHandler = (CustomHttpRequestRetryHandler)Class.forName(this.customHttpRequestRetryHandler).newInstance();
                }
                catch (Exception e) {
                    logger.error("Create CustomHttpRequestRetryHandler[" + this.customHttpRequestRetryHandler + "] failed:", (Throwable)e);
                    customHttpRequestRetryHandler = null;
                }
            }
            HttpRequestRetryHandlerHelper httpRequestRetryHandlerHelper = new HttpRequestRetryHandlerHelper(customHttpRequestRetryHandler, this);
            builder.setRetryHandler((HttpRequestRetryHandler)httpRequestRetryHandlerHelper);
        }
    }

    public HttpClient _getHttpclient() {
        return this.httpclient;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
    }

    public int getDefaultMaxPerRoute() {
        return this.defaultMaxPerRoute;
    }

    public void setDefaultMaxPerRoute(int defaultMaxPerRoute) {
        this.defaultMaxPerRoute = defaultMaxPerRoute;
    }

    public void afterPropertiesSet() throws Exception {
        this._supportedProtocols = this.supportedProtocols != null && !this.supportedProtocols.equals("") ? this.supportedProtocols.split(",") : this.defaultSupportedProtocols;
        this.getHttpClient();
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public RequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public void setMaxLineLength(int maxLineLength) {
        this.maxLineLength = maxLineLength;
    }

    public int getMaxHeaderCount() {
        return this.maxHeaderCount;
    }

    public void setMaxHeaderCount(int maxHeaderCount) {
        this.maxHeaderCount = maxHeaderCount;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public long getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(long keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean isStaleConnectionCheckEnabled() {
        return this.staleConnectionCheckEnabled;
    }

    public void setStaleConnectionCheckEnabled(boolean staleConnectionCheckEnabled) {
        this.staleConnectionCheckEnabled = staleConnectionCheckEnabled;
    }

    public String getCustomHttpRequestRetryHandler() {
        return this.customHttpRequestRetryHandler;
    }

    public void setCustomHttpRequestRetryHandler(String customHttpRequestRetryHandler) {
        this.customHttpRequestRetryHandler = customHttpRequestRetryHandler;
    }

    public String getHostnameVerifierString() {
        return this.hostnameVerifierString;
    }

    public void setHostnameVerifierString(String hostnameVerifierString) {
        this.hostnameVerifierString = hostnameVerifierString;
    }

    public GetProperties getContextProperties() {
        return this.contextProperties;
    }

    public void setContextProperties(GetProperties contextProperties) {
        this.contextProperties = contextProperties;
    }

    public String getTruststore() {
        return this.truststore;
    }

    public void setTruststore(String truststore) {
        this.truststore = truststore;
    }

    public String getTrustPassword() {
        return this.trustPassword;
    }

    public void setTrustPassword(String trustPassword) {
        this.trustPassword = trustPassword;
    }

    public String getKeystoreAlias() {
        return this.keystoreAlias;
    }

    public void setKeystoreAlias(String keystoreAlias) {
        this.keystoreAlias = keystoreAlias;
    }

    public String getTrustAlias() {
        return this.trustAlias;
    }

    public void setTrustAlias(String trustAlias) {
        this.trustAlias = trustAlias;
    }

    public String getPemCert() {
        return this.pemCert;
    }

    public void setPemCert(String pemCert) {
        this.pemCert = pemCert;
    }

    public String getPemtrustedCA() {
        return this.pemtrustedCA;
    }

    public void setPemtrustedCA(String pemtrustedCA) {
        this.pemtrustedCA = pemtrustedCA;
    }

    public String getPemKey() {
        return this.pemKey;
    }

    public void setPemKey(String pemKey) {
        this.pemKey = pemKey;
    }

    public String getPemkeyPassword() {
        return this.pemkeyPassword;
    }

    public void setPemkeyPassword(String pemkeyPassword) {
        this.pemkeyPassword = pemkeyPassword;
    }

    public boolean isAutomaticRetriesDisabled() {
        return this.automaticRetriesDisabled;
    }

    public void setAutomaticRetriesDisabled(boolean automaticRetriesDisabled) {
        this.automaticRetriesDisabled = automaticRetriesDisabled;
    }

    public boolean isBackoffAuth() {
        return this.backoffAuth;
    }

    public void setBackoffAuth(boolean backoffAuth) {
        this.backoffAuth = backoffAuth;
    }

    static {
        clientConfigs = new ConcurrentHashMap<String, ClientConfiguration>();
    }
}

