/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.remote.http.kerberos.serverrealm;

import com.frameworkset.util.SimpleStringUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.AppConfigurationEntry;
import org.frameworkset.spi.remote.http.ClientConfiguration;
import org.frameworkset.spi.remote.http.HttpRequestProxy;
import org.frameworkset.spi.remote.http.kerberos.KerberosConfig;
import org.frameworkset.spi.remote.http.kerberos.KerberosHelper;
import org.frameworkset.spi.remote.http.kerberos.serverrealm.ServerRealmKerberosThreadLocal;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerRealmKerberosUtil {
    private static final Logger logger = LoggerFactory.getLogger(ServerRealmKerberosUtil.class);
    private String serverRealm;
    private Subject subject = null;
    private final Object subjectLock = new Object();
    private ClientConfiguration clientConfiguration;
    private KerberosConfig kerberosConfig;
    private RefreshTgtTool refreshTgtTool;
    private String serverRealmPath = "/elasticsearch/serverrealm";
    private String serverRealmHttpMethod = "get";
    private final Map<String, String> kerberosOptions = new HashMap<String, String>(6);
    private GSSCredential credentials = null;

    public ServerRealmKerberosUtil(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
        this.kerberosConfig = clientConfiguration.getKerberosConfig();
        if (SimpleStringUtil.isNotEmpty((String)this.kerberosConfig.getServerRealmPath())) {
            this.serverRealmPath = this.kerberosConfig.getServerRealmPath();
        }
        if (SimpleStringUtil.isNotEmpty((String)this.kerberosConfig.getServerRealmHttpMethod())) {
            this.serverRealmHttpMethod = this.kerberosConfig.getServerRealmHttpMethod();
        }
        if (SimpleStringUtil.isNotEmpty((String)this.kerberosConfig.getServerRealm())) {
            this.handleRealm(this.kerberosConfig.getServerRealm());
        }
    }

    public Subject getSubject() {
        return this.subject;
    }

    public String getServerRealm() {
        return this.serverRealm;
    }

    public void setCredentials(GSSCredential credentials) {
        this.credentials = credentials;
    }

    private GSSContext getGssContext(String servicePrincipalName) throws GSSException {
        GSSManager manager = GSSManager.getInstance();
        GSSName serverName = manager.createName(servicePrincipalName, new Oid("1.2.840.113554.1.2.2.1"));
        Oid oid = new Oid("1.3.6.1.5.5.2");
        GSSContext context = manager.createContext(serverName.canonicalize(oid), oid, this.credentials, 0);
        return context;
    }

    public synchronized byte[] initiateSecurityContext(Subject subject, final String servicePrincipalName) {
        byte[] token = Subject.doAs(subject, new PrivilegedAction<byte[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] run() {
                GSSContext context = null;
                try {
                    byte[] token;
                    context = ServerRealmKerberosUtil.this.getGssContext(servicePrincipalName);
                    context.requestMutualAuth(true);
                    context.requestCredDeleg(true);
                    byte[] tokenNew = new byte[]{};
                    byte[] byArray = token = context.initSecContext(tokenNew, 0, tokenNew.length);
                    return byArray;
                }
                catch (GSSException gssException) {
                    if (logger.isErrorEnabled()) {
                        logger.error("Init secure context failed.", (Throwable)gssException);
                    }
                }
                finally {
                    block14: {
                        if (context != null) {
                            try {
                                context.dispose();
                            }
                            catch (GSSException gssException) {
                                if (!logger.isErrorEnabled()) break block14;
                                logger.error("Dispose secure context failed.", (Throwable)gssException);
                            }
                        }
                    }
                }
                return null;
            }
        });
        return token;
    }

    private void initKerberosOptions(KerberosConfig kerberosConfig) {
        this.kerberosOptions.clear();
        AppConfigurationEntry[] appConfigurationEntries = this.getAppConfigurationEntry(kerberosConfig);
        if (appConfigurationEntries != null && appConfigurationEntries.length > 0) {
            for (AppConfigurationEntry entry : appConfigurationEntries) {
                this.kerberosOptions.putAll(entry.getOptions());
            }
        } else {
            if (logger.isErrorEnabled()) {
                logger.error("Can not get kerberos app configuration entry from jaas conf file.");
            }
            throw new IllegalArgumentException("Can not get kerberos app configuration entry from jaas conf file.");
        }
    }

    private AppConfigurationEntry[] getAppConfigurationEntry(KerberosConfig kerberosConfig) {
        if (logger.isInfoEnabled()) {
            logger.info(String.format(Locale.ENGLISH, "Try to read the jaas configuration entry again, app name is %s.", kerberosConfig.getLoginContextName()));
        }
        AppConfigurationEntry[] entries = KerberosHelper.getAppConfigurationEntry(kerberosConfig);
        if (logger.isInfoEnabled()) {
            logger.info("Read application configuration entry from kerberos jaas conf file.");
        }
        return entries;
    }

    private synchronized KerberosTicket getKerberosTicket(Subject subject) {
        Object privateCredential;
        KerberosTicket kerberosTicket = null;
        if (null == subject) {
            if (logger.isDebugEnabled()) {
                logger.debug("The subject is invalid.");
            }
            return null;
        }
        Set<Object> privateCredentials = subject.getPrivateCredentials();
        if (null == privateCredentials) {
            if (logger.isDebugEnabled()) {
                logger.debug("The privateCredentials is null.");
            }
            return null;
        }
        Iterator<Object> iterator = privateCredentials.iterator();
        do {
            if (iterator.hasNext()) continue;
            return kerberosTicket;
        } while (!((privateCredential = iterator.next()) instanceof KerberosTicket));
        kerberosTicket = (KerberosTicket)privateCredential;
        return kerberosTicket;
    }

    private long getTgtValidityPeriod(KerberosTicket kerberosTicket) {
        Date endTime = kerberosTicket.getEndTime();
        Date startTime = kerberosTicket.getStartTime();
        return null != endTime && null != startTime ? endTime.getTime() - startTime.getTime() : -1L;
    }

    public synchronized boolean subjectWillExpire(Subject subject) {
        if (null != subject && null != subject.getPrincipals() && null != subject.getPrivateCredentials()) {
            KerberosTicket kerberosTicket = this.getKerberosTicket(subject);
            if (null == kerberosTicket) {
                if (logger.isDebugEnabled()) {
                    logger.debug("The kerberosTicket is null.");
                }
                return true;
            }
            long tgtWillExpireTime = null == kerberosTicket.getEndTime() ? -1L : kerberosTicket.getEndTime().getTime();
            long tgtValidityPeriod = this.getTgtValidityPeriod(kerberosTicket);
            if (tgtWillExpireTime > 0L && tgtWillExpireTime >= System.currentTimeMillis() && tgtValidityPeriod > 0L) {
                boolean willExpired;
                boolean bl = willExpired = (double)(tgtWillExpireTime - System.currentTimeMillis()) < (double)tgtValidityPeriod * 0.25;
                if (willExpired && logger.isDebugEnabled()) {
                    logger.debug("TGT will expire!");
                }
                return willExpired;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("TgtWillExpireTime is invalid.");
            }
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("The subject is invalid.");
        }
        return true;
    }

    public synchronized void getTGT() {
        try {
            if (this.kerberosOptions.isEmpty()) {
                this.initKerberosOptions(this.kerberosConfig);
                if (this.kerberosOptions.isEmpty()) {
                    if (logger.isErrorEnabled()) {
                        logger.error("Please generate KerberosClient loginContext in jaas.conf file for kerberos to get TGT.");
                    }
                    throw new IllegalArgumentException("KerberosClient loginContext is not configured properly in jaas.conf file,please set the correct content.");
                }
            }
            Subject loginSubject = new Subject();
            boolean isIbmJdk = System.getProperty("java.vendor").contains("IBM");
            Class<?> clazz = null;
            String className = null;
            if (isIbmJdk) {
                className = "com.ibm.security.auth.module.Krb5LoginModule";
                if (logger.isInfoEnabled()) {
                    logger.info("JDK version is IBM");
                }
            } else {
                className = "com.sun.security.auth.module.Krb5LoginModule";
                if (logger.isInfoEnabled()) {
                    logger.info("JDK version is SUN");
                }
            }
            clazz = Class.forName(className);
            Method initialize = clazz.getDeclaredMethod("initialize", Subject.class, CallbackHandler.class, Map.class, Map.class);
            Method login = clazz.getDeclaredMethod("login", new Class[0]);
            Method commit = clazz.getDeclaredMethod("commit", new Class[0]);
            Object krb5LoginModule = clazz.newInstance();
            initialize.invoke(krb5LoginModule, loginSubject, null, null, this.kerberosOptions);
            login.invoke(krb5LoginModule, new Object[0]);
            commit.invoke(krb5LoginModule, new Object[0]);
            this.subject = loginSubject;
            if (logger.isInfoEnabled()) {
                logger.info("Get kerberos TGT successfully.");
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            if (logger.isErrorEnabled()) {
                logger.error("Get kerberos TGT failed.", (Throwable)exception);
            }
            throw new RuntimeException(exception);
        }
    }

    private long getRefreshTime(KerberosTicket tgt) {
        long proposedRefresh;
        long start = tgt.getStartTime().getTime();
        long expires = tgt.getEndTime().getTime();
        DateFormat formatter = this.getDateFormat();
        if (logger.isInfoEnabled()) {
            logger.info("TGT valid starting at:        {}\r\nTGT expires:                  {}", (Object)formatter.format(tgt.getStartTime()), (Object)formatter.format(tgt.getEndTime()));
        }
        return (proposedRefresh = start + (long)((float)(expires - start) * 0.8f)) > expires ? System.currentTimeMillis() : proposedRefresh;
    }

    private DateFormat getDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    }

    public long getNextRefreshTime(long localCurrentTime, Subject subj) throws Exception {
        KerberosTicket kerberosTicket = this.getKerberosTicket(subj);
        DateFormat formatter = this.getDateFormat();
        if (kerberosTicket == null) {
            Date nextRefreshDate = new Date(localCurrentTime);
            if (logger.isWarnEnabled()) {
                logger.warn("No TGT found: will try again at {}", (Object)formatter.format(nextRefreshDate));
            }
            return localCurrentTime;
        }
        long nextRefreshTime = this.getRefreshTime(kerberosTicket);
        long expiry = kerberosTicket.getEndTime().getTime();
        Date expiryDate = new Date(expiry);
        if (kerberosTicket.getEndTime().equals(kerberosTicket.getRenewTill())) {
            String timeStr = formatter.format(expiryDate);
            if (logger.isErrorEnabled()) {
                logger.error("The TGT cannot be renewed beyond the next expiry date: {}.This process will not be able to authenticate new SASL connections after that time (for example, it will not be authenticate a new connection with a Zookeeper Quorum member).  Ask your system administrator to either increase the 'renew until' time by doing : 'modprinc -maxrenewlife username within kadmin, or instead, to generate a keytab for username. Because the TGT's expiry cannot be further extended by refreshing", (Object)timeStr);
            }
            throw new Exception("The TGT cannot be renewed beyond the next expiry date: " + timeStr);
        }
        if (nextRefreshTime < localCurrentTime + 60000L) {
            Date until = new Date(nextRefreshTime);
            Date newuntil = new Date(localCurrentTime + 60000L);
            nextRefreshTime = localCurrentTime + 60000L;
            if (logger.isWarnEnabled()) {
                logger.warn("TGT refresh thread time adjusted from : {} to : {} since the former is sooner than the minimum refresh interval ({} seconds) from now.", new Object[]{formatter.format(until), formatter.format(newuntil), 60L});
            }
        }
        if (nextRefreshTime > expiry) {
            if (logger.isInfoEnabled()) {
                logger.info("refreshing now because expiry is before next scheduled refresh time.");
            }
            return localCurrentTime;
        }
        return nextRefreshTime;
    }

    private void getTGTwithRetry() throws InterruptedException {
        int count = 1;
        DateFormat formatter = this.getDateFormat();
        while (count <= 3) {
            try {
                this.getTGT();
                if (!logger.isInfoEnabled()) break;
                logger.info("TGT refresh at: {}", (Object)formatter.format(new Date(System.currentTimeMillis())));
                break;
            }
            catch (Exception var2) {
                if (count < 3) {
                    ++count;
                    Thread.sleep(10000L);
                    continue;
                }
                if (!logger.isErrorEnabled()) continue;
                logger.error("Could not refresh TGT ", (Throwable)var2);
            }
        }
    }

    public void close() {
        if (this.refreshTgtTool != null) {
            this.refreshTgtTool.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticate() {
        int times = 0;
        Object object = this.subjectLock;
        synchronized (object) {
            if (this.refreshTgtTool == null) {
                this.refreshTgtTool = new RefreshTgtTool(this.kerberosConfig);
                this.refreshTgtTool.startRefreshThread();
            }
            while (this.subjectWillExpire(this.subject) && times < 3) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Subject is not ok ,retry get new TGT.");
                }
                this.getTGT();
                ++times;
            }
        }
        if (SimpleStringUtil.isNotEmpty((String)this.serverRealm)) {
            return;
        }
        String realm = null;
        try {
            ServerRealmKerberosThreadLocal.setAuthenticateLocal();
            realm = SimpleStringUtil.isEmpty((String)this.serverRealmHttpMethod) || this.serverRealmHttpMethod.equalsIgnoreCase("get") ? HttpRequestProxy.httpGetforString(this.clientConfiguration, this.serverRealmPath) : (this.serverRealmHttpMethod.equalsIgnoreCase("post") ? HttpRequestProxy.httpPostforString(this.clientConfiguration, this.serverRealmPath) : HttpRequestProxy.httpGetforString(this.clientConfiguration, this.serverRealmPath));
        }
        finally {
            ServerRealmKerberosThreadLocal.clearAuthenticateLocal();
        }
        if (realm != null && !realm.isEmpty()) {
            this.handleRealm(realm);
            if (logger.isInfoEnabled()) {
                logger.info("Initialize the client successfully.");
            }
        } else {
            throw new IllegalArgumentException("Get ServerRealm failed.");
        }
    }

    private void handleRealm(String realm) {
        this.serverRealm = realm.toLowerCase(Locale.ENGLISH).indexOf("@") > 0 ? realm : (realm.toLowerCase(Locale.ENGLISH).startsWith("elasticsearch/hadoop.") ? realm : "elasticsearch/hadoop." + realm.toLowerCase(Locale.ENGLISH) + "@" + realm.toUpperCase(Locale.ENGLISH));
    }

    public class RefreshTgtTool {
        private volatile ExecutorService refreshTgtService;
        private KerberosConfig kerberosConfig;

        private RefreshTgtTool(KerberosConfig kerberosConfig) {
            this.kerberosConfig = kerberosConfig;
        }

        public void shutdown() {
            block3: {
                if (this.refreshTgtService != null) {
                    try {
                        this.refreshTgtService.shutdown();
                    }
                    catch (Exception e) {
                        if (!logger.isWarnEnabled()) break block3;
                        logger.warn("Shutdown kerberos RefreshTGTThread ThreadPool failed:", (Throwable)e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void startRefreshThread() {
            if (this.refreshTgtService != null) return;
            Class<RefreshTgtTool> clazz = RefreshTgtTool.class;
            synchronized (RefreshTgtTool.class) {
                if (this.refreshTgtService == null) {
                    this.refreshTgtService = Executors.newFixedThreadPool(1, new ThreadFactory(){

                        @Override
                        public Thread newThread(Runnable r) {
                            Thread t = Executors.defaultThreadFactory().newThread(r);
                            t.setDaemon(true);
                            t.setName("RefreshTGTThread");
                            return t;
                        }
                    });
                }
                this.refreshTgtService.submit(new RefreshTgtThread(this.kerberosConfig));
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }

    public class RefreshTgtThread
    implements Runnable {
        private KerberosConfig kerberosConfig;

        RefreshTgtThread(KerberosConfig kerberosConfig) {
            this.kerberosConfig = kerberosConfig;
        }

        @Override
        public void run() {
            if (logger.isInfoEnabled()) {
                logger.info("TGT refresh thread started");
            }
            DateFormat formatter = ServerRealmKerberosUtil.this.getDateFormat();
            while (true) {
                try {
                    while (true) {
                        long nextRefresh;
                        long localCurrentTime;
                        if ((localCurrentTime = System.currentTimeMillis()) <= (nextRefresh = ServerRealmKerberosUtil.this.getNextRefreshTime(localCurrentTime, ServerRealmKerberosUtil.this.subject))) {
                            Date until = new Date(nextRefresh);
                            if (logger.isInfoEnabled()) {
                                logger.info("TGT refresh sleeping until: {}", (Object)formatter.format(until));
                            }
                            Thread.sleep(nextRefresh - localCurrentTime);
                        } else if (logger.isWarnEnabled()) {
                            logger.warn("nextRefresh:{} is in the past: exiting refresh thread. Check clock sync between this host and KDC - (KDC's clock is likely ahead of this host). Manual intervention will be required for this client to successfully authenticate. In case of TGT being expiring, try to refresh TGT right now.", (Object)formatter.format(new Date(nextRefresh)));
                        }
                        ServerRealmKerberosUtil.this.getTGTwithRetry();
                    }
                }
                catch (Exception exception) {
                    if (!logger.isErrorEnabled()) continue;
                    logger.error("Failed to refresh TGT: refresh thread exiting now.", (Throwable)exception);
                    continue;
                }
                break;
            }
        }
    }
}

