/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.remote.http.kerberos.serverrealm;

import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.impl.client.HttpClientBuilder;
import org.frameworkset.spi.remote.http.ClientConfiguration;
import org.frameworkset.spi.remote.http.kerberos.BaseRequestKerberosUrlUtils;
import org.frameworkset.spi.remote.http.kerberos.KerberosCallException;
import org.frameworkset.spi.remote.http.kerberos.KerberosCallback;
import org.frameworkset.spi.remote.http.kerberos.KerberosConfig;
import org.frameworkset.spi.remote.http.kerberos.serverrealm.ServerRealmClientHelper;
import org.frameworkset.spi.remote.http.kerberos.serverrealm.ServerRealmKerberosHttpRequestInterceptor;
import org.frameworkset.spi.remote.http.kerberos.serverrealm.ServerRealmKerberosHttpResponseInterceptor;

public class ServerRealmRequestKerberosUrlUtils
extends BaseRequestKerberosUrlUtils {
    private ServerRealmClientHelper serverRealmClientHelper;

    public ServerRealmRequestKerberosUrlUtils(KerberosConfig kerberosConfig, ClientConfiguration clientConfiguration) {
        super(kerberosConfig, clientConfiguration);
        this.serverRealmClientHelper = new ServerRealmClientHelper(clientConfiguration);
    }

    @Override
    protected Subject getSubject() throws LoginException {
        return this.serverRealmClientHelper.getSubject();
    }

    @Override
    public HttpClientBuilder customizeHttpClient(HttpClientBuilder builder, ClientConfiguration clientConfiguration) throws Exception {
        builder.addInterceptorLast((HttpRequestInterceptor)new ServerRealmKerberosHttpRequestInterceptor(this.serverRealmClientHelper));
        builder.addInterceptorLast((HttpResponseInterceptor)new ServerRealmKerberosHttpResponseInterceptor(this.serverRealmClientHelper));
        return builder;
    }

    @Override
    public <T> T callRestUrl(KerberosCallback<T> kerberosCallback) throws Exception {
        try {
            return kerberosCallback.call();
        }
        catch (KerberosCallException le) {
            throw (Exception)le.getCause();
        }
        catch (Exception le) {
            throw le;
        }
    }

    @Override
    public void afterStart() {
        this.serverRealmClientHelper.authenticate();
    }

    @Override
    public void close() {
        this.serverRealmClientHelper.close();
    }
}

